/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.storage;

import com.gridnine.xtrip.common.gds.model.CommonAirlineSettings;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import com.gridnine.xtrip.server.model.licence2.AppConfiguration;
import com.gridnine.xtrip.server.model.rules.RulesOptimizationHelper;

public class GdsRulesOptimizationInterceptor
implements EntityInterceptor {
    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
        if (!AppConfiguration.get().isOnlineGdsEnabled()) {
            return;
        }
        BaseEntity entity = data.getEntity();
        if (entity instanceof SalesPoint) {
            SalesPoint salesPoint = (SalesPoint)entity;
            RulesOptimizationHelper.optimize((RuleSet)salesPoint.getRuleSet());
        } else if (entity instanceof CommonAirlineSettings) {
            CommonAirlineSettings settings = (CommonAirlineSettings)entity;
            RulesOptimizationHelper.optimize((RuleSet)settings.getRuleSet());
        }
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
    }

    public double getPriority() {
        return 0.0;
    }
}

