/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.storage;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.gds.SpecialTariff;
import com.gridnine.xtrip.common.model.gds.SpecialTariffIndex;
import com.gridnine.xtrip.common.model.gds.SpecialTariffIndexData;
import com.gridnine.xtrip.common.model.util.EntityReference2CaptionTransformer;
import com.gridnine.xtrip.common.model.util.EntityReference2UidTransformer;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import java.util.Collection;
import java.util.List;

public class SpecialTariffIndexHandler
implements IndexHandler<SpecialTariff, SpecialTariffIndex> {
    public Class<? extends BaseIndexData<SpecialTariff, SpecialTariffIndex>> getDataClass() {
        return SpecialTariffIndexData.class;
    }

    public Class<SpecialTariffIndex> getIndexClass() {
        return SpecialTariffIndex.class;
    }

    public Class<SpecialTariff> getEntityType() {
        return SpecialTariff.class;
    }

    public void create(EntityContainer<SpecialTariff> etc, Collection<BaseIndexData<SpecialTariff, SpecialTariffIndex>> indexes) {
        SpecialTariff item = (SpecialTariff)etc.getEntity();
        SpecialTariffIndexData data = new SpecialTariffIndexData();
        this.updateIndexData(data, item);
        indexes.add((BaseIndexData<SpecialTariff, SpecialTariffIndex>)data);
    }

    protected void updateIndexData(SpecialTariffIndexData data, SpecialTariff item) {
        data.setName(item.getName());
        data.setStartDate(item.getStartDate());
        data.setEndDate(item.getEndDate());
        data.setRoute(item.getRoute());
        List gdsAccountUids = CollectionUtil.transform((CollectionUtil.ItemTransformer)new EntityReference2UidTransformer(), (Collection)item.getGdsAccounts(), (boolean)true);
        List gdsAccountNames = CollectionUtil.transform((CollectionUtil.ItemTransformer)new EntityReference2CaptionTransformer(), (Collection)item.getGdsAccounts(), (boolean)true);
        data.setGdsAccountUids((Collection)gdsAccountUids);
        data.setGdsAccountNames((Collection)gdsAccountNames);
        data.setAirline(item.getAirline());
        data.setPassengerTypes((Collection)item.getPassengerTypes());
        data.setDescription(item.getDescription());
        DataAggregator aggregator = new DataAggregator();
        aggregator.aggregate((Object)item.getName());
        aggregator.aggregate(item.getStartDate());
        aggregator.aggregate(item.getEndDate());
        aggregator.aggregate((Object)item.getRoute());
        aggregator.aggregate((Iterable)gdsAccountNames);
        aggregator.aggregate((Object)item.getAirline());
        aggregator.aggregate((Iterable)item.getPassengerTypes());
        data.setAggregatedData(aggregator.toString());
    }
}

