/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.tasks;

import com.gridnine.xtrip.server.BaseScheduledTask;
import com.gridnine.xtrip.server.gds.ClassOfServiceTable;
import com.gridnine.xtrip.server.gds.tasks.ClassOfServiceTableSynchronizer;
import java.util.List;

public class ClassOfServiceSynchronizeTask
extends BaseScheduledTask {
    private static boolean doneCleaning = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doJob() throws Exception {
        boolean doCleanup = Boolean.parseBoolean(this.jobProperties.getProperty("clear_all_once"));
        boolean mergeCodes = Boolean.parseBoolean(this.jobProperties.getProperty("merge_codes"));
        boolean checkIntegrity = Boolean.parseBoolean(this.jobProperties.getProperty("check_integrity"));
        if (doCleanup) {
            if (!doneCleaning) {
                Class<ClassOfServiceSynchronizeTask> clazz = ClassOfServiceSynchronizeTask.class;
                synchronized (ClassOfServiceSynchronizeTask.class) {
                    if (!doneCleaning) {
                        ClassOfServiceTable.cleanAll();
                        doneCleaning = true;
                    }
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                }
            }
        } else if (doneCleaning) {
            doneCleaning = false;
        }
        {
            ClassOfServiceTableSynchronizer synchronizer = new ClassOfServiceTableSynchronizer();
            synchronizer.synchronizeWithStorage(mergeCodes);
            if (!checkIntegrity) return;
            Class<ClassOfServiceSynchronizeTask> clazz = ClassOfServiceSynchronizeTask.class;
            synchronized (ClassOfServiceSynchronizeTask.class) {
                List<String> results = ClassOfServiceTable.checkDuplicates();
                // ** MonitorExit[var6_7] (shouldn't be in output)
                if (results.isEmpty()) {
                    this.log.warn("No duplicate classes of service / booking classes were found. Please don't run this the task with this option continuously!");
                    return;
                } else {
                    for (String result : results) {
                        this.log.warn(result);
                    }
                }
                return;
            }
        }
    }
}

