/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.tasks;

import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.ClassOfService;
import com.gridnine.xtrip.common.model.dict.ClassOfServiceCode;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.BaseScheduledTask;
import com.gridnine.xtrip.server.gds.ClassOfServiceTable;
import com.gridnine.xtrip.server.storage.DictionaryStorage;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class ClassOfServiceSynchronizeTask2
extends BaseScheduledTask {
    protected void doJob() throws Exception {
        HashMap data = new HashMap();
        for (Map.Entry<MiscUtil.Pair<DictionaryReference<Airline>, String>, ClassOfService> entry : Collections.unmodifiableMap(ClassOfServiceTable.TABLE).entrySet()) {
            if (!data.containsKey(entry.getKey().getFirst())) {
                data.put(entry.getKey().getFirst(), new HashMap());
            }
            Map airlineData = (Map)data.get(entry.getKey().getFirst());
            airlineData.put(entry.getKey().getSecond(), entry.getValue());
        }
        this.log.debug("data prepared, acquiring lock");
        LockUtil.lock((String)"ClassOfServiceTable.TABLE", () -> {
            this.log.debug("lock acquired");
            for (DictionaryReference airline : data.keySet()) {
                if (Thread.interrupted()) {
                    this.log.debug("thread interrupted");
                    throw new InterruptedException();
                }
                HashSet<ClassOfServiceCode> codes = new HashSet<ClassOfServiceCode>();
                for (ClassOfServiceCode code : DictionaryCache.get().getAll(ClassOfServiceCode.class).values()) {
                    if (!MiscUtil.equals((Object)code.getAirline(), (Object)airline)) continue;
                    codes.add(code);
                }
                HashSet<ClassOfServiceCode> modified = new HashSet<ClassOfServiceCode>();
                for (Map.Entry entry : ((Map)data.get(airline)).entrySet()) {
                    String classOfBooking = (String)entry.getKey();
                    ClassOfService classOfService = (ClassOfService)entry.getValue();
                    boolean found = false;
                    for (ClassOfServiceCode code : codes) {
                        if (MiscUtil.equals((Object)code.getClassOfService(), (Object)classOfService)) {
                            found = true;
                            if (code.getCodes().contains(classOfBooking)) {
                                this.log.debug(String.format("dictionary entry (code=%s, airline=%s, classOfService=%s) SHOULD contain classOfBoooking=%s and it DOES, no change", code.getCode(), code.getAirline(), code.getClassOfService(), classOfBooking));
                                continue;
                            }
                            code.getCodes().add(classOfBooking);
                            modified.add(code);
                            this.log.debug(String.format("dictionary entry (code=%s, airline=%s, classOfService=%s) SHOULD contain classOfBoooking=%s but it DOES NOT, updated", code.getCode(), code.getAirline(), code.getClassOfService(), classOfBooking));
                            continue;
                        }
                        if (!code.getCodes().contains(classOfBooking)) {
                            this.log.debug(String.format("dictionary entry (code=%s, airline=%s, classOfService=%s) SHOULD NOT contain classOfBoooking=%s and it DOES NOT, no change", code.getCode(), code.getAirline(), code.getClassOfService(), classOfBooking));
                            continue;
                        }
                        code.getCodes().remove(classOfBooking);
                        modified.add(code);
                        this.log.debug(String.format("dictionary entry (code=%s, airline=%s, classOfService=%s) SHOULD NOT contain classOfBoooking=%s but it DOES, updated", code.getCode(), code.getAirline(), code.getClassOfService(), classOfBooking));
                    }
                    if (found) continue;
                    ClassOfServiceCode code = new ClassOfServiceCode();
                    code.setAirline(airline);
                    code.setClassOfService(classOfService);
                    code.getCodes().add(classOfBooking);
                    code.setDataSource("ClassOfServiceSynchronizeTask2");
                    DictionaryStorage.get().save((BaseDictionary)code);
                    codes.add(code);
                    this.log.debug(String.format("dictionary entry (airline=%s, classOfService=%s) was not found, we've created it (code=%s) and it now contains classOfBooking=%s", airline, classOfService, code.getCode(), classOfBooking));
                }
                for (ClassOfServiceCode code : modified) {
                    if (!code.getCodes().isEmpty()) {
                        if (code.isNoUpdate()) {
                            this.log.debug(String.format("skipped updating dictionary entry (code=%s) as it is marked with 'no update' flag", code.getCode()));
                            continue;
                        }
                        code.setDataSource("ClassOfServiceSynchronizeTask2");
                        DictionaryStorage.get().save((BaseDictionary)code);
                        this.log.debug(String.format("updated dictionary entry (code=%s)", code.getCode()));
                        continue;
                    }
                    if (code.isNoUpdate()) {
                        this.log.debug(String.format("skipped deleting dictionary entry (code=%s) as it is marked with 'no update' flag", code.getCode()));
                        continue;
                    }
                    DictionaryStorage.get().delete((BaseDictionary)code);
                    this.log.debug(String.format("deleted dictionary entry (code=%s)", code.getCode()));
                }
            }
        });
        this.log.debug("task finished");
    }
}

