/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.tasks;

import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.ClassOfService;
import com.gridnine.xtrip.common.model.dict.ClassOfServiceCode;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.ClassOfServiceTable;
import com.gridnine.xtrip.server.storage.DictionaryStorage;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassOfServiceTableSynchronizer {
    private static final Logger log = LoggerFactory.getLogger(ClassOfServiceTableSynchronizer.class);

    public void synchronizeWithStorage(boolean mergeCodes) throws Exception {
        this.synchronizeWithStorage(mergeCodes, ClassOfServiceTable.TABLE.entrySet());
    }

    public void synchronizeWithStorage(boolean mergeCodes, Set<Map.Entry<MiscUtil.Pair<DictionaryReference<Airline>, String>, ClassOfService>> entrySet) throws Exception {
        for (Map.Entry<MiscUtil.Pair<DictionaryReference<Airline>, String>, ClassOfService> entry : entrySet) {
            String airlineCode;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            DictionaryReference airline = (DictionaryReference)entry.getKey().getFirst();
            if (airline == null) {
                airlineCode = null;
            } else {
                airlineCode = airline.getCode();
                if (airlineCode == null) {
                    log.error("Null code airline found in TABLE, please check class of service update tasks");
                    continue;
                }
            }
            String bookingClass = (String)entry.getKey().getSecond();
            if (bookingClass == null) {
                log.error(String.format("Null booking class found in TABLE for %s, please check class of service update tasks", airlineCode));
                continue;
            }
            ClassOfService classOfService = entry.getValue();
            if (classOfService == null) {
                log.error(String.format("Null class of service found in TABLE for %s, booking class %s, please check class of service update tasks", airlineCode, bookingClass));
                continue;
            }
            this.processAirlineClassOfServiceEntry(mergeCodes, (DictionaryReference<Airline>)airline, airlineCode, bookingClass, classOfService);
        }
    }

    protected void processAirlineClassOfServiceEntry(boolean mergeCodes, DictionaryReference<Airline> airline, String airlineCode, String bookingClass, ClassOfService classOfService) {
        try {
            List<ClassOfServiceCode> existingCodes = this.findClassOfServiceCodes(airline, bookingClass);
            ClassOfServiceCode correctCode = null;
            for (ClassOfServiceCode existingCode : existingCodes) {
                if (existingCode.getClassOfService() == classOfService) {
                    if (mergeCodes && correctCode != null) {
                        correctCode.getCodes().addAll(existingCode.getCodes());
                        log.warn(String.format("Merged codes: %s into %s for booking class %s, airline %s, class %s", StringUtils.join((Collection)existingCode.getCodes(), (char)','), StringUtils.join((Collection)correctCode.getCodes(), (char)','), bookingClass, correctCode.getAirline(), classOfService));
                        this.delete(existingCode);
                        continue;
                    }
                    correctCode = existingCode;
                    continue;
                }
                this.removeLetter(airlineCode, bookingClass, classOfService, existingCode);
            }
            if (correctCode != null) {
                return;
            }
            ClassOfServiceCode addedCode = this.findClassOfServiceCode(airline, classOfService);
            if (addedCode == null) {
                addedCode = new ClassOfServiceCode();
                addedCode.setAirline(airline);
                addedCode.setClassOfService(classOfService);
            }
            this.addCode(airlineCode, bookingClass, classOfService, addedCode);
        }
        catch (Exception ex) {
            log.error(String.format("Failed updating record for booking class %s, airline %s, class %s", bookingClass, airlineCode, classOfService), (Throwable)ex);
        }
    }

    protected void addCode(String airlineCode, String bookingClass, ClassOfService classOfService, ClassOfServiceCode addedCode) throws Exception {
        if (addedCode.isNoUpdate()) {
            return;
        }
        if (this.addBookingClass(bookingClass, addedCode)) {
            this.save(addedCode);
            if (log.isDebugEnabled()) {
                log.debug(String.format("Updated record for booking class %s, airline %s, class %s", bookingClass, airlineCode, classOfService));
            }
        } else {
            log.error(String.format("Record for booking class %s, airline %s, class %s already exists", bookingClass, airlineCode, classOfService));
        }
    }

    protected boolean addBookingClass(String bookingClass, ClassOfServiceCode addedCode) {
        return addedCode.getCodes().add(bookingClass);
    }

    protected void removeLetter(String airlineCode, String bookingClass, ClassOfService classOfService, ClassOfServiceCode existingCode) throws Exception {
        if (existingCode.isNoUpdate()) {
            return;
        }
        if (this.removeCode(bookingClass, existingCode)) {
            if (existingCode.getCodes().isEmpty()) {
                this.delete(existingCode);
            } else {
                this.save(existingCode);
            }
        } else {
            log.error(String.format("Unable to remove non-existent booking class %s from airline %s, class %s", bookingClass, airlineCode, classOfService));
        }
    }

    protected boolean removeCode(String bookingClass, ClassOfServiceCode existingCode) {
        return existingCode.getCodes().remove(bookingClass);
    }

    protected ClassOfServiceCode findClassOfServiceCode(DictionaryReference<Airline> airline, ClassOfService classOfService) {
        return DictHelper.findClassOfServiceCode(airline, (ClassOfService)classOfService);
    }

    protected void save(ClassOfServiceCode existingCode) throws Exception {
        existingCode.setDataSource("ClassOfServiceTableSynchronizer");
        DictionaryStorage.get().save((BaseDictionary)existingCode);
    }

    protected void delete(ClassOfServiceCode existingCode) throws Exception {
        DictionaryStorage.get().delete((BaseDictionary)existingCode);
    }

    protected List<ClassOfServiceCode> findClassOfServiceCodes(DictionaryReference<Airline> airline, String bookingClass) {
        return DictHelper.findClassOfServiceCodes(airline, null, (String)bookingClass, null);
    }
}

