/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.tasks;

import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.ClassOfService;
import com.gridnine.xtrip.common.model.dict.ClassOfServiceCode;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.server.gds.tasks.ClassOfServiceTableSynchronizer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class ClassOfServiceTableSynchronizerForTesting
extends ClassOfServiceTableSynchronizer {
    private final Map<String, Integer> methodCallsByMethodName = new HashMap<String, Integer>();
    private final List<ClassOfServiceCode> findClassOfServiceCodesResult;
    private final ClassOfServiceCode findClassOfServiceCodeResult;

    public ClassOfServiceTableSynchronizerForTesting() {
        this(null, null);
    }

    public ClassOfServiceTableSynchronizerForTesting(List<ClassOfServiceCode> findClassOfServiceCodesResult, ClassOfServiceCode findClassOfServiceCodeResult) {
        this.findClassOfServiceCodesResult = findClassOfServiceCodesResult;
        this.findClassOfServiceCodeResult = findClassOfServiceCodeResult;
    }

    private void incrementMethodCallCount(String methodName) {
        Integer count = this.methodCallsByMethodName.get(methodName);
        if (count == null) {
            this.methodCallsByMethodName.put(methodName, 1);
            return;
        }
        Integer n = count;
        Integer n2 = count = Integer.valueOf(count + 1);
        this.methodCallsByMethodName.put(methodName, n);
    }

    public int getMethodCallCount(String methodName) {
        Integer count = this.methodCallsByMethodName.get(methodName);
        if (count != null) {
            return count;
        }
        return 0;
    }

    @Override
    protected void save(ClassOfServiceCode existingCode) throws Exception {
        this.incrementMethodCallCount("save");
    }

    @Override
    protected void delete(ClassOfServiceCode existingCode) throws Exception {
        this.incrementMethodCallCount("delete");
    }

    @Override
    protected boolean removeCode(String bookingClass, ClassOfServiceCode existingCode) {
        System.out.println(String.format("Removing booking class '%s' from class of service '%s'", bookingClass, existingCode.getClassOfService()));
        this.incrementMethodCallCount("removeCode");
        return true;
    }

    @Override
    protected boolean addBookingClass(String bookingClass, ClassOfServiceCode classOfServiceCode) {
        System.out.println(String.format("Adding booking class '%s' to class of service '%s'", bookingClass, classOfServiceCode.getClassOfService()));
        this.incrementMethodCallCount("addBookingClass");
        return true;
    }

    @Override
    protected List<ClassOfServiceCode> findClassOfServiceCodes(DictionaryReference<Airline> airline, String bookingClass) {
        if (this.findClassOfServiceCodesResult != null) {
            return this.findClassOfServiceCodesResult;
        }
        return super.findClassOfServiceCodes(airline, bookingClass);
    }

    @Override
    protected ClassOfServiceCode findClassOfServiceCode(DictionaryReference<Airline> airline, ClassOfService classOfService) {
        if (this.findClassOfServiceCodeResult != null) {
            return this.findClassOfServiceCodeResult;
        }
        return super.findClassOfServiceCode(airline, classOfService);
    }

    @Override
    protected void removeLetter(String airlineCode, String bookingClass, ClassOfService classOfService, ClassOfServiceCode existingCode) throws Exception {
        super.removeLetter(airlineCode, bookingClass, classOfService, existingCode);
        this.incrementMethodCallCount("removeLetter");
    }
}

