/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.tasks;

import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.AirlineReference;
import com.gridnine.xtrip.common.model.dict.ClassOfService;
import com.gridnine.xtrip.common.model.dict.ClassOfServiceCode;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.test.TestBase;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.tasks.ClassOfServiceTableSynchronizerForTesting;
import com.gridnine.xtrip.server.gds.tasks.ClassOfServiceTableSynchronizerForTestingVip11112;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class ClassOfServiceTableSynchronizerTest
extends TestBase {
    private static final AirlineReference AEROFLOT = new AirlineReference("SU");
    static final String DELETE = "delete";
    static final String SAVE = "save";
    static final String REMOVE_CODE = "removeCode";
    static final String ADD_BOOKING_CLASS = "addBookingClass";
    static final String REMOVE_LETTER = "removeLetter";

    @Test
    public void removeLetterDoesntDoAnythingIfNoUpdateFlagIsSet() throws Exception {
        ClassOfServiceTableSynchronizerForTesting testObject = new ClassOfServiceTableSynchronizerForTesting();
        ClassOfServiceCode existingCode = new ClassOfServiceCode();
        existingCode.setNoUpdate(true);
        testObject.removeLetter("", "", null, existingCode);
        Assert.assertEquals((long)0L, (long)testObject.getMethodCallCount(REMOVE_CODE));
        Assert.assertEquals((long)0L, (long)testObject.getMethodCallCount(DELETE));
        Assert.assertEquals((long)0L, (long)testObject.getMethodCallCount(SAVE));
    }

    @Test
    public void removeLetterDeletesCode() throws Exception {
        ClassOfServiceTableSynchronizerForTesting testObject = new ClassOfServiceTableSynchronizerForTesting();
        ClassOfServiceCode existingCode = new ClassOfServiceCode();
        existingCode.setNoUpdate(false);
        testObject.removeLetter("", "", null, existingCode);
        Assert.assertEquals((long)1L, (long)testObject.getMethodCallCount(REMOVE_CODE));
        Assert.assertEquals((long)1L, (long)testObject.getMethodCallCount(DELETE));
        Assert.assertEquals((long)0L, (long)testObject.getMethodCallCount(SAVE));
    }

    @Test
    public void removeLetterSavesCode() throws Exception {
        ClassOfServiceTableSynchronizerForTesting testObject = new ClassOfServiceTableSynchronizerForTesting();
        ClassOfServiceCode existingCode = new ClassOfServiceCode();
        existingCode.getCodes().add("Remaining string");
        existingCode.setNoUpdate(false);
        testObject.removeLetter("", "", null, existingCode);
        Assert.assertEquals((long)1L, (long)testObject.getMethodCallCount(REMOVE_CODE));
        Assert.assertEquals((long)0L, (long)testObject.getMethodCallCount(DELETE));
        Assert.assertEquals((long)1L, (long)testObject.getMethodCallCount(SAVE));
    }

    @Test
    public void addCodeDoesntDoAnythingIfNoUpdateIsSet() throws Exception {
        ClassOfServiceTableSynchronizerForTesting testObject = new ClassOfServiceTableSynchronizerForTesting();
        ClassOfServiceCode addedCode = new ClassOfServiceCode();
        addedCode.setNoUpdate(true);
        testObject.addCode("", "", null, addedCode);
        Assert.assertEquals((long)0L, (long)testObject.getMethodCallCount(ADD_BOOKING_CLASS));
        Assert.assertEquals((long)0L, (long)testObject.getMethodCallCount(SAVE));
    }

    @Test
    public void addCodeUpdatesAndSavesCodeIfNoUpdateIsFalse() throws Exception {
        ClassOfServiceTableSynchronizerForTesting testObject = new ClassOfServiceTableSynchronizerForTesting();
        ClassOfServiceCode addedCode = new ClassOfServiceCode();
        addedCode.setNoUpdate(false);
        testObject.addCode("", "", null, addedCode);
        Assert.assertEquals((long)1L, (long)testObject.getMethodCallCount(ADD_BOOKING_CLASS));
        Assert.assertEquals((long)1L, (long)testObject.getMethodCallCount(SAVE));
    }

    @Test
    public void processAirlineClassOfServiceEntryDoesNotUpdateUnchangedCodeOfServiceClassCodes() {
        this.processAirlineClassOfServiceEntryTestLogic(true, "O", 0, ClassOfService.BUSINESS);
        this.processAirlineClassOfServiceEntryTestLogic(false, "O", 0, ClassOfService.BUSINESS);
    }

    @Test
    public void processAirlineClassOfServiceEntryDoesUpdatesCodeOfServiceClassCodes() {
        this.processAirlineClassOfServiceEntryTestLogic(true, "U", 1, ClassOfService.ECONOMY);
        this.processAirlineClassOfServiceEntryTestLogic(false, "U", 1, ClassOfService.ECONOMY);
    }

    @Test
    public void testVip11112_1() throws Exception {
        HashMap<MiscUtil.Pair<DictionaryReference<Airline>, String>, ClassOfService> node1Table = new HashMap<MiscUtil.Pair<DictionaryReference<Airline>, String>, ClassOfService>();
        node1Table.put(this.createAirlineBookingClassPair(AEROFLOT, "SU", "A"), ClassOfService.ECONOMY);
        node1Table.put(this.createAirlineBookingClassPair(AEROFLOT, "SU", "B"), ClassOfService.ECONOMY);
        HashMap<MiscUtil.Pair<DictionaryReference<Airline>, String>, ClassOfService> node2Table = new HashMap<MiscUtil.Pair<DictionaryReference<Airline>, String>, ClassOfService>();
        node2Table.put(this.createAirlineBookingClassPair(AEROFLOT, "SU", "A"), ClassOfService.ECONOMY);
        ClassOfServiceTableSynchronizerForTesting node1Synchronizer = new ClassOfServiceTableSynchronizerForTesting(Arrays.asList(this.createClassOfServiceCode(AEROFLOT, ClassOfService.ECONOMY, "A")), null);
        node1Synchronizer.synchronizeWithStorage(false, node1Table.entrySet());
        System.out.println(this.composeMethodCallsMessage(1, node1Synchronizer));
        this.verifySyncronizerDidNothing(node1Synchronizer);
        ClassOfServiceTableSynchronizerForTesting node2Synchronizer = new ClassOfServiceTableSynchronizerForTesting(Arrays.asList(this.createClassOfServiceCode(AEROFLOT, ClassOfService.ECONOMY, "A"), this.createClassOfServiceCode(AEROFLOT, ClassOfService.ECONOMY, "B")), null);
        node2Synchronizer.synchronizeWithStorage(false, node2Table.entrySet());
        System.out.println(this.composeMethodCallsMessage(2, node2Synchronizer));
        this.verifySyncronizerDidNothing(node2Synchronizer);
    }

    protected void verifySyncronizerDidNothing(ClassOfServiceTableSynchronizerForTesting synchronizer) {
        Assert.assertEquals((long)0L, (long)synchronizer.getMethodCallCount(REMOVE_CODE));
        Assert.assertEquals((long)0L, (long)synchronizer.getMethodCallCount(ADD_BOOKING_CLASS));
        Assert.assertEquals((long)0L, (long)synchronizer.getMethodCallCount(SAVE));
        Assert.assertEquals((long)0L, (long)synchronizer.getMethodCallCount(DELETE));
        Assert.assertEquals((long)0L, (long)synchronizer.getMethodCallCount(REMOVE_LETTER));
    }

    @Test
    public void testVip11112_2() throws Exception {
        HashMap<MiscUtil.Pair<DictionaryReference<Airline>, String>, ClassOfService> node1Table = new HashMap<MiscUtil.Pair<DictionaryReference<Airline>, String>, ClassOfService>();
        node1Table.put(this.createAirlineBookingClassPair(AEROFLOT, "SU", "A"), ClassOfService.ECONOMY);
        node1Table.put(this.createAirlineBookingClassPair(AEROFLOT, "SU", "B"), ClassOfService.ECONOMY);
        HashMap<MiscUtil.Pair<DictionaryReference<Airline>, String>, ClassOfService> node2Table = new HashMap<MiscUtil.Pair<DictionaryReference<Airline>, String>, ClassOfService>();
        node2Table.put(this.createAirlineBookingClassPair(AEROFLOT, "SU", "A"), ClassOfService.ECONOMY);
        node2Table.put(this.createAirlineBookingClassPair(AEROFLOT, "SU", "B"), ClassOfService.ECONOMY);
        ClassOfServiceTableSynchronizerForTesting node1Synchronizer = new ClassOfServiceTableSynchronizerForTesting(Arrays.asList(this.createClassOfServiceCode(AEROFLOT, ClassOfService.ECONOMY, "A")), null);
        node1Synchronizer.synchronizeWithStorage(false, node1Table.entrySet());
        System.out.println(this.composeMethodCallsMessage(1, node1Synchronizer));
        Assert.assertEquals((long)0L, (long)node1Synchronizer.getMethodCallCount(REMOVE_CODE));
        Assert.assertEquals((long)0L, (long)node1Synchronizer.getMethodCallCount(ADD_BOOKING_CLASS));
        ClassOfServiceTableSynchronizerForTesting node2Synchronizer = new ClassOfServiceTableSynchronizerForTesting(Arrays.asList(this.createClassOfServiceCode(AEROFLOT, ClassOfService.ECONOMY, "A"), this.createClassOfServiceCode(AEROFLOT, ClassOfService.ECONOMY, "B")), null);
        node2Synchronizer.synchronizeWithStorage(false, node2Table.entrySet());
        System.out.println(this.composeMethodCallsMessage(2, node2Synchronizer));
        Assert.assertEquals((long)0L, (long)node2Synchronizer.getMethodCallCount(REMOVE_CODE));
    }

    @Test
    public void testVip11112_3() throws Exception {
        HashMap<MiscUtil.Pair<DictionaryReference<Airline>, String>, ClassOfService> node1Table = new HashMap<MiscUtil.Pair<DictionaryReference<Airline>, String>, ClassOfService>();
        node1Table.put(this.createAirlineBookingClassPair(AEROFLOT, "SU", "A"), ClassOfService.ECONOMY);
        node1Table.put(this.createAirlineBookingClassPair(AEROFLOT, "SU", "B"), ClassOfService.ECONOMY);
        HashMap<MiscUtil.Pair<DictionaryReference<Airline>, String>, ClassOfService> node2Table = new HashMap<MiscUtil.Pair<DictionaryReference<Airline>, String>, ClassOfService>();
        node2Table.put(this.createAirlineBookingClassPair(AEROFLOT, "SU", "A"), ClassOfService.ECONOMY);
        ClassOfServiceTableSynchronizerForTesting node1Synchronizer = new ClassOfServiceTableSynchronizerForTesting(Arrays.asList(this.createClassOfServiceCodeWithList(AEROFLOT, ClassOfService.ECONOMY, Arrays.asList("A", "B"))), new ClassOfServiceCode());
        node1Synchronizer.synchronizeWithStorage(false, node1Table.entrySet());
        System.out.println(this.composeMethodCallsMessage(1, node1Synchronizer));
        this.verifySyncronizerDidNothing(node1Synchronizer);
        ClassOfServiceTableSynchronizerForTesting node2Synchronizer = new ClassOfServiceTableSynchronizerForTesting(Arrays.asList(this.createClassOfServiceCodeWithList(AEROFLOT, ClassOfService.ECONOMY, Arrays.asList("B"))), new ClassOfServiceCode());
        node2Synchronizer.synchronizeWithStorage(false, node2Table.entrySet());
        System.out.println(this.composeMethodCallsMessage(2, node2Synchronizer));
        this.verifySyncronizerDidNothing(node2Synchronizer);
    }

    @Test
    public void testVip11112_4() throws Exception {
        HashMap<MiscUtil.Pair<DictionaryReference<Airline>, String>, ClassOfService> node1Table = new HashMap<MiscUtil.Pair<DictionaryReference<Airline>, String>, ClassOfService>();
        node1Table.put(this.createAirlineBookingClassPair(AEROFLOT, "SU", "A"), ClassOfService.ECONOMY);
        node1Table.put(this.createAirlineBookingClassPair(AEROFLOT, "SU", "B"), ClassOfService.ECONOMY);
        HashMap<MiscUtil.Pair<DictionaryReference<Airline>, String>, ClassOfService> node2Table = new HashMap<MiscUtil.Pair<DictionaryReference<Airline>, String>, ClassOfService>();
        node2Table.put(this.createAirlineBookingClassPair(AEROFLOT, "SU", "A"), ClassOfService.ECONOMY);
        HashMap<String, List<ClassOfServiceCode>> res1 = new HashMap<String, List<ClassOfServiceCode>>();
        res1.put("A", Arrays.asList(this.createClassOfServiceCodeWithList(AEROFLOT, ClassOfService.ECONOMY, Arrays.asList("A"))));
        res1.put("B", Arrays.asList(new ClassOfServiceCode[0]));
        ClassOfServiceTableSynchronizerForTestingVip11112 node1Synchronizer = new ClassOfServiceTableSynchronizerForTestingVip11112(res1, new ClassOfServiceCode());
        node1Synchronizer.synchronizeWithStorage(false, node1Table.entrySet());
        System.out.println(this.composeMethodCallsMessage(1, node1Synchronizer));
        Assert.assertEquals((long)1L, (long)node1Synchronizer.getMethodCallCount(SAVE));
        Assert.assertEquals((long)1L, (long)node1Synchronizer.getMethodCallCount(ADD_BOOKING_CLASS));
        HashMap<String, List<ClassOfServiceCode>> res2 = new HashMap<String, List<ClassOfServiceCode>>();
        res2.put("A", Arrays.asList(this.createClassOfServiceCodeWithList(AEROFLOT, ClassOfService.ECONOMY, Arrays.asList("A"))));
        res2.put("B", Arrays.asList(this.createClassOfServiceCodeWithList(AEROFLOT, ClassOfService.ECONOMY, Arrays.asList("B"))));
        ClassOfServiceTableSynchronizerForTestingVip11112 node2Synchronizer = new ClassOfServiceTableSynchronizerForTestingVip11112(res2, new ClassOfServiceCode());
        node2Synchronizer.synchronizeWithStorage(false, node2Table.entrySet());
        System.out.println(this.composeMethodCallsMessage(2, node2Synchronizer));
        Assert.assertEquals((long)0L, (long)node2Synchronizer.getMethodCallCount(REMOVE_CODE));
        Assert.assertEquals((long)0L, (long)node2Synchronizer.getMethodCallCount(REMOVE_LETTER));
    }

    protected String composeMethodCallsMessage(int nodeNr, ClassOfServiceTableSynchronizerForTesting node1Synchronizer) {
        return String.format("Node %d, remove: %d, add: %d, delete: %d, save: %d, remove letter: %d", nodeNr, node1Synchronizer.getMethodCallCount(REMOVE_CODE), node1Synchronizer.getMethodCallCount(ADD_BOOKING_CLASS), node1Synchronizer.getMethodCallCount(DELETE), node1Synchronizer.getMethodCallCount(SAVE), node1Synchronizer.getMethodCallCount(REMOVE_LETTER));
    }

    private ClassOfServiceCode createClassOfServiceCode(AirlineReference airlineRef, ClassOfService classOfService, String code) {
        ClassOfServiceCode result = new ClassOfServiceCode();
        result.setAirline((DictionaryReference)airlineRef);
        result.setClassOfService(classOfService);
        result.setCode(code);
        return result;
    }

    private ClassOfServiceCode createClassOfServiceCodeWithList(AirlineReference airlineRef, ClassOfService classOfService, List<String> codes) {
        ClassOfServiceCode result = new ClassOfServiceCode();
        result.setAirline((DictionaryReference)airlineRef);
        result.setClassOfService(classOfService);
        result.getCodes().addAll(codes);
        return result;
    }

    private MiscUtil.Pair<DictionaryReference<Airline>, String> createAirlineBookingClassPair(AirlineReference airlineRef, String airlineCode, String bookingClass) {
        return new MiscUtil.Pair((Object)airlineRef, (Object)bookingClass);
    }

    protected void processAirlineClassOfServiceEntryTestLogic(boolean mergeCodes, String bookingClass, int expectedSaveMethodCalls, ClassOfService classOfService) {
        List<ClassOfServiceCode> existingServiceCodes = Arrays.asList(this.createBusinessClassOfServiceCode());
        ClassOfServiceCode findClassOfServiceCodeResult = this.createBusinessClassOfServiceCode();
        ClassOfServiceTableSynchronizerForTesting testObject = new ClassOfServiceTableSynchronizerForTesting(existingServiceCodes, findClassOfServiceCodeResult);
        DictionaryReference<Airline> airlineRef = null;
        String airlineCode = "DL";
        testObject.processAirlineClassOfServiceEntry(mergeCodes, airlineRef, "DL", bookingClass, classOfService);
        Assert.assertEquals((long)expectedSaveMethodCalls, (long)testObject.getMethodCallCount(SAVE));
    }

    private ClassOfServiceCode createBusinessClassOfServiceCode() {
        ClassOfServiceCode result = new ClassOfServiceCode();
        result.setClassOfService(ClassOfService.BUSINESS);
        result.getCodes().add("D");
        result.getCodes().add("C");
        result.getCodes().add("O");
        result.getCodes().add("I");
        result.getCodes().add("J");
        result.getCodes().add("Z");
        return result;
    }
}

