/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.tasks;

import com.gridnine.xtrip.common.gds.model.GdsTracingSettings;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.system.BasicSystemSettingsIndex;
import com.gridnine.xtrip.common.model.system.SystemSettingsType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.BaseScheduledTask;

public class DisableGdsTracingSettingsTask
extends BaseScheduledTask {
    protected void doJob() throws Exception {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicSystemSettingsIndex.Property.type.name(), (Object)SystemSettingsType.SEARCH_LOGGING_SETTINGS));
        for (BasicSystemSettingsIndex idx : EntityStorage.get().search(BasicSystemSettingsIndex.class, query).getData()) {
            try {
                EntityContainer ctr = EntityStorage.get().resolve(idx.getSource());
                GdsTracingSettings settings = (GdsTracingSettings)ctr.getEntity();
                if (!settings.isActive() || !settings.isSaveSearchTraces() && !settings.isSaveRulesTraces()) continue;
                settings.setSaveSearchTraces(false);
                settings.setSaveRulesTraces(false);
                EntityStorage.get().save(ctr, false);
                this.log.info("disabled " + idx);
            }
            catch (Throwable t) {
                this.log.error("failed to disable " + idx, t);
            }
        }
    }
}

