/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.tripartite;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.BaseGdsAccount;
import com.gridnine.xtrip.common.gds.model.FlightSearchParameters;
import com.gridnine.xtrip.common.gds.model.RouteSegment;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.AirlineAlliance;
import com.gridnine.xtrip.common.model.dict.AirlineAllianceReference;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocationReference;
import com.gridnine.xtrip.common.model.dict.Preference;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.TripartiteContract;
import com.gridnine.xtrip.common.model.profile.TripartiteContractCalculationIndicatorType;
import com.gridnine.xtrip.common.model.profile.TripartiteContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.TripartiteContractType;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.Properties;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.rules.tripartite.AviaTripartiteContractActions;
import com.gridnine.xtrip.common.rules.RuleRestriction;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.server.gds.ibus.GetAccountCodesProcessor;
import com.gridnine.xtrip.server.gds.ibus.GetAgenciesForTripartiteProcessor;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.test.ModelTestBase;
import com.gridnine.xtrip.server.storage.DictionaryStorage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class GetAccountCodesProcessorTest
extends ModelTestBase {
    private GetAgenciesForTripartiteProcessor preProcessor;
    private GetAccountCodesProcessor processor;
    private EntityContainer<Organization> agencyCtr;
    private EntityContainer<Organization> clientCtr;

    public void setUp() throws Exception {
        super.setUp();
        this.preProcessor = new GetAgenciesForTripartiteProcessor();
        this.processor = new GetAccountCodesProcessor();
        EntityContainer ctr = new EntityContainer(Organization.class);
        ((Organization)ctr.getEntity()).setCode("all-clients");
        EntityStorage.get().save(ctr, true);
        Preference pref = new Preference();
        pref.setKey(PreferenceKey.ALL_CLIENTS_PROFILE_UID);
        pref.setValue(ctr.getUid());
        DictionaryStorage.get().save((BaseDictionary)pref);
        ctr = new EntityContainer(Organization.class);
        ((Organization)ctr.getEntity()).setCode("all-agencies");
        EntityStorage.get().save(ctr, true);
        pref = new Preference();
        pref.setKey(PreferenceKey.ALL_AGENCIES_PROFILE_UID);
        pref.setValue(ctr.getUid());
        DictionaryStorage.get().save((BaseDictionary)pref);
        this.agencyCtr = GetAccountCodesProcessorTest.createOrganization("agency", Arrays.asList(OrganizationType.AGENCY));
        EntityStorage.get().save(this.agencyCtr, true);
        this.clientCtr = GetAccountCodesProcessorTest.createOrganization("client", Arrays.asList(OrganizationType.CORPORATE_CLIENT));
        EntityStorage.get().save(this.clientCtr, true);
        EntityStorage.get().save(GetAccountCodesProcessorTest.createTripartiteContract((EntityReference<Organization>)this.agencyCtr.toReference(), (EntityReference<Organization>)this.clientCtr.toReference(), "123", Arrays.asList(DictHelper.findAirlineByAnyCode((String)"SU").toReference()), Collections.emptyList(), Arrays.asList("ABC", "DEF"), "TOUR123", TripartiteContractCalculationIndicatorType.INDICATOR_Z), true);
        EntityStorage.get().save(GetAccountCodesProcessorTest.createTripartiteContract((EntityReference<Organization>)this.agencyCtr.toReference(), (EntityReference<Organization>)this.clientCtr.toReference(), "456", Arrays.asList(DictHelper.findAirlineByAnyCode((String)"S7").toReference()), Collections.emptyList(), Arrays.asList("GHI", "JKL"), "TOUR456", TripartiteContractCalculationIndicatorType.INDICATOR_B), true);
        EntityStorage.get().save(GetAccountCodesProcessorTest.createTripartiteContract((EntityReference<Organization>)this.agencyCtr.toReference(), (EntityReference<Organization>)this.clientCtr.toReference(), "789", Collections.emptyList(), Arrays.asList(new AirlineAllianceReference("*S")), Arrays.asList("MNO", "PQR"), "TOUR789", TripartiteContractCalculationIndicatorType.INDICATOR_N), true);
    }

    @Test
    public void testGetAccountCodes() throws Throwable {
        FlightSearchParameters fsp = new FlightSearchParameters();
        SalesContext salesContext = new SalesContext();
        salesContext.setAgency(this.agencyCtr.toReference());
        salesContext.setClient(this.clientCtr.toReference());
        RouteSegment rs = new RouteSegment();
        rs.setDate(new Date());
        rs.setLocationBegin((DictionaryReference)new GeoLocationReference("MOW"));
        rs.setLocationEnd((DictionaryReference)new GeoLocationReference("PAR"));
        fsp.getRoute().add(rs);
        this.testGetAccountCodes(fsp, salesContext, Collections.EMPTY_LIST, Arrays.asList("ABC", "DEF", "GHI", "JKL", "MNO", "PQR"));
        this.testGetAccountCodes(fsp, salesContext, Arrays.asList(DictHelper.findAirlineByAnyCode((String)"VV").toReference()), Collections.EMPTY_LIST);
        this.testGetAccountCodes(fsp, salesContext, Arrays.asList(DictHelper.findAirlineByAnyCode((String)"AF").toReference()), Arrays.asList("MNO", "PQR"));
        this.testGetAccountCodes(fsp, salesContext, Arrays.asList(DictHelper.findAirlineByAnyCode((String)"S7").toReference()), Arrays.asList("GHI", "JKL"));
    }

    private void testGetAccountCodes(FlightSearchParameters fsp, SalesContext salesContext, Collection<DictionaryReference<Airline>> airlines, List<String> expCodes) throws Throwable {
        MessageContext ctx = new MessageContext();
        ctx.putObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_PARAMETERS, (Object)fsp);
        ctx.putObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT, (Object)salesContext);
        ctx.putObject((Enum)IBusGdsContextKeys.AIRLINES_FOR_TRIPARTITE_CONTRACTS, airlines);
        ctx.putObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT, (Object)EntityContainer.create((BaseEntity)new FakeGdsAccount()));
        this.preProcessor.process(ctx);
        this.processor.process(ctx);
        ArrayList actCodes = new ArrayList((Collection)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.ACCOUNT_CODES));
        Collections.sort(actCodes);
        Collections.sort(expCodes);
        Assert.assertEquals(expCodes, actCodes);
    }

    private static EntityContainer<Organization> createOrganization(String code, Collection<OrganizationType> types) {
        EntityContainer result = new EntityContainer(Organization.class);
        ((Organization)result.getEntity()).setCode(code);
        ((Organization)result.getEntity()).getTypes().addAll(types);
        return result;
    }

    private static EntityContainer<TripartiteContract> createTripartiteContract(EntityReference<Organization> agencyRef, EntityReference<Organization> clientRef, String contractNumber, List<? extends DictionaryReference<Airline>> airlines, List<? extends DictionaryReference<AirlineAlliance>> alliances, List<String> accountingCodes, String tourcode, TripartiteContractCalculationIndicatorType indicator) {
        EntityContainer result = new EntityContainer(TripartiteContract.class);
        ((TripartiteContract)result.getEntity()).setName("Contract #" + contractNumber);
        ((TripartiteContract)result.getEntity()).setAgency(agencyRef);
        TripartiteContractCustomerInfo info = new TripartiteContractCustomerInfo();
        info.setCustomer(clientRef);
        info.setNumber(contractNumber);
        ((TripartiteContract)result.getEntity()).getCustomers().add(info);
        ((TripartiteContract)result.getEntity()).setType(TripartiteContractType.AVIA);
        ((TripartiteContract)result.getEntity()).getAviaVendorData().getAirlines().addAll(airlines);
        ((TripartiteContract)result.getEntity()).getAviaVendorData().getAlliances().addAll(alliances);
        ((TripartiteContract)result.getEntity()).setRuleSet(new RuleSet());
        RuleSettings rs = new RuleSettings();
        rs.setTarget((RuleTarget)Targets.PRODUCT_COMMISSION);
        RuleRestriction rr = new RuleRestriction();
        rr.setProperty((RuleProperty)Properties.ROUTE);
        rr.setCondition((RuleCondition)Conditions.BEGINS_WITH);
        rr.setValue(Arrays.asList("MOW"));
        rs.getRestrictions().add(rr);
        rr = new RuleResult();
        rr.setAction((RuleAction)AviaTripartiteContractActions.AVIA_ACCOUNTING_CODE);
        rr.setValue(accountingCodes);
        rs.getResults().add(rr);
        rr = new RuleResult();
        rr.setAction((RuleAction)AviaTripartiteContractActions.AVIA_TOUR_CODE);
        rr.setValue(Collections.singletonList(tourcode));
        rs.getResults().add(rr);
        ((TripartiteContract)result.getEntity()).getRuleSet().getRules().add(rs);
        return result;
    }

    public static class FakeGdsAccount
    extends BaseGdsAccount {
        public FakeGdsAccount() {
        }

        public FakeGdsAccount(String uid) {
            super(uid);
        }

        public BaseEntity newInstance(String uid) {
            return new FakeGdsAccount(uid);
        }
    }
}

