
package ru.corteos;

import java.io.Serializable;
import org.joda.time.DateTime;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://corteos.ru" xmlns:xs="http://www.w3.org/2001/XMLSchema" abstract="true" name="DalObjectPrototypeV2">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:dateTime" name="DateCreate" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:dateTime" name="DateChanged" minOccurs="1" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:boolean" use="required" name="deleted"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public abstract class DalObjectPrototypeV2 implements Serializable
{
    private DateTime dateCreate;
    private DateTime dateChanged;
    private boolean deleted;

    /** 
     * Get the 'DateCreate' element value.
     * 
     * @return value
     */
    public DateTime getDateCreate() {
        return dateCreate;
    }

    /** 
     * Set the 'DateCreate' element value.
     * 
     * @param dateCreate
     */
    public void setDateCreate(DateTime dateCreate) {
        this.dateCreate = dateCreate;
    }

    /** 
     * Get the 'DateChanged' element value.
     * 
     * @return value
     */
    public DateTime getDateChanged() {
        return dateChanged;
    }

    /** 
     * Set the 'DateChanged' element value.
     * 
     * @param dateChanged
     */
    public void setDateChanged(DateTime dateChanged) {
        this.dateChanged = dateChanged;
    }

    /** 
     * Get the 'deleted' attribute value.
     * 
     * @return value
     */
    public boolean isDeleted() {
        return deleted;
    }

    /** 
     * Set the 'deleted' attribute value.
     * 
     * @param deleted
     */
    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }
}
