
package ru.corteos;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://corteos.ru" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ReserveTypeEnumeration">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Avia"/>
 *     &lt;xs:enumeration value="Rail"/>
 *     &lt;xs:enumeration value="Hotel"/>
 *     &lt;xs:enumeration value="AeroExpress"/>
 *     &lt;xs:enumeration value="TransferOnline"/>
 *     &lt;xs:enumeration value="AdvanceReport"/>
 *     &lt;xs:enumeration value="AeroExpressBusiness"/>
 *     &lt;xs:enumeration value="AutoTripWithoutServicesReservation"/>
 *     &lt;xs:enumeration value="HRServices"/>
 *     &lt;xs:enumeration value="YandexTaxi"/>
 *     &lt;xs:enumeration value="RefundPenalty"/>
 *     &lt;xs:enumeration value="ErvInsurance"/>
 *     &lt;xs:enumeration value="CheckIn"/>
 *     &lt;xs:enumeration value="VipLounges"/>
 *     &lt;xs:enumeration value="AlphaInsurance"/>
 *     &lt;xs:enumeration value="RailDeutscheBahn"/>
 *     &lt;xs:enumeration value="Transfer"/>
 *     &lt;xs:enumeration value="CarRent"/>
 *     &lt;xs:enumeration value="VIPServices"/>
 *     &lt;xs:enumeration value="PassportAndVisa"/>
 *     &lt;xs:enumeration value="MICE"/>
 *     &lt;xs:enumeration value="Insurance"/>
 *     &lt;xs:enumeration value="GroupAvia"/>
 *     &lt;xs:enumeration value="Tour"/>
 *     &lt;xs:enumeration value="Preauth"/>
 *     &lt;xs:enumeration value="AviaIndividual"/>
 *     &lt;xs:enumeration value="RailIndividual"/>
 *     &lt;xs:enumeration value="HotelIndividual"/>
 *     &lt;xs:enumeration value="ComplexReserveOrder"/>
 *     &lt;xs:enumeration value="CorporateCar"/>
 *     &lt;xs:enumeration value="RegistrationForTheConference"/>
 *     &lt;xs:enumeration value="BusinessTravelCard"/>
 *     &lt;xs:enumeration value="CEX_Transfer_SGC"/>
 *     &lt;xs:enumeration value="CEX_Transfer_TJM"/>
 *     &lt;xs:enumeration value="CEX_Transfer_HMA"/>
 *     &lt;xs:enumeration value="CEX_Transfer_NFG_Poykovskiy_NFG"/>
 *     &lt;xs:enumeration value="CEX_Transfer_NFG_HMA_NFG"/>
 *     &lt;xs:enumeration value="CEX_Transfer_SGC_NFG_SGC"/>
 *     &lt;xs:enumeration value="CEX_Transfer_PytYakh"/>
 *     &lt;xs:enumeration value="CEX_Transfer_PytYakh_Poykovskiy_PytYakh"/>
 *     &lt;xs:enumeration value="CEX_BusTransportation"/>
 *     &lt;xs:enumeration value="CEX_ConferenceRent"/>
 *     &lt;xs:enumeration value="CEX_AddServicesHotel"/>
 *     &lt;xs:enumeration value="CEX_Visa"/>
 *     &lt;xs:enumeration value="CEX_InvitationToRussia"/>
 *     &lt;xs:enumeration value="CEX_Transfer_MSK"/>
 *     &lt;xs:enumeration value="CEX_Transfer_SPB"/>
 *     &lt;xs:enumeration value="CEX_Transfer_NFG_PytYakh_NFG"/>
 *     &lt;xs:enumeration value="SALYM_BusTransportation"/>
 *     &lt;xs:enumeration value="SALYM_ConferenceRent"/>
 *     &lt;xs:enumeration value="SALYM_AddServicesHotel"/>
 *     &lt;xs:enumeration value="SALYM_Visa"/>
 *     &lt;xs:enumeration value="SALYM_InvitationToRussia"/>
 *     &lt;xs:enumeration value="SALYM_Transfer_MSK"/>
 *     &lt;xs:enumeration value="SALYM_Transfer_SPB"/>
 *     &lt;xs:enumeration value="SALYM_Transfer_NFG_PytYakh_NFG"/>
 *     &lt;xs:enumeration value="ALA_Moscow_Anadyr"/>
 *     &lt;xs:enumeration value="ALA_Anadyr_Moscow"/>
 *     &lt;xs:enumeration value="ALA_Khabarovsk_Anadyr"/>
 *     &lt;xs:enumeration value="ALA_Anadyr_Khabarovsk"/>
 *     &lt;xs:enumeration value="Workplace"/>
 *     &lt;xs:enumeration value="CabinetSecretary"/>
 *     &lt;xs:enumeration value="ZPKatTheAirportOfNorilsk"/>
 *     &lt;xs:enumeration value="TravelByCar"/>
 *     &lt;xs:enumeration value="SeatSelectionInTheCabin"/>
 *     &lt;xs:enumeration value="UnaccompaniedChild"/>
 *     &lt;xs:enumeration value="TransportationOfAnimals"/>
 *     &lt;xs:enumeration value="ChoiceOfMealsOnBoard"/>
 *     &lt;xs:enumeration value="GroupBookingPossible"/>
 *     &lt;xs:enumeration value="BusTicket"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum ReserveTypeEnumeration implements Serializable {
    AVIA("Avia"), RAIL("Rail"), HOTEL("Hotel"), AERO_EXPRESS("AeroExpress"), TRANSFER_ONLINE(
            "TransferOnline"), ADVANCE_REPORT("AdvanceReport"), AERO_EXPRESS_BUSINESS(
            "AeroExpressBusiness"), AUTO_TRIP_WITHOUT_SERVICES_RESERVATION(
            "AutoTripWithoutServicesReservation"), HR_SERVICES("HRServices"), YANDEX_TAXI(
            "YandexTaxi"), REFUND_PENALTY("RefundPenalty"), ERV_INSURANCE(
            "ErvInsurance"), CHECK_IN("CheckIn"), VIP_LOUNGES("VipLounges"), ALPHA_INSURANCE(
            "AlphaInsurance"), RAIL_DEUTSCHE_BAHN("RailDeutscheBahn"), TRANSFER(
            "Transfer"), CAR_RENT("CarRent"), VIP_SERVICES("VIPServices"), PASSPORT_AND_VISA(
            "PassportAndVisa"), MICE("MICE"), INSURANCE("Insurance"), GROUP_AVIA(
            "GroupAvia"), TOUR("Tour"), PREAUTH("Preauth"), AVIA_INDIVIDUAL(
            "AviaIndividual"), RAIL_INDIVIDUAL("RailIndividual"), HOTEL_INDIVIDUAL(
            "HotelIndividual"), COMPLEX_RESERVE_ORDER("ComplexReserveOrder"), CORPORATE_CAR(
            "CorporateCar"), REGISTRATION_FOR_THE_CONFERENCE(
            "RegistrationForTheConference"), BUSINESS_TRAVEL_CARD(
            "BusinessTravelCard"), CEX_TRANSFER_SGC("CEX_Transfer_SGC"), CEX_TRANSFER_TJM(
            "CEX_Transfer_TJM"), CEX_TRANSFER_HMA("CEX_Transfer_HMA"), CEX_TRANSFER_NFG_POYKOVSKIY_NFG(
            "CEX_Transfer_NFG_Poykovskiy_NFG"), CEX_TRANSFER_NFG_HMA_NFG(
            "CEX_Transfer_NFG_HMA_NFG"), CEX_TRANSFER_SGC_NFG_SGC(
            "CEX_Transfer_SGC_NFG_SGC"), CEX_TRANSFER_PYT_YAKH(
            "CEX_Transfer_PytYakh"), CEX_TRANSFER_PYT_YAKH_POYKOVSKIY_PYT_YAKH(
            "CEX_Transfer_PytYakh_Poykovskiy_PytYakh"), CEX_BUS_TRANSPORTATION(
            "CEX_BusTransportation"), CEX_CONFERENCE_RENT("CEX_ConferenceRent"), CEX_ADD_SERVICES_HOTEL(
            "CEX_AddServicesHotel"), CEX_VISA("CEX_Visa"), CEX_INVITATION_TO_RUSSIA(
            "CEX_InvitationToRussia"), CEX_TRANSFER_MSK("CEX_Transfer_MSK"), CEX_TRANSFER_SPB(
            "CEX_Transfer_SPB"), CEX_TRANSFER_NFG_PYT_YAKH_NFG(
            "CEX_Transfer_NFG_PytYakh_NFG"), SALYM_BUS_TRANSPORTATION(
            "SALYM_BusTransportation"), SALYM_CONFERENCE_RENT(
            "SALYM_ConferenceRent"), SALYM_ADD_SERVICES_HOTEL(
            "SALYM_AddServicesHotel"), SALYM_VISA("SALYM_Visa"), SALYM_INVITATION_TO_RUSSIA(
            "SALYM_InvitationToRussia"), SALYM_TRANSFER_MSK(
            "SALYM_Transfer_MSK"), SALYM_TRANSFER_SPB("SALYM_Transfer_SPB"), SALYM_TRANSFER_NFG_PYT_YAKH_NFG(
            "SALYM_Transfer_NFG_PytYakh_NFG"), ALA_MOSCOW_ANADYR(
            "ALA_Moscow_Anadyr"), ALA_ANADYR_MOSCOW("ALA_Anadyr_Moscow"), ALA_KHABAROVSK_ANADYR(
            "ALA_Khabarovsk_Anadyr"), ALA_ANADYR_KHABAROVSK(
            "ALA_Anadyr_Khabarovsk"), WORKPLACE("Workplace"), CABINET_SECRETARY(
            "CabinetSecretary"), ZP_KAT_THE_AIRPORT_OF_NORILSK(
            "ZPKatTheAirportOfNorilsk"), TRAVEL_BY_CAR("TravelByCar"), SEAT_SELECTION_IN_THE_CABIN(
            "SeatSelectionInTheCabin"), UNACCOMPANIED_CHILD(
            "UnaccompaniedChild"), TRANSPORTATION_OF_ANIMALS(
            "TransportationOfAnimals"), CHOICE_OF_MEALS_ON_BOARD(
            "ChoiceOfMealsOnBoard"), GROUP_BOOKING_POSSIBLE(
            "GroupBookingPossible"), BUS_TICKET("BusTicket");
    private final String value;

    private ReserveTypeEnumeration(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static ReserveTypeEnumeration convert(String value) {
        for (ReserveTypeEnumeration inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
