
package ru.corteos;

import java.io.Serializable;
import org.joda.time.DateTime;
import org.w3c.dom.Element;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://corteos.ru" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="StableSimpleReserve">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:int" nillable="true" name="id_PayerOrganization" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element name="OrderSpecificData" minOccurs="0" maxOccurs="1">
 *       &lt;xs:complexType mixed="true">
 *         &lt;xs:sequence>
 *           &lt;xs:any/>
 *         &lt;/xs:sequence>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *     &lt;xs:element name="MostCheapVariant" minOccurs="0" maxOccurs="1">
 *       &lt;xs:complexType mixed="true">
 *         &lt;xs:sequence>
 *           &lt;xs:any/>
 *         &lt;/xs:sequence>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *     &lt;xs:element name="MostExpensiveVariant" minOccurs="0" maxOccurs="1">
 *       &lt;xs:complexType mixed="true">
 *         &lt;xs:sequence>
 *           &lt;xs:any/>
 *         &lt;/xs:sequence>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:StableClient" name="Creator" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:StableServiceTeam" name="ServiceTeam" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:ArrayOfStableCode" name="Codes" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:ArrayOfStablePassenger" name="Passengers" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:ArrayOfStablePolicyViolation" name="Violations" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:ArrayOfStableFile" name="Files" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:StablePayer" name="Payer" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:StableComplexDetailsContainerInSimpleReserve" name="ComplexReserveReference" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="AgentName" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="AgentMail" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:int" use="required" name="id_Reserve"/>
 *   &lt;xs:attribute type="xs:int" use="required" name="id_ComplexReserve"/>
 *   &lt;xs:attribute type="xs:string" name="ComplexReserveName"/>
 *   &lt;xs:attribute type="xs:string" name="Locator"/>
 *   &lt;xs:attribute type="xs:double" use="required" name="Price"/>
 *   &lt;xs:attribute type="xs:string" name="Header"/>
 *   &lt;xs:attribute type="xs:string" name="Brief"/>
 *   &lt;xs:attribute type="xs:string" name="OrderTypeName"/>
 *   &lt;xs:attribute type="xs:int" use="required" name="id_ReserveType"/>
 *   &lt;xs:attribute type="xs:int" use="required" name="id_AgentGroup"/>
 *   &lt;xs:attribute type="xs:int" use="required" name="id_ClientGroup"/>
 *   &lt;xs:attribute type="xs:int" use="required" name="id_ServiceTeam"/>
 *   &lt;xs:attribute type="xs:int" use="required" name="id_ReserveState"/>
 *   &lt;xs:attribute type="xs:string" name="ReserveStateName"/>
 *   &lt;xs:attribute type="xs:double" use="required" name="Markup"/>
 *   &lt;xs:attribute type="xs:dateTime" use="required" name="DateCreate"/>
 *   &lt;xs:attribute type="xs:int" name="id_Agent"/>
 *   &lt;xs:attribute type="xs:int" use="required" name="id_Agreement"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class StableSimpleReserve implements Serializable
{
    private Integer idPayerOrganization;
    private Element orderSpecificData;
    private Element mostCheapVariant;
    private Element mostExpensiveVariant;
    private StableClient creator;
    private StableServiceTeam serviceTeam;
    private ArrayOfStableCode codes;
    private ArrayOfStablePassenger passengers;
    private ArrayOfStablePolicyViolation violations;
    private ArrayOfStableFile files;
    private StablePayer payer;
    private StableComplexDetailsContainerInSimpleReserve complexReserveReference;
    private String agentName;
    private String agentMail;
    private int idReserve;
    private int idComplexReserve;
    private String complexReserveName;
    private String locator;
    private Double price;
    private String header;
    private String brief;
    private String orderTypeName;
    private int idReserveType;
    private int idAgentGroup;
    private int idClientGroup;
    private int idServiceTeam;
    private int idReserveState;
    private String reserveStateName;
    private Double markup;
    private DateTime dateCreate;
    private Integer idAgent;
    private int idAgreement;

    /** 
     * Get the 'id_PayerOrganization' element value.
     * 
     * @return value
     */
    public Integer getIdPayerOrganization() {
        return idPayerOrganization;
    }

    /** 
     * Set the 'id_PayerOrganization' element value.
     * 
     * @param idPayerOrganization
     */
    public void setIdPayerOrganization(Integer idPayerOrganization) {
        this.idPayerOrganization = idPayerOrganization;
    }

    /** 
     * Get the 'OrderSpecificData' element value.
     * 
     * @return value
     */
    public Element getOrderSpecificData() {
        return orderSpecificData;
    }

    /** 
     * Set the 'OrderSpecificData' element value.
     * 
     * @param orderSpecificData
     */
    public void setOrderSpecificData(Element orderSpecificData) {
        this.orderSpecificData = orderSpecificData;
    }

    /** 
     * Get the 'MostCheapVariant' element value.
     * 
     * @return value
     */
    public Element getMostCheapVariant() {
        return mostCheapVariant;
    }

    /** 
     * Set the 'MostCheapVariant' element value.
     * 
     * @param mostCheapVariant
     */
    public void setMostCheapVariant(Element mostCheapVariant) {
        this.mostCheapVariant = mostCheapVariant;
    }

    /** 
     * Get the 'MostExpensiveVariant' element value.
     * 
     * @return value
     */
    public Element getMostExpensiveVariant() {
        return mostExpensiveVariant;
    }

    /** 
     * Set the 'MostExpensiveVariant' element value.
     * 
     * @param mostExpensiveVariant
     */
    public void setMostExpensiveVariant(Element mostExpensiveVariant) {
        this.mostExpensiveVariant = mostExpensiveVariant;
    }

    /** 
     * Get the 'Creator' element value.
     * 
     * @return value
     */
    public StableClient getCreator() {
        return creator;
    }

    /** 
     * Set the 'Creator' element value.
     * 
     * @param creator
     */
    public void setCreator(StableClient creator) {
        this.creator = creator;
    }

    /** 
     * Get the 'ServiceTeam' element value.
     * 
     * @return value
     */
    public StableServiceTeam getServiceTeam() {
        return serviceTeam;
    }

    /** 
     * Set the 'ServiceTeam' element value.
     * 
     * @param serviceTeam
     */
    public void setServiceTeam(StableServiceTeam serviceTeam) {
        this.serviceTeam = serviceTeam;
    }

    /** 
     * Get the 'Codes' element value.
     * 
     * @return value
     */
    public ArrayOfStableCode getCodes() {
        return codes;
    }

    /** 
     * Set the 'Codes' element value.
     * 
     * @param codes
     */
    public void setCodes(ArrayOfStableCode codes) {
        this.codes = codes;
    }

    /** 
     * Get the 'Passengers' element value.
     * 
     * @return value
     */
    public ArrayOfStablePassenger getPassengers() {
        return passengers;
    }

    /** 
     * Set the 'Passengers' element value.
     * 
     * @param passengers
     */
    public void setPassengers(ArrayOfStablePassenger passengers) {
        this.passengers = passengers;
    }

    /** 
     * Get the 'Violations' element value.
     * 
     * @return value
     */
    public ArrayOfStablePolicyViolation getViolations() {
        return violations;
    }

    /** 
     * Set the 'Violations' element value.
     * 
     * @param violations
     */
    public void setViolations(ArrayOfStablePolicyViolation violations) {
        this.violations = violations;
    }

    /** 
     * Get the 'Files' element value.
     * 
     * @return value
     */
    public ArrayOfStableFile getFiles() {
        return files;
    }

    /** 
     * Set the 'Files' element value.
     * 
     * @param files
     */
    public void setFiles(ArrayOfStableFile files) {
        this.files = files;
    }

    /** 
     * Get the 'Payer' element value.
     * 
     * @return value
     */
    public StablePayer getPayer() {
        return payer;
    }

    /** 
     * Set the 'Payer' element value.
     * 
     * @param payer
     */
    public void setPayer(StablePayer payer) {
        this.payer = payer;
    }

    /** 
     * Get the 'ComplexReserveReference' element value.
     * 
     * @return value
     */
    public StableComplexDetailsContainerInSimpleReserve getComplexReserveReference() {
        return complexReserveReference;
    }

    /** 
     * Set the 'ComplexReserveReference' element value.
     * 
     * @param complexReserveReference
     */
    public void setComplexReserveReference(
            StableComplexDetailsContainerInSimpleReserve complexReserveReference) {
        this.complexReserveReference = complexReserveReference;
    }

    /** 
     * Get the 'AgentName' element value.
     * 
     * @return value
     */
    public String getAgentName() {
        return agentName;
    }

    /** 
     * Set the 'AgentName' element value.
     * 
     * @param agentName
     */
    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }

    /** 
     * Get the 'AgentMail' element value.
     * 
     * @return value
     */
    public String getAgentMail() {
        return agentMail;
    }

    /** 
     * Set the 'AgentMail' element value.
     * 
     * @param agentMail
     */
    public void setAgentMail(String agentMail) {
        this.agentMail = agentMail;
    }

    /** 
     * Get the 'id_Reserve' attribute value.
     * 
     * @return value
     */
    public int getIdReserve() {
        return idReserve;
    }

    /** 
     * Set the 'id_Reserve' attribute value.
     * 
     * @param idReserve
     */
    public void setIdReserve(int idReserve) {
        this.idReserve = idReserve;
    }

    /** 
     * Get the 'id_ComplexReserve' attribute value.
     * 
     * @return value
     */
    public int getIdComplexReserve() {
        return idComplexReserve;
    }

    /** 
     * Set the 'id_ComplexReserve' attribute value.
     * 
     * @param idComplexReserve
     */
    public void setIdComplexReserve(int idComplexReserve) {
        this.idComplexReserve = idComplexReserve;
    }

    /** 
     * Get the 'ComplexReserveName' attribute value.
     * 
     * @return value
     */
    public String getComplexReserveName() {
        return complexReserveName;
    }

    /** 
     * Set the 'ComplexReserveName' attribute value.
     * 
     * @param complexReserveName
     */
    public void setComplexReserveName(String complexReserveName) {
        this.complexReserveName = complexReserveName;
    }

    /** 
     * Get the 'Locator' attribute value.
     * 
     * @return value
     */
    public String getLocator() {
        return locator;
    }

    /** 
     * Set the 'Locator' attribute value.
     * 
     * @param locator
     */
    public void setLocator(String locator) {
        this.locator = locator;
    }

    /** 
     * Get the 'Price' attribute value.
     * 
     * @return value
     */
    public Double getPrice() {
        return price;
    }

    /** 
     * Set the 'Price' attribute value.
     * 
     * @param price
     */
    public void setPrice(Double price) {
        this.price = price;
    }

    /** 
     * Get the 'Header' attribute value.
     * 
     * @return value
     */
    public String getHeader() {
        return header;
    }

    /** 
     * Set the 'Header' attribute value.
     * 
     * @param header
     */
    public void setHeader(String header) {
        this.header = header;
    }

    /** 
     * Get the 'Brief' attribute value.
     * 
     * @return value
     */
    public String getBrief() {
        return brief;
    }

    /** 
     * Set the 'Brief' attribute value.
     * 
     * @param brief
     */
    public void setBrief(String brief) {
        this.brief = brief;
    }

    /** 
     * Get the 'OrderTypeName' attribute value.
     * 
     * @return value
     */
    public String getOrderTypeName() {
        return orderTypeName;
    }

    /** 
     * Set the 'OrderTypeName' attribute value.
     * 
     * @param orderTypeName
     */
    public void setOrderTypeName(String orderTypeName) {
        this.orderTypeName = orderTypeName;
    }

    /** 
     * Get the 'id_ReserveType' attribute value.
     * 
     * @return value
     */
    public int getIdReserveType() {
        return idReserveType;
    }

    /** 
     * Set the 'id_ReserveType' attribute value.
     * 
     * @param idReserveType
     */
    public void setIdReserveType(int idReserveType) {
        this.idReserveType = idReserveType;
    }

    /** 
     * Get the 'id_AgentGroup' attribute value.
     * 
     * @return value
     */
    public int getIdAgentGroup() {
        return idAgentGroup;
    }

    /** 
     * Set the 'id_AgentGroup' attribute value.
     * 
     * @param idAgentGroup
     */
    public void setIdAgentGroup(int idAgentGroup) {
        this.idAgentGroup = idAgentGroup;
    }

    /** 
     * Get the 'id_ClientGroup' attribute value.
     * 
     * @return value
     */
    public int getIdClientGroup() {
        return idClientGroup;
    }

    /** 
     * Set the 'id_ClientGroup' attribute value.
     * 
     * @param idClientGroup
     */
    public void setIdClientGroup(int idClientGroup) {
        this.idClientGroup = idClientGroup;
    }

    /** 
     * Get the 'id_ServiceTeam' attribute value.
     * 
     * @return value
     */
    public int getIdServiceTeam() {
        return idServiceTeam;
    }

    /** 
     * Set the 'id_ServiceTeam' attribute value.
     * 
     * @param idServiceTeam
     */
    public void setIdServiceTeam(int idServiceTeam) {
        this.idServiceTeam = idServiceTeam;
    }

    /** 
     * Get the 'id_ReserveState' attribute value.
     * 
     * @return value
     */
    public int getIdReserveState() {
        return idReserveState;
    }

    /** 
     * Set the 'id_ReserveState' attribute value.
     * 
     * @param idReserveState
     */
    public void setIdReserveState(int idReserveState) {
        this.idReserveState = idReserveState;
    }

    /** 
     * Get the 'ReserveStateName' attribute value.
     * 
     * @return value
     */
    public String getReserveStateName() {
        return reserveStateName;
    }

    /** 
     * Set the 'ReserveStateName' attribute value.
     * 
     * @param reserveStateName
     */
    public void setReserveStateName(String reserveStateName) {
        this.reserveStateName = reserveStateName;
    }

    /** 
     * Get the 'Markup' attribute value.
     * 
     * @return value
     */
    public Double getMarkup() {
        return markup;
    }

    /** 
     * Set the 'Markup' attribute value.
     * 
     * @param markup
     */
    public void setMarkup(Double markup) {
        this.markup = markup;
    }

    /** 
     * Get the 'DateCreate' attribute value.
     * 
     * @return value
     */
    public DateTime getDateCreate() {
        return dateCreate;
    }

    /** 
     * Set the 'DateCreate' attribute value.
     * 
     * @param dateCreate
     */
    public void setDateCreate(DateTime dateCreate) {
        this.dateCreate = dateCreate;
    }

    /** 
     * Get the 'id_Agent' attribute value.
     * 
     * @return value
     */
    public Integer getIdAgent() {
        return idAgent;
    }

    /** 
     * Set the 'id_Agent' attribute value.
     * 
     * @param idAgent
     */
    public void setIdAgent(Integer idAgent) {
        this.idAgent = idAgent;
    }

    /** 
     * Get the 'id_Agreement' attribute value.
     * 
     * @return value
     */
    public int getIdAgreement() {
        return idAgreement;
    }

    /** 
     * Set the 'id_Agreement' attribute value.
     * 
     * @param idAgreement
     */
    public void setIdAgreement(int idAgreement) {
        this.idAgreement = idAgreement;
    }
}
