/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.airarabia.createReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.GDSParameters;
import com.gridnine.xtrip.common.gds.model.GdsReservationCreationParameters;
import com.gridnine.xtrip.common.gds.model.GdsTraveller;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFare;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.server.gds.airarabia.ibus.AirArabiaHelper;
import com.gridnine.xtrip.server.gds.airarabia.ibus.IBusGdsAirArabiaContextKeys;
import com.gridnine.xtrip.server.gds.airarabia.ibus.createReservation.ReservationBuilder;
import com.gridnine.xtrip.server.gds.airarabia.mapping.ConverterUtils;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.test.ModelTestBase;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.junit.Assert;
import org.junit.Test;
import org.opentravel.ota.AirReservationType;
import org.opentravel.ota.OTAAirBookRS;

public class ReservationBuilderTest
extends ModelTestBase {
    @Test
    public void test() throws Exception {
        MessageContext ctx = new MessageContext();
        GdsReservationCreationParameters parameters = new GdsReservationCreationParameters();
        parameters.getGdsTravellers().addAll(this.createGdsTravellers());
        Flight flight = new Flight();
        this.loadXSerializable("flight.xml", (XSerializable)flight);
        ctx.putObject((Enum)IBusGdsContextKeys.FLIGHT, (Object)flight);
        ctx.putObject((Enum)IBusMidofficeContextKeys.RESERVATION_CREATION_PARAMETERS, (Object)parameters);
        OTAAirBookRS response = this.parseObject("AirBookRS.xml", OTAAirBookRS.class);
        ctx.putObject((Enum)IBusGdsAirArabiaContextKeys.AIR_RESERVATION, response.getAirReservationList().get(0));
        GDSParameters gdsParams = new GDSParameters();
        ctx.putObject((Enum)IBusGdsContextKeys.GDS_PARAMETERS, (Object)gdsParams);
        ctx.putObject((Enum)IBusMidofficeContextKeys.TRAVELLERS, this.createTravellers());
        ReservationBuilder builder = new ReservationBuilder();
        builder.process(ctx);
        Reservation res = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        BigDecimal sum = BigDecimal.ZERO;
        for (BaseProduct baseProduct : res.getProducts()) {
            Product product = (Product)baseProduct;
            for (ProductFare pf : product.getFares()) {
                sum = sum.add(pf.getEquivalentFare());
            }
            for (Tax tax : product.getTaxes()) {
                sum = sum.add(tax.getEquivalentAmount());
            }
        }
        Assert.assertTrue((sum.compareTo(BigDecimal.valueOf(50479.2)) == 0 ? 1 : 0) != 0);
        BigDecimal calcSum = AirArabiaHelper.calcReservationBalance(res);
        BigDecimal sumInRS = ((AirReservationType)response.getAirReservationList().get(0)).getPriceInfo().getItinTotalFare().getTotalFare().getAmount();
        Assert.assertEquals((Object)calcSum, (Object)sumInRS);
    }

    private Collection<Traveller> createTravellers() {
        ArrayList<Traveller> travellers = new ArrayList<Traveller>();
        Traveller t1 = new Traveller();
        t1.setUid("1");
        t1.setNameInGds("A1");
        Traveller t2 = new Traveller();
        t2.setUid("2");
        t2.setNameInGds("C2");
        travellers.add(t1);
        travellers.add(t2);
        return travellers;
    }

    private Collection<GdsTraveller> createGdsTravellers() {
        ArrayList<GdsTraveller> travellers = new ArrayList<GdsTraveller>();
        GdsTraveller t1 = new GdsTraveller();
        t1.setTravellerUid("1");
        t1.setPassengerType(ConverterUtils.parsePassengerType("ADT"));
        GdsTraveller t2 = new GdsTraveller();
        t2.setTravellerUid("2");
        t2.setPassengerType(ConverterUtils.parsePassengerType("CHD"));
        travellers.add(t1);
        travellers.add(t2);
        return travellers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T parseObject(String fileName, Class<T> clazz) throws JiBXException, IOException {
        IBindingFactory jc = BindingDirectory.getFactory(clazz);
        IUnmarshallingContext unmarshaller = jc.createUnmarshallingContext();
        try (InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(fileName);){
            Object object = unmarshaller.unmarshalDocument(is, "UTF-8");
            return (T)object;
        }
    }
}

