/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.airarabia.ibus;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.gds.model.BaseGDSEntity;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.GDSParameters;
import com.gridnine.xtrip.common.midoffice.helper.CodeTranslator;
import com.gridnine.xtrip.common.midoffice.helper.ReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.LuggageInfo;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFare;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.standard.helpers.NamedValueHelper;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.SimpleCompositeNumber;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.XSUtil;
import com.gridnine.xtrip.server.db.storage.model.sn.SequenceNumberHelper;
import com.gridnine.xtrip.server.gds.airarabia.ibus.AirArabiaAvailErrorType;
import com.gridnine.xtrip.server.gds.airarabia.mapping.ConverterUtils;
import com.gridnine.xtrip.server.jibx.JiBXHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.TimeZone;
import java.util.UUID;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.FastDateFormat;
import org.opentravel.ota.AAOTAAirBaggageDetailsRS;
import org.opentravel.ota.ErrorType;
import org.opentravel.ota.ErrorsType;

public class AirArabiaHelper {
    public static final String JSESSION_IN_HEADER_NAME = "set-cookie";
    public static final String JSESSION_ATR_IN_HEADER_VALUE = "JSESSIONID";
    public static final String JSESSION_OUT_HEADER_NAME = "Cookie";
    private static final CodeTranslator TRANSLATOR = new CodeTranslator(new String[]{CodeSystem.IATA.name()});
    private static final FastDateFormat DTF = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm", (TimeZone)TimeZone.getDefault());

    public static <D extends BaseDictionary> String getNativeCode(DictionaryReference<D> dictRef) {
        return TRANSLATOR.getNativeCode(dictRef);
    }

    public static <D extends BaseDictionary> DictionaryReference<D> resolveNativeCode(Class<D> cls, String code) {
        return TRANSLATOR.resolveNativeCode(cls, code);
    }

    public static String getFakeReservationNumber() throws Exception {
        SimpleCompositeNumber number = new SimpleCompositeNumber();
        SequenceNumberHelper.get().generateInc((CompositeNumber)number, AirArabiaHelper.class.getName(), null);
        return "G9" + number.getNumber();
    }

    public static AirArabiaAvailErrorType checkWsResponse(ErrorsType errorsType) throws Exception {
        return AirArabiaHelper.checkWsResponse(errorsType, false, null, null);
    }

    public static AirArabiaAvailErrorType checkWsResponse(ErrorsType errorsType, boolean writeLogsAvailable, Object request, Object response) throws Exception {
        if (errorsType == null || errorsType.getErrorList() == null || errorsType.getErrorList().isEmpty()) {
            return AirArabiaAvailErrorType.NO_ERRORS;
        }
        boolean writeLogs = false;
        StringBuilder sb = new StringBuilder();
        for (ErrorType error : errorsType.getErrorList()) {
            String errorCode = error.getErrorWarningAttributeGroup().getCode();
            String errorText = error.getErrorWarningAttributeGroup().getShortText();
            if ("40".equals(errorCode)) {
                throw Xeption.forEndUser((String)"\u0412\u0440\u0435\u043c\u044f \u0432\u0430\u0448\u0435\u0439 \u0441\u0435\u0441\u0441\u0438\u0438 \u0438\u0441\u0442\u0435\u043a\u043b\u043e. \u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u043f\u0440\u043e\u0438\u0437\u0432\u0435\u0441\u0442\u0438 \u043f\u043e\u0438\u0441\u043a \u0435\u0449\u0435 \u0440\u0430\u0437.", (Object[])new Object[0]);
            }
            if ("311".equals(errorCode) && errorText.matches(".*first name.*")) {
                throw Xeption.forEndUser((String)"INVALID_NAME_CHARACTER", (Object[])new Object[0]);
            }
            if (sb.length() > 0) {
                sb.append("; ");
            }
            if ("320".equals(errorCode)) {
                return AirArabiaAvailErrorType.INCORRECT_LOCATION;
            }
            if ("322".equals(errorCode)) {
                return AirArabiaAvailErrorType.FLIGHTS_NOT_FOUND;
            }
            sb.append(errorText);
            if (!"Selected Flight Seats or Fares Not Available [No seats/fares available]".equals(errorText)) continue;
            writeLogs = true;
        }
        if (writeLogsAvailable && writeLogs) {
            AirArabiaHelper.logTrace(request, response);
        }
        throw Xeption.forDeveloper((String)sb.toString(), (Object[])new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void logTrace(Object request, Object response) throws Exception {
        String uuid = UUID.randomUUID().toString();
        try (FileOutputStream fos = new FileOutputStream(new File(Environment.getTempFolder(), "airArabia-transactions-" + uuid + ".xml"));
             XMLStreamWriter writer = XSUtil.wrapForPrettyPrinting((XMLStreamWriter)XSUtil.getXMLOutputFactory().createXMLStreamWriter(fos));){
            writer.writeStartDocument();
            writer.writeStartElement("transaction");
            writer.writeAttribute("date", DTF.format(new Date()));
            AirArabiaHelper.writeObject(fos, writer, request, "request");
            AirArabiaHelper.writeObject(fos, writer, response, "response");
            writer.writeEndElement();
            writer.writeEndDocument();
        }
    }

    private static void writeObject(FileOutputStream fos, XMLStreamWriter writer, Object object, String name) throws Exception {
        if (object == null) {
            return;
        }
        writer.writeStartElement(name);
        writer.writeCharacters("");
        writer.flush();
        MiscUtil.writeBytesWithoutXmlHeader((OutputStream)fos, (byte[])JiBXHelper.write((Object)object));
        fos.flush();
        writer.writeEndElement();
    }

    public static String correctTaxCode(String code) {
        String correctedCode = code;
        if (correctedCode.contains("/")) {
            correctedCode = correctedCode.substring(0, code.indexOf("/"));
        }
        correctedCode = correctedCode.replaceAll(" ", "");
        return correctedCode;
    }

    public static BigDecimal calcReservationBalance(Reservation reservation) {
        BigDecimal res = new BigDecimal(0);
        for (BaseProduct prod : reservation.getProducts()) {
            if (!(prod instanceof Product)) continue;
            Product p = (Product)prod;
            for (ProductFare fare : p.getFares()) {
                res = res.add(fare.getEquivalentFare());
            }
            for (Tax tax : p.getTaxes()) {
                res = res.add(tax.getEquivalentAmount());
            }
        }
        return res;
    }

    public static LuggageInfo getLuggageInfo(Flight flight) {
        String bagCode = ConverterUtils.getCustomProperty((BaseGDSEntity)flight, "baggageWeight");
        return AirArabiaHelper.getLuggageInfoByCode(bagCode);
    }

    public static LuggageInfo getLuggageInfoByCode(String bagCode) {
        if (AirArabiaHelper.parseBaggageWeightFromCode(bagCode) == 0) {
            return AirProductHelper.buildNilLuggageInfo();
        }
        return AirProductHelper.parseLuggageInfo((String)bagCode);
    }

    public static int parseBaggageWeightFromCode(String code) {
        if (TextUtil.isBlank((String)code) || code.toUpperCase().equals("NO BAG")) {
            return 0;
        }
        try {
            return Integer.parseInt(code);
        }
        catch (NumberFormatException e) {
            return Integer.parseInt(code.substring(0, code.indexOf(" ")));
        }
    }

    public static void setPropBaggageSegments(Flight flight, List<AAOTAAirBaggageDetailsRS> responses) {
        HashSet<String> segments = new HashSet<String>();
        for (AAOTAAirBaggageDetailsRS response : responses) {
            for (AAOTAAirBaggageDetailsRS.BaggageDetailsResponses.OnDBaggageDetailsResponse baggages : response.getBaggageDetailsResponses().getOnDBaggageDetailsResponseList()) {
                for (AAOTAAirBaggageDetailsRS.BaggageDetailsResponses.OnDBaggageDetailsResponse.OnDFlightSegmentInfo segmentInfo : baggages.getOnDFlightSegmentInfoList()) {
                    segments.add(segmentInfo.getRPH());
                }
            }
        }
        NamedValueHelper.setValueForName((String)"baggageSegments", (String)StringUtils.join(segments, (String)";"), (Collection)flight.getCustomProperties());
    }

    public static boolean withBaggage(DictionaryReference<PassengerType> ptRef) {
        return !DictHelper.isInfantPassengerType(ptRef);
    }

    public static boolean isBspBlankOwner(Reservation reservation, GDSParameters gdsParameters) {
        EntityReference blankOwnerRef = reservation != null ? ((Product)reservation.getProducts().get(0)).getBlankOwnerRef() : gdsParameters.getBlankOwner();
        Organization blankOwner = (Organization)EntityStorage.get().resolve(blankOwnerRef).getEntity();
        return "BSP".equals(blankOwner.getCode());
    }

    public static String getRecordLocator(Reservation reservation) {
        return ReservationGdsNameInfoHelper.getOnlineRecordLocator((Reservation)reservation, (RecordLocatorType)RecordLocatorType.DEFAULT);
    }
}

