/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.airarabia.ibus;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.airarabia.model.AirArabiaGdsAccount;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.airarabia.ibus.AirArabiaWsMethod;
import com.gridnine.xtrip.server.gds.airarabia.ibus.IBusGdsAirArabiaContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.jibxws.IBusJibxWsContextKeys;
import com.gridnine.xtrip.server.jibxws.WsRequest;
import org.oasisopen.docs.wss.oasis200401wsswssecuritysecext1.AttributedString;
import org.oasisopen.docs.wss.oasis200401wsswssecuritysecext1.PasswordString;
import org.oasisopen.docs.wss.oasis200401wsswssecuritysecext1.SecurityHeaderType;
import org.oasisopen.docs.wss.oasis200401wsswssecuritysecext1.UsernameTokenType;

public class AirArabiaWsRequestBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        WsRequest request = new WsRequest();
        request.getHeaders().add(this.createSecurityHeader(ctx));
        Object payload = ctx.getMandatoryObject((Enum)IBusGdsAirArabiaContextKeys.AIRARABIA_WS_REQUEST_PAYLOAD);
        request.setPayload(payload);
        AirArabiaWsMethod method = (AirArabiaWsMethod)((Object)ctx.getObject((Enum)IBusGdsAirArabiaContextKeys.AIRARABIA_WS_REQUEST_ACTION));
        request.setAction(method.getAction());
        request.setEndpointAddress(AirArabiaWsRequestBuilder.getEndpointAddress(ctx));
        String jsessionId = (String)ctx.getObject((Enum)IBusGdsAirArabiaContextKeys.JSESSIONID);
        if (!TextUtil.isBlank((String)jsessionId)) {
            request.setHttpHeader("Cookie", jsessionId);
        }
        request.setUseTrustyHostnameVerifier(true);
        request.setUseSsl(true);
        ctx.putObject((Enum)IBusJibxWsContextKeys.WS_REQUEST, (Object)request);
        ctx.putObject((Enum)IBusGdsAirArabiaContextKeys.AIRARABIA_WS_REQUEST_PAYLOAD_COPY, payload);
        ctx.putObject((Enum)IBusGdsAirArabiaContextKeys.AIRARABIA_WS_REQUEST_PAYLOAD, null);
    }

    private SecurityHeaderType createSecurityHeader(MessageContext ctx) {
        EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        SecurityHeaderType security = new SecurityHeaderType();
        UsernameTokenType usernameToken = new UsernameTokenType();
        security.setUsernameToken(usernameToken);
        AttributedString userName = new AttributedString();
        userName.setString(((AirArabiaGdsAccount)accountCtr.getEntity()).getAccount());
        usernameToken.setUsername(userName);
        PasswordString passwordString = new PasswordString();
        usernameToken.setPassword(passwordString);
        AttributedString password = new AttributedString();
        passwordString.setAttributedString(password);
        password.setString(((AirArabiaGdsAccount)accountCtr.getEntity()).getPassword());
        passwordString.setType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText");
        return security;
    }

    private static String getEndpointAddress(MessageContext ctx) {
        EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        return ((AirArabiaGdsAccount)accountCtr.getEntity()).getAddress();
    }
}

