/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.airarabia.ibus.common;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.airarabia.model.AirArabiaGdsAccount;
import com.gridnine.xtrip.common.gds.model.BaseGDSEntity;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSearchParameters;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import com.gridnine.xtrip.common.gds.model.RouteType;
import com.gridnine.xtrip.common.gds.model.SeatPreferences;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.standard.helpers.NamedValueHelper;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.airarabia.ibus.AirArabiaHelper;
import com.gridnine.xtrip.server.gds.airarabia.ibus.AirArabiaWsMethod;
import com.gridnine.xtrip.server.gds.airarabia.ibus.IBusGdsAirArabiaContextKeys;
import com.gridnine.xtrip.server.gds.airarabia.mapping.ConverterUtils;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.opentravel.ota.BaggageRequestAttributes;
import org.opentravel.ota.OTAAirPriceRQ;
import org.opentravel.ota.SpecialReqDetailsType;

public class AirPriceRQBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        OTAAirPriceRQ req = this.buildRequest(ctx);
        ctx.putObject((Enum)IBusGdsAirArabiaContextKeys.AIRARABIA_WS_REQUEST_PAYLOAD, (Object)req);
        ctx.putObject((Enum)IBusGdsAirArabiaContextKeys.AIRARABIA_WS_REQUEST_ACTION, (Object)AirArabiaWsMethod.GetPrice);
    }

    private OTAAirPriceRQ buildRequest(MessageContext ctx) {
        RouteType routeType;
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsAirArabiaContextKeys.FLIGHT);
        String transactionId = ConverterUtils.getCustomProperty((BaseGDSEntity)flight, "transactionId");
        EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        FlightSearchParameters fsp = (FlightSearchParameters)ctx.getObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_PARAMETERS);
        OTAAirPriceRQ req = new OTAAirPriceRQ();
        req.setOTAPayloadStdAttributes(ConverterUtils.createPayloadAttrs(transactionId));
        req.setPOS(ConverterUtils.buildPos(((AirArabiaGdsAccount)accountCtr.getEntity()).getAccount()));
        if (fsp != null) {
            routeType = GDSHelper.getRouteType((List)fsp.getRoute());
            req.setAirItinerary(ConverterUtils.createAirItineraryType(flight, routeType));
            NamedValueHelper.setValueForName((String)"routeType", (String)routeType.name(), (Collection)flight.getCustomProperties());
        } else {
            routeType = RouteType.valueOf((String)NamedValueHelper.getValueForName((String)"routeType", (Collection)flight.getCustomProperties()));
            req.setAirItinerary(ConverterUtils.createAirItineraryType(flight, routeType));
        }
        req.setTravelerInfoSummary(ConverterUtils.createTravelersInfo(flight.getSeats()));
        String bagCode = ConverterUtils.getCustomProperty((BaseGDSEntity)flight, "baggageWeight");
        if (!TextUtil.isBlank((String)bagCode)) {
            SpecialReqDetailsType specialReq = new SpecialReqDetailsType();
            specialReq.setBaggageRequests(this.buildBaggageRequests(flight, flight.getSeats(), bagCode));
            req.getTravelerInfoSummary().getSpecialReqDetailList().add(specialReq);
        }
        return req;
    }

    private SpecialReqDetailsType.BaggageRequests buildBaggageRequests(Flight flight, List<SeatPreferences> seats, String bagCode) {
        SpecialReqDetailsType.BaggageRequests bagReqs = new SpecialReqDetailsType.BaggageRequests();
        List<String> segments = Arrays.asList(StringUtils.split((String)ConverterUtils.getCustomProperty((BaseGDSEntity)flight, "baggageSegments"), (String)";"));
        String carrierCode = flight.getCarrier().getCode();
        for (FlightSegmentTariff tariff : flight.getSegmentTariffs()) {
            for (FlightSegment fs : tariff.getSegments()) {
                String rph = ConverterUtils.getCustomProperty((BaseGDSEntity)fs, "segmentRPH");
                if (!segments.contains(rph)) continue;
                int index = 1;
                for (SeatPreferences seat : seats) {
                    if (!AirArabiaHelper.withBaggage((DictionaryReference<PassengerType>)seat.getPassengerType())) continue;
                    for (int q = 0; q < seat.getCount(); ++q) {
                        SpecialReqDetailsType.BaggageRequests.BaggageRequest bagReq = new SpecialReqDetailsType.BaggageRequests.BaggageRequest();
                        bagReq.setDepartureDate(fs.getDateBegin());
                        bagReq.setFlightNumber(carrierCode + fs.getFlightNumber());
                        bagReq.getFlightRefNumberRPHList().add(rph);
                        bagReq.getTravelerRefNumberRPHList().add(ConverterUtils.getTravelerRPH((DictionaryReference<PassengerType>)seat.getPassengerType(), index));
                        bagReq.setBaggageRequestAttributes(new BaggageRequestAttributes());
                        bagReq.getBaggageRequestAttributes().setBaggageCode(bagCode);
                        bagReq.getBaggageRequestAttributes().setBaggageOndGroupId("");
                        bagReqs.getBaggageRequestList().add(bagReq);
                        ++index;
                    }
                }
            }
        }
        return bagReqs;
    }
}

