/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.airarabia.ibus.createReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.airarabia.model.AirArabiaGdsAccount;
import com.gridnine.xtrip.common.gds.model.BaseGDSEntity;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.GdsReservationCreationParameters;
import com.gridnine.xtrip.common.gds.model.GdsTraveller;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.midoffice.helper.CodeTranslator;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.Customer;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.Gender;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Address;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonAddress;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.LocaleUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.airarabia.ibus.AirArabiaWsMethod;
import com.gridnine.xtrip.server.gds.airarabia.ibus.IBusGdsAirArabiaContextKeys;
import com.gridnine.xtrip.server.gds.airarabia.mapping.ConverterUtils;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.jibxws.WsParts;
import com.isaaviation.thinair.webservices.ota.extensions.AAAddressType;
import com.isaaviation.thinair.webservices.ota.extensions.AAAirBookRQExt;
import com.isaaviation.thinair.webservices.ota.extensions.AAContactInfoType;
import com.isaaviation.thinair.webservices.ota.extensions.AACountryType;
import com.isaaviation.thinair.webservices.ota.extensions.AAPersonNameType;
import com.isaaviation.thinair.webservices.ota.extensions.AATelephoneType;
import java.math.BigInteger;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.opentravel.ota.AirItineraryPricingInfoType;
import org.opentravel.ota.AirTravelerType;
import org.opentravel.ota.BookingPriceInfoType;
import org.opentravel.ota.OTAAirBookRQ;
import org.opentravel.ota.PTCFareBreakdownType;
import org.opentravel.ota.PersonNameType;
import org.opentravel.ota.PricedItineraryType;
import org.opentravel.ota.TPAExtensionsType;
import org.opentravel.ota.TravelerInfoType;
import org.opentravel.ota.TravelerRefNumberGroup;

public class AirBookRQBuilder
extends BaseProcessor {
    private final CodeTranslator codeTranslator = new CodeTranslator(new String[]{CodeSystem.IATA.name()});

    public void process(MessageContext ctx) throws Exception {
        WsParts parts = new WsParts();
        parts.getParts().add(this.buildRequest(ctx));
        parts.getParts().add(this.buildExt(ctx));
        ctx.putObject((Enum)IBusGdsAirArabiaContextKeys.AIRARABIA_WS_REQUEST_PAYLOAD, (Object)parts);
        ctx.putObject((Enum)IBusGdsAirArabiaContextKeys.AIRARABIA_WS_REQUEST_ACTION, (Object)AirArabiaWsMethod.Book);
    }

    private OTAAirBookRQ buildRequest(MessageContext ctx) {
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsAirArabiaContextKeys.FLIGHT);
        String transactionId = ConverterUtils.getCustomProperty((BaseGDSEntity)flight, "transactionId");
        EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        OTAAirBookRQ req = new OTAAirBookRQ();
        req.setPOS(ConverterUtils.buildPos(((AirArabiaGdsAccount)accountCtr.getEntity()).getAccount()));
        req.setOTAPayloadStdAttributes(ConverterUtils.createPayloadAttrs(transactionId));
        PricedItineraryType pricedItin = (PricedItineraryType)ctx.getMandatoryObject((Enum)IBusGdsAirArabiaContextKeys.FLIGHT_PRICE);
        req.setAirItinerary(pricedItin.getAirItinerary());
        BookingPriceInfoType bookPrice = new BookingPriceInfoType();
        AirItineraryPricingInfoType priceInfo = pricedItin.getAirItineraryPricingInfo();
        bookPrice.setItinTotalFare(priceInfo.getItinTotalFare());
        bookPrice.setPricingSource(priceInfo.getPricingSource());
        bookPrice.setPTCFareBreakdowns1(priceInfo.getPTCFareBreakdowns1());
        req.setPriceInfo(bookPrice);
        req.setTravelerInfo(this.createTravellersInfo(ctx, priceInfo));
        req.setTPAExtensions(new TPAExtensionsType());
        return req;
    }

    private TravelerInfoType createTravellersInfo(MessageContext ctx, AirItineraryPricingInfoType priceInfo) {
        GdsReservationCreationParameters resParams = (GdsReservationCreationParameters)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION_CREATION_PARAMETERS);
        Collection travellers = (Collection)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.TRAVELLERS);
        ArrayList gdsTravellers = new ArrayList();
        gdsTravellers.addAll(resParams.getGdsTravellers());
        TravelerInfoType travelerInfos = new TravelerInfoType();
        for (PTCFareBreakdownType fare : priceInfo.getPTCFareBreakdowns1().getPTCFareBreakdownList()) {
            DictionaryReference<PassengerType> passType = ConverterUtils.parsePassengerType(fare.getPassengerTypeQuantity().getCode());
            int passTypeCount = ((BigInteger)MiscUtil.guarded((Object)fare.getPassengerTypeQuantity().getQuantity(), (Object)BigInteger.ONE)).intValue();
            block1: for (int ind = 0; ind < passTypeCount; ++ind) {
                for (GdsTraveller gdsTrav : gdsTravellers) {
                    if (!gdsTrav.getPassengerType().equals(passType)) continue;
                    Traveller traveller = (Traveller)CollectionUtil.find((Iterable)travellers, (String)gdsTrav.getTravellerUid());
                    AirTravelerType airTraveler = new AirTravelerType();
                    PersonNameType personName = new PersonNameType();
                    personName.getGivenNameList().add(traveller.getPassport().getFirstName());
                    personName.setSurname(traveller.getPassport().getLastName());
                    personName.getNameTitleList().add(ConverterUtils.getTitle(traveller.getPassport().getGender(), passType));
                    airTraveler.setPersonName(personName);
                    airTraveler.setPassengerTypeCode(fare.getPassengerTypeQuantity().getCode());
                    airTraveler.setTravelerRefNumber((TravelerRefNumberGroup)fare.getTravelerRefNumberList().get(ind));
                    traveller.setNameInGds(airTraveler.getTravelerRefNumber().getRPH());
                    airTraveler.setBirthDate(new Date(traveller.getPassport().getBirthday().getTime()));
                    AirTravelerType.Document doc = new AirTravelerType.Document();
                    if (traveller.getPassport().getCitizenship() != null) {
                        doc.setDocHolderNationality(this.codeTranslator.getNativeCode(traveller.getPassport().getCitizenship()));
                    }
                    airTraveler.getDocumentList().add(doc);
                    travelerInfos.getAirTravelerList().add(airTraveler);
                    gdsTravellers.remove(gdsTrav);
                    continue block1;
                }
            }
        }
        return travelerInfos;
    }

    private AAAirBookRQExt buildExt(MessageContext ctx) {
        GeoLocation city;
        Address addr;
        List orgAddresses;
        Customer customer = (Customer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.CUSTOMER);
        SalesContext salesCtx = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        Collection travellers = (Collection)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.TRAVELLERS);
        Person agent = (Person)EntityStorage.get().resolve(salesCtx.getAgent()).getEntity();
        EntityContainer orgCtr = ProfileHelper.getMainEmployment((Person)agent);
        Organization org = orgCtr != null ? (Organization)orgCtr.getEntity() : null;
        AAAirBookRQExt ext = new AAAirBookRQExt();
        AAContactInfoType contact = new AAContactInfoType();
        contact.setPersonName(new AAPersonNameType());
        contact.getPersonName().setFirstName(L10nStringHelper.getValue((L10nString)agent.getFirstName(), (Locale)LocaleUtil.LOCALE_EN, (boolean)true));
        if (TextUtil.isBlank((String)contact.getPersonName().getFirstName())) {
            contact.getPersonName().setFirstName(TextUtil.translit((String)L10nStringHelper.getValue((L10nString)agent.getFirstName(), (Locale)LocaleUtil.LOCALE_RU, (boolean)false), (boolean)true));
        }
        if (TextUtil.isBlank((String)contact.getPersonName().getFirstName())) {
            contact.getPersonName().setFirstName("name");
        }
        contact.getPersonName().setLastName(L10nStringHelper.getValue((L10nString)agent.getLastName(), (Locale)LocaleUtil.LOCALE_EN, (boolean)true));
        if (TextUtil.isBlank((String)contact.getPersonName().getLastName())) {
            contact.getPersonName().setLastName(TextUtil.translit((String)L10nStringHelper.getValue((L10nString)agent.getLastName(), (Locale)LocaleUtil.LOCALE_RU, (boolean)false), (boolean)true));
        }
        if (TextUtil.isCyrillic((String)contact.getPersonName().getFirstName(), (boolean)true)) {
            contact.getPersonName().setFirstName(TextUtil.translit((String)contact.getPersonName().getFirstName(), (boolean)true));
        }
        if (TextUtil.isCyrillic((String)contact.getPersonName().getLastName(), (boolean)true)) {
            contact.getPersonName().setLastName(TextUtil.translit((String)contact.getPersonName().getLastName(), (boolean)true));
        }
        contact.getPersonName().setTitle(ConverterUtils.getTitle(agent.getGender() != null ? agent.getGender() : Gender.MALE, (DictionaryReference<PassengerType>)DictHelper.getAdultPassengerType()));
        boolean foundEmail = false;
        Communication travellerPhone = null;
        block0: for (Traveller traveller : travellers) {
            for (Communication comm : ProfileHelper.getPhoneCommunications((List)traveller.getCommunications())) {
                if (comm == null) continue;
                travellerPhone = comm;
                break block0;
            }
        }
        if (travellerPhone != null) {
            contact.setTelephone(new AATelephoneType());
            contact.getTelephone().setAreaCode(ProfileHelper.normalizeCommunicationPart((String)travellerPhone.getCityCode()));
            contact.getTelephone().setCountryCode(ProfileHelper.normalizeCommunicationPart((String)travellerPhone.getCountryCode()));
            contact.getTelephone().setPhoneNumber(ProfileHelper.normalizeCommunicationPart((String)travellerPhone.getSense()));
        }
        if (customer.getCommunications() != null) {
            for (Communication comm : customer.getCommunications()) {
                if (!comm.getType().equals((Object)CommunicationType.EMAIL)) continue;
                contact.setEmail(ProfileHelper.normalizeCommunicationPart((String)comm.getSense()));
                foundEmail = true;
            }
        }
        for (Communication comm : agent.getCommunications()) {
            if (!comm.getType().equals((Object)CommunicationType.EMAIL) || foundEmail) continue;
            contact.setEmail(ProfileHelper.normalizeCommunicationPart((String)comm.getSense()));
            foundEmail = true;
        }
        DictionaryReference countryRef = null;
        if (agent.getPassports().size() > 0) {
            countryRef = ((Passport)agent.getPassports().get(0)).getCitizenship();
        }
        if (countryRef == null && agent.getAddresses().size() > 0) {
            countryRef = ((PersonAddress)agent.getAddresses().get(0)).getCountry();
        }
        if (countryRef == null && org != null && (orgAddresses = ProfileHelper.getOrganizationAddresses((Organization)org)).size() > 0 && (countryRef = (addr = (Address)orgAddresses.get(0)).getCountry()) == null && addr.getCity() != null && (city = (GeoLocation)DictionaryCache.get().resolveReference(addr.getCity())) != null) {
            countryRef = city.getCountry();
        }
        contact.setAddress(new AAAddressType());
        contact.getAddress().setCountryName(new AACountryType());
        if (countryRef == null) {
            countryRef = ((Country)DictHelper.findCountryByCode((String)"RU").iterator().next()).toReference();
        }
        Country country = (Country)DictionaryCache.get().resolveReference(countryRef);
        contact.getAddress().getCountryName().setCountryCode(country.getCode());
        contact.getAddress().getCountryName().setCountryName(DictHelper.toStringWithL10n((DictionaryReference)countryRef, (Locale)LocaleUtil.LOCALE_EN));
        ext.setContactInfo(contact);
        return ext;
    }
}

