/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.airarabia.ibus.createReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.FareInfo;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import com.gridnine.xtrip.common.gds.model.GdsReservationCreationParameters;
import com.gridnine.xtrip.common.gds.model.GdsTraveller;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFare;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.Streams;
import com.gridnine.xtrip.server.gds.airarabia.ibus.AirArabiaHelper;
import com.gridnine.xtrip.server.gds.airarabia.ibus.IBusGdsAirArabiaContextKeys;
import com.gridnine.xtrip.server.gds.airarabia.mapping.ConverterUtils;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.opentravel.ota.AirItineraryType;
import org.opentravel.ota.AirReservationType;
import org.opentravel.ota.PTCFareBreakdownType;
import org.opentravel.ota.TicketingInfoType;
import org.opentravel.ota.TravelerRefNumberGroup;
import org.opentravel.ota.UniqueIDType;

public class ReservationBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        AirReservationType airRes = (AirReservationType)ctx.getObject((Enum)IBusGdsAirArabiaContextKeys.AIR_RESERVATION);
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsAirArabiaContextKeys.FLIGHT);
        GdsReservationCreationParameters resParams = (GdsReservationCreationParameters)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION_CREATION_PARAMETERS);
        Collection travellers = (Collection)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.TRAVELLERS);
        Reservation res = this.buildReservation(flight, resParams.getGdsTravellers(), travellers, airRes);
        ctx.putObject((Enum)IBusMidofficeContextKeys.RESERVATION, (Object)res);
    }

    private Reservation buildReservation(Flight flight, List<GdsTraveller> gdsTravellers, Collection<Traveller> travellers, AirReservationType airRes) throws Exception {
        Reservation res = new Reservation();
        res.setPricingDate(new Date());
        res.setRefreshFromGdsDate(new Date());
        res.setResDate(new Date());
        if (airRes != null) {
            CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)res, (GdsName)GdsName.AIR_ARABIA, (RecordLocatorType)RecordLocatorType.DEFAULT, (String)((UniqueIDType)airRes.getBookingReferenceIDList().get(0)).getUniqueIDGroup().getID());
            Date timeLimit = ((TicketingInfoType)airRes.getTicketingList().get(0)).getTicketTimeLimit();
            res.setPqTimeLimit(timeLimit);
        } else {
            CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)res, (GdsName)GdsName.AIR_ARABIA, (RecordLocatorType)RecordLocatorType.DEFAULT, (String)AirArabiaHelper.getFakeReservationNumber());
        }
        for (GdsTraveller gdsTraveller : gdsTravellers) {
            Traveller traveller = (Traveller)CollectionUtil.find(travellers, (String)gdsTraveller.getTravellerUid());
            Product p = new Product();
            p.setPassengerType(gdsTraveller.getPassengerType());
            p.setProductCategory(ProductCategory.AIR);
            p.setStatus(ProductStatus.BOOKING);
            p.setTariffType(TariffType.REGULAR);
            p.setTraveller(traveller);
            PTCFareBreakdownType fareInfo = (PTCFareBreakdownType)Streams.single(airRes.getPriceInfo().getPTCFareBreakdowns1().getPTCFareBreakdownList().stream().filter(fi -> p.getPassengerType().equals(ConverterUtils.parsePassengerType(fi.getPassengerTypeQuantity().getCode()))).filter(fi -> ReservationBuilder.rphMatches(fi, traveller)));
            p.setGdsCurrency(fareInfo.getPassengerFare().getTotalFare().getCurrencyCodeGroup().getCurrencyCode());
            p.setIssueDate(new Date());
            p.getSegmentTariffs().addAll(this.createSegmentTariffs(flight, (DictionaryReference<PassengerType>)gdsTraveller.getPassengerType()));
            p.setCarrier(AirArabiaHelper.resolveNativeCode(Airline.class, this.getCarrier(airRes.getAirItinerary())));
            ProductFare fare = new ProductFare();
            fare.setSegmentTariff((SegmentTariff)p.getSegmentTariffs().get(0));
            fare.setBaseFare(MoneyHelper.buildMoney((BigDecimal)fareInfo.getPassengerFare().getEquiBaseFare().getAmount(), (String)fareInfo.getPassengerFare().getEquiBaseFare().getCurrencyCodeGroup().getCurrencyCode()));
            fare.setEquivalentFare(fareInfo.getPassengerFare().getBaseFareCurrencyAmountGroup().getAmount());
            p.getFares().add(fare);
            Tax tax = new Tax();
            tax.setEquivalentAmount(fareInfo.getPassengerFare().getTotalFare().getAmount().subtract(fareInfo.getPassengerFare().getBaseFareCurrencyAmountGroup().getAmount()));
            tax.setCode("XT");
            p.getTaxes().add(tax);
            String rph = ReservationBuilder.getRph(fareInfo);
            traveller.setNameInGds(rph);
            p.setGdsId(rph);
            p.setReservation(res);
            res.getProducts().add(p);
        }
        return res;
    }

    private static boolean rphMatches(PTCFareBreakdownType fareInfo, Traveller traveller) {
        return ReservationBuilder.getRph(fareInfo).startsWith(traveller.getNameInGds() + "$");
    }

    private static String getRph(PTCFareBreakdownType fareInfo) {
        String rph = ((TravelerRefNumberGroup)fareInfo.getTravelerRefNumberList().get(0)).getRPH();
        if (rph.contains("|")) {
            rph = rph.substring(rph.indexOf("|") + 1);
        }
        return rph;
    }

    private List<SegmentTariff> createSegmentTariffs(Flight flight, DictionaryReference<PassengerType> ptRef) {
        ArrayList<SegmentTariff> rtariffs = new ArrayList<SegmentTariff>();
        for (FlightSegmentTariff ftariff : flight.getSegmentTariffs()) {
            SegmentTariff rtariff = new SegmentTariff();
            for (FlightSegment fs : ftariff.getSegments()) {
                Segment seg = new Segment();
                seg.setAirline(fs.getAirline());
                seg.setArriveLocation(fs.getLocationEnd());
                seg.setBoard(fs.getBoard());
                seg.setClassOfSvcCode(fs.getBookingClass());
                seg.setDepartureLocation(fs.getLocationBegin());
                seg.setEndDate(fs.getDateEnd());
                for (FareInfo fi : fs.getFareInfos()) {
                    if (!MiscUtil.equals(ptRef, (Object)fi.getPassengerType())) continue;
                    seg.setFareBasis(fi.getFareBasis());
                    seg.setRemarksSearchContext(fi.getRemarksSearchContext());
                }
                seg.setFlightDuration(Integer.valueOf(fs.getTravelDuration()));
                seg.setFlightNo(fs.getFlightNumber());
                seg.setStartDate(fs.getDateBegin());
                seg.setStarting(fs.isStarting());
                seg.setNotValidBefore(seg.getStartDate());
                seg.setNotValidAfter(seg.getEndDate());
                if (AirArabiaHelper.withBaggage(ptRef)) {
                    seg.setLuggageInfo(AirArabiaHelper.getLuggageInfo(flight));
                } else {
                    seg.setLuggageInfo(AirArabiaHelper.getLuggageInfoByCode(null));
                }
                seg.setCodeShareCarrier(fs.getOperatingAirline());
                seg.setCodeShare(!seg.getAirline().equals((Object)seg.getCodeShareCarrier()));
                rtariff.getSegments().add(seg);
            }
            rtariffs.add(rtariff);
        }
        return rtariffs;
    }

    private String getCarrier(AirItineraryType airItinerary) {
        return (String)CollectionUtil.single((Collection)airItinerary.getOriginDestinationOptionsOriginDestinationOptionList().stream().flatMap(option -> option.getFlightSegmentList().stream()).map(flightSegment -> flightSegment.getFlightNumber().substring(0, 2)).collect(Collectors.toSet()));
    }
}

