/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.airarabia.ibus.searchFlightFares;

import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.model.standard.helpers.NamedValueHelper;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.gds.airarabia.ibus.AirArabiaHelper;
import com.gridnine.xtrip.server.gds.airarabia.ibus.IBusGdsAirArabiaContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseTargetsProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.opentravel.ota.AAOTAAirBaggageDetailsRS;
import org.opentravel.ota.Baggage;

public class AirBaggageFlightsProvider
extends BaseTargetsProvider<Flight> {
    public Collection<Flight> getTargets(MessageContext ctx) throws Exception {
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsAirArabiaContextKeys.FLIGHT_COPY);
        List responses = (List)ctx.getMandatoryObject((Enum)IBusGdsAirArabiaContextKeys.AIRARABIA_BAGGAGE_DETAILS_RS_LIST);
        for (AAOTAAirBaggageDetailsRS response : responses) {
            AirArabiaHelper.checkWsResponse(response.getErrors());
        }
        return this.buildFlights(flight, responses);
    }

    private Collection<Flight> buildFlights(Flight sourceFlight, List<AAOTAAirBaggageDetailsRS> responses) throws Exception {
        ArrayList<Flight> result = new ArrayList<Flight>();
        AirArabiaHelper.setPropBaggageSegments(sourceFlight, responses);
        ArrayList<String> resultBaggageCodes = null;
        for (AAOTAAirBaggageDetailsRS response : responses) {
            for (AAOTAAirBaggageDetailsRS.BaggageDetailsResponses.OnDBaggageDetailsResponse baggages : response.getBaggageDetailsResponses().getOnDBaggageDetailsResponseList()) {
                ArrayList<String> baggageCodes = new ArrayList<String>();
                for (Baggage baggage : baggages.getBaggageList()) {
                    baggageCodes.add(baggage.getBaggageCode());
                }
                if (resultBaggageCodes == null) {
                    resultBaggageCodes = baggageCodes;
                    continue;
                }
                resultBaggageCodes.retainAll(baggageCodes);
            }
        }
        for (String baggageCode : resultBaggageCodes) {
            Flight flight = (Flight)XCloneHelper.clone((XCloneable)sourceFlight, (boolean)true);
            NamedValueHelper.setValueForName((String)"baggageWeight", (String)baggageCode, (Collection)flight.getCustomProperties());
            result.add(flight);
        }
        return result;
    }
}

