/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.airarabia.ibus.searchFlightFares;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.airarabia.model.AirArabiaGdsAccount;
import com.gridnine.xtrip.common.gds.model.BaseGDSEntity;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.server.gds.airarabia.ibus.AirArabiaHelper;
import com.gridnine.xtrip.server.gds.airarabia.ibus.AirArabiaWsMethod;
import com.gridnine.xtrip.server.gds.airarabia.ibus.IBusGdsAirArabiaContextKeys;
import com.gridnine.xtrip.server.gds.airarabia.mapping.ConverterUtils;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.List;
import org.opentravel.ota.AAOTAAirBaggageDetailsRQ;
import org.opentravel.ota.FlightSegmentType;

public class FlightAirBaggageDetailsRQBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        List segments = (List)ctx.getMandatoryObject((Enum)IBusGdsAirArabiaContextKeys.AIRARABIA_LEG_SEGMENTS);
        EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        AAOTAAirBaggageDetailsRQ req = this.buildRequest(flight, segments, (AirArabiaGdsAccount)accountCtr.getEntity());
        ctx.putObject((Enum)IBusGdsAirArabiaContextKeys.AIRARABIA_WS_REQUEST_PAYLOAD, (Object)req);
        ctx.putObject((Enum)IBusGdsAirArabiaContextKeys.AIRARABIA_WS_REQUEST_ACTION, (Object)AirArabiaWsMethod.GetBaggageDetails);
    }

    private AAOTAAirBaggageDetailsRQ buildRequest(Flight flight, List<FlightSegment> segments, AirArabiaGdsAccount gdsAccount) {
        String transactionId = ConverterUtils.getCustomProperty((BaseGDSEntity)flight, "transactionId");
        AAOTAAirBaggageDetailsRQ req = new AAOTAAirBaggageDetailsRQ();
        req.setOTAPayloadStdAttributes(ConverterUtils.createPayloadAttrs(transactionId));
        req.setPOS(ConverterUtils.buildPos(gdsAccount.getAccount()));
        for (FlightSegment fs : segments) {
            AAOTAAirBaggageDetailsRQ.BaggageDetailsRequest bag = new AAOTAAirBaggageDetailsRQ.BaggageDetailsRequest();
            FlightSegmentType bagSegment = new FlightSegmentType();
            bagSegment.setDepartureDateTime(ConverterUtils.dateTimeToStr(fs.getDateBegin()));
            bagSegment.setArrivalDateTime(ConverterUtils.dateTimeToStr(fs.getDateEnd()));
            bagSegment.setFlightNumber(AirArabiaHelper.getNativeCode(fs.getAirline()).concat(fs.getFlightNumber()));
            bagSegment.setRPH(ConverterUtils.getCustomProperty((BaseGDSEntity)fs, "segmentRPH"));
            bagSegment.setDepartureAirport(ConverterUtils.createAirport(ConverterUtils.getCustomProperty((BaseGDSEntity)fs, "depAirportCode")));
            bagSegment.setArrivalAirport(ConverterUtils.createAirport(ConverterUtils.getCustomProperty((BaseGDSEntity)fs, "arrAirportCode")));
            bagSegment.setOperatingAirline(ConverterUtils.createOperatingAirline());
            bag.setFlightSegmentInfo(bagSegment);
            req.getBaggageDetailsRequestList().add(bag);
        }
        return req;
    }
}

