/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.airarabia.ibus.searchFlights;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.airarabia.model.AirArabiaGdsAccount;
import com.gridnine.xtrip.common.gds.model.FlightSearchParameters;
import com.gridnine.xtrip.common.gds.model.RouteSegment;
import com.gridnine.xtrip.common.gds.model.SeatPreferences;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.util.Pair;
import com.gridnine.xtrip.server.gds.airarabia.ibus.AirArabiaWsMethod;
import com.gridnine.xtrip.server.gds.airarabia.ibus.IBusGdsAirArabiaContextKeys;
import com.gridnine.xtrip.server.gds.airarabia.mapping.ConverterUtils;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.opentravel.ota.AirSearchPrefsType;
import org.opentravel.ota.CabinPrefGroup;
import org.opentravel.ota.DirectandStopsGroup;
import org.opentravel.ota.OTAAirAvailRQ;

public class AirAvailRQBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        FlightSearchParameters fsp = (FlightSearchParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_PARAMETERS);
        Collections.sort(fsp.getSeats(), new GDSHelper.SeatsPreferencesComparator());
        List seats = fsp.getSeats();
        EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        Integer matrixSize = (Integer)ctx.getObject((Enum)IBusGdsContextKeys.MATRIX_SIZE);
        Map routeParams = (Map)ctx.getObject((Enum)IBusGdsContextKeys.SEARCH_FLIGHTS_AIRPORTS);
        ctx.putObject((Enum)IBusGdsAirArabiaContextKeys.AIRARABIA_WS_REQUEST_PAYLOAD, (Object)this.buildRequest(fsp, seats, (AirArabiaGdsAccount)accountCtr.getEntity(), matrixSize, routeParams));
        ctx.putObject((Enum)IBusGdsAirArabiaContextKeys.AIRARABIA_WS_REQUEST_ACTION, (Object)AirArabiaWsMethod.GetAvailability);
    }

    private OTAAirAvailRQ buildRequest(FlightSearchParameters fsp, List<SeatPreferences> seats, AirArabiaGdsAccount account, Integer matrixSize, Map<RouteSegment, Pair<String>> routeParams) {
        OTAAirAvailRQ req = new OTAAirAvailRQ();
        req.setOTAPayloadStdAttributes(ConverterUtils.createPayloadAttrs(null));
        req.setPOS(ConverterUtils.buildPos(account.getAccount()));
        for (RouteSegment seg : fsp.getRoute()) {
            OTAAirAvailRQ.OriginDestinationInformation info = new OTAAirAvailRQ.OriginDestinationInformation();
            int dateTolerance = 0;
            if (account.isApplySearchMatrix() && matrixSize != null) {
                dateTolerance = matrixSize;
            }
            info.setDepartureDateTime(ConverterUtils.createTimeStamp(seg.getDate(), dateTolerance, dateTolerance));
            Pair<String> route = routeParams.get(seg);
            info.setOriginLocationLocationType(ConverterUtils.createLocation((String)route.getFirst()));
            info.setDestinationLocationLocationType(ConverterUtils.createLocation((String)route.getLast()));
            req.getOriginDestinationInformationList().add(info);
        }
        req.setTravelerInfoSummary(ConverterUtils.createTravelersInfo(seats));
        req.setTravelPreferences(new AirSearchPrefsType());
        if (fsp.getServiceClass() != null) {
            CabinPrefGroup cabin = new CabinPrefGroup();
            cabin.setCabin(ConverterUtils.convertClassOfService(fsp.getServiceClass()));
            req.getTravelPreferences().getCabinPrefList().add(cabin);
        }
        if (fsp.isSkipConnected()) {
            req.setDirectandStopsGroup(new DirectandStopsGroup());
            req.getDirectandStopsGroup().setDirectFlightsOnly(Boolean.valueOf(true));
        }
        return req;
    }
}

