/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.airarabia.ibus.searchFlights;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.airarabia.model.AirArabiaGdsAccount;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.server.gds.airarabia.ibus.AirArabiaWsMethod;
import com.gridnine.xtrip.server.gds.airarabia.ibus.IBusGdsAirArabiaContextKeys;
import com.gridnine.xtrip.server.gds.airarabia.mapping.ConverterUtils;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import org.opentravel.ota.AAOTAAirBaggageDetailsRQ;
import org.opentravel.ota.FlightSegmentType;
import org.opentravel.ota.OTAAirAvailRS;

public class AirBaggageDetailsRQBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        AAOTAAirBaggageDetailsRQ req = this.buildRequest(ctx);
        ctx.putObject((Enum)IBusGdsAirArabiaContextKeys.AIRARABIA_WS_REQUEST_PAYLOAD, (Object)req);
        ctx.putObject((Enum)IBusGdsAirArabiaContextKeys.AIRARABIA_WS_REQUEST_ACTION, (Object)AirArabiaWsMethod.GetBaggageDetails);
    }

    private AAOTAAirBaggageDetailsRQ buildRequest(MessageContext ctx) {
        OTAAirAvailRS.OriginDestinationInformation info = (OTAAirAvailRS.OriginDestinationInformation)ctx.getMandatoryObject((Enum)IBusGdsAirArabiaContextKeys.ORIGIN_DESTINATION);
        String transactionId = (String)ctx.getMandatoryObject((Enum)IBusGdsAirArabiaContextKeys.TRANSACTION_ID);
        EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        AAOTAAirBaggageDetailsRQ req = new AAOTAAirBaggageDetailsRQ();
        req.setOTAPayloadStdAttributes(ConverterUtils.createPayloadAttrs(transactionId));
        req.setPOS(ConverterUtils.buildPos(((AirArabiaGdsAccount)accountCtr.getEntity()).getAccount()));
        for (OTAAirAvailRS.OriginDestinationInformation.OriginDestinationOption opt : info.getOriginDestinationOptionList()) {
            for (OTAAirAvailRS.OriginDestinationInformation.OriginDestinationOption.FlightSegment segment : opt.getFlightSegmentList()) {
                AAOTAAirBaggageDetailsRQ.BaggageDetailsRequest bag = new AAOTAAirBaggageDetailsRQ.BaggageDetailsRequest();
                FlightSegmentType bagSegment = new FlightSegmentType();
                bagSegment.setDepartureDateTime(segment.getDepartureDateTime());
                bagSegment.setArrivalDateTime(segment.getArrivalDateTime());
                bagSegment.setFlightNumber(segment.getFlightNumber());
                bagSegment.setRPH(segment.getRPH());
                bagSegment.setDepartureAirport(segment.getDepartureAirport());
                bagSegment.setArrivalAirport(segment.getArrivalAirport());
                bagSegment.setOperatingAirline(ConverterUtils.createOperatingAirline());
                bag.setFlightSegmentInfo(bagSegment);
                req.getBaggageDetailsRequestList().add(bag);
            }
        }
        return req;
    }
}

