/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.airarabia.ibus.searchFlights;

import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.standard.helpers.NamedValueHelper;
import com.gridnine.xtrip.server.gds.airarabia.ibus.AirArabiaHelper;
import com.gridnine.xtrip.server.gds.airarabia.ibus.IBusGdsAirArabiaContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.opentravel.ota.AAOTAAirBaggageDetailsRS;
import org.opentravel.ota.Baggage;

public class AirBaggageDetailsRSProcessor
extends BaseProcessor {
    private static final int DEF_BAGGAGE = 0;

    public void process(MessageContext ctx) throws Exception {
        AAOTAAirBaggageDetailsRS response = (AAOTAAirBaggageDetailsRS)ctx.getMandatoryObject((Enum)IBusGdsAirArabiaContextKeys.AIRARABIA_WS_RESPONSE_PAYLOAD);
        AirArabiaHelper.checkWsResponse(response.getErrors());
        ctx.putObject((Enum)IBusGdsAirArabiaContextKeys.AIRARABIA_WS_RESPONSE_PAYLOAD, null);
        Set<String> appCodes = this.findONDBaggageCodes(response);
        if (appCodes.size() == 0) {
            throw Xeption.forDeveloper((String)"No particular baggage for a whole OND.", (Object[])new Object[0]);
        }
        String code = this.findAppropriateBaggage(response, appCodes);
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsAirArabiaContextKeys.FLIGHT);
        NamedValueHelper.setValueForName((String)"baggageWeight", (String)code, (Collection)flight.getCustomProperties());
        AirArabiaHelper.setPropBaggageSegments(flight, Collections.singletonList(response));
    }

    private Set<String> findONDBaggageCodes(AAOTAAirBaggageDetailsRS response) {
        HashMap<String, Integer> cnt = new HashMap<String, Integer>();
        for (AAOTAAirBaggageDetailsRS.BaggageDetailsResponses.OnDBaggageDetailsResponse baggages : response.getBaggageDetailsResponses().getOnDBaggageDetailsResponseList()) {
            for (Baggage baggage : baggages.getBaggageList()) {
                if (!cnt.containsKey(baggage.getBaggageCode())) {
                    cnt.put(baggage.getBaggageCode(), 0);
                }
                cnt.put(baggage.getBaggageCode(), (Integer)cnt.get(baggage.getBaggageCode()) + 1);
            }
        }
        HashSet<String> res = new HashSet<String>();
        for (Map.Entry entry : cnt.entrySet()) {
            if (((Integer)entry.getValue()).intValue() != response.getBaggageDetailsResponses().getOnDBaggageDetailsResponseList().size()) continue;
            res.add((String)entry.getKey());
        }
        return res;
    }

    private String findAppropriateBaggage(AAOTAAirBaggageDetailsRS response, Set<String> appCodes) {
        int w;
        double cost;
        String resCode = null;
        int weight = -1;
        for (String code : appCodes) {
            cost = 0.0;
            for (AAOTAAirBaggageDetailsRS.BaggageDetailsResponses.OnDBaggageDetailsResponse baggages : response.getBaggageDetailsResponses().getOnDBaggageDetailsResponseList()) {
                for (Baggage baggage : baggages.getBaggageList()) {
                    if (!baggage.getBaggageCode().equals(code)) continue;
                    cost += baggage.getBaggageCharge().doubleValue();
                }
            }
            w = AirArabiaHelper.parseBaggageWeightFromCode(code);
            if (cost != 0.0 || weight >= w) continue;
            resCode = code;
            weight = w;
        }
        if (weight < 0) {
            for (String code : appCodes) {
                cost = 0.0;
                for (AAOTAAirBaggageDetailsRS.BaggageDetailsResponses.OnDBaggageDetailsResponse baggages : response.getBaggageDetailsResponses().getOnDBaggageDetailsResponseList()) {
                    for (Baggage baggage : baggages.getBaggageList()) {
                        if (!baggage.getBaggageCode().equals(code)) continue;
                        cost += baggage.getBaggageCharge().doubleValue();
                    }
                }
                w = AirArabiaHelper.parseBaggageWeightFromCode(code);
                if (cost == 0.0 || Math.abs(0 - weight) <= Math.abs(0 - w)) continue;
                resCode = code;
                weight = w;
            }
        }
        return resCode;
    }
}

