/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.airarabia.ibus.searchFlights;

import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSearchParameters;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import com.gridnine.xtrip.common.gds.model.RouteSegment;
import com.gridnine.xtrip.common.gds.model.RouteType;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.standard.helpers.NamedValueHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.Pair;
import com.gridnine.xtrip.server.gds.airarabia.ibus.AirArabiaHelper;
import com.gridnine.xtrip.server.gds.airarabia.ibus.IBusGdsAirArabiaContextKeys;
import com.gridnine.xtrip.server.gds.airarabia.mapping.ConverterUtils;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opentravel.ota.CabinType;
import org.opentravel.ota.OTAAirAvailRS;

public class FlightBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        FlightSearchParameters fsp = (FlightSearchParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_PARAMETERS);
        OTAAirAvailRS.OriginDestinationInformation info = (OTAAirAvailRS.OriginDestinationInformation)ctx.getMandatoryObject((Enum)IBusGdsAirArabiaContextKeys.ORIGIN_DESTINATION);
        String transactionId = (String)ctx.getMandatoryObject((Enum)IBusGdsAirArabiaContextKeys.TRANSACTION_ID);
        String jsessionId = (String)ctx.getMandatoryObject((Enum)IBusGdsAirArabiaContextKeys.JSESSIONID);
        Map routeParams = (Map)ctx.getObject((Enum)IBusGdsContextKeys.SEARCH_FLIGHTS_AIRPORTS);
        ctx.putObject((Enum)IBusGdsAirArabiaContextKeys.FLIGHT, (Object)this.buildFlight(info, fsp, transactionId, jsessionId, routeParams));
    }

    private Flight buildFlight(OTAAirAvailRS.OriginDestinationInformation info, FlightSearchParameters fsp, String transactionId, String jsessionId, Map<RouteSegment, Pair<String>> routeParams) throws Exception {
        DictionaryReference<Airline> carrier = AirArabiaHelper.resolveNativeCode(Airline.class, this.getCarrier(info));
        Flight flight = new Flight();
        flight.getSeats().addAll(fsp.getSeats());
        CabinType cabinType = null;
        if (fsp.getServiceClass() != null) {
            NamedValueHelper.setValueForName((String)"cabin", (String)fsp.getServiceClass().name(), (Collection)flight.getCustomProperties());
            cabinType = ConverterUtils.convertClassOfService(fsp.getServiceClass());
        }
        RouteType routeType = GDSHelper.getRouteType((List)fsp.getRoute());
        NamedValueHelper.setValueForName((String)"routeType", (String)routeType.name(), (Collection)flight.getCustomProperties());
        flight.setEticket(true);
        flight.setGds(GdsName.AIR_ARABIA);
        flight.setLatinRegistration(true);
        flight.setCarrier(carrier);
        flight.setFlightFaresSearchDisabled(false);
        NamedValueHelper.setValueForName((String)"transactionId", (String)transactionId, (Collection)flight.getCustomProperties());
        NamedValueHelper.setValueForName((String)"jsessionId", (String)jsessionId, (Collection)flight.getCustomProperties());
        Iterator routeIt = fsp.getRoute().iterator();
        RouteSegment curLeg = (RouteSegment)routeIt.next();
        FlightSegmentTariff segTariff = new FlightSegmentTariff();
        for (OTAAirAvailRS.OriginDestinationInformation.OriginDestinationOption option : info.getOriginDestinationOptionList()) {
            for (OTAAirAvailRS.OriginDestinationInformation.OriginDestinationOption.FlightSegment flightSegment : option.getFlightSegmentList()) {
                FlightSegment seg = new FlightSegment();
                seg.setGds(GdsName.AIR_ARABIA);
                seg.setAirline(carrier);
                seg.setOperatingAirline(carrier);
                if (cabinType != null) {
                    seg.setBookingClass(cabinType.name());
                }
                seg.setFlightNumber(flightSegment.getFlightNumber().substring(2));
                seg.setLocationBegin(AirArabiaHelper.resolveNativeCode(GeoLocation.class, flightSegment.getDepartureAirport().getLocationCode()));
                seg.setLocationEnd(AirArabiaHelper.resolveNativeCode(GeoLocation.class, flightSegment.getArrivalAirport().getLocationCode()));
                seg.setDateBegin(ConverterUtils.parseDateTime(flightSegment.getDepartureDateTime()));
                seg.setDateEnd(ConverterUtils.parseDateTime(flightSegment.getArrivalDateTime()));
                boolean starting = this.isSameGeoLocations((DictionaryReference<GeoLocation>)seg.getLocationBegin(), (DictionaryReference<GeoLocation>)curLeg.getLocationBegin());
                if (starting && routeIt.hasNext()) {
                    curLeg = (RouteSegment)routeIt.next();
                }
                seg.setStarting(starting);
                seg.setTravelDuration(ConverterUtils.parseTravelDuration(flightSegment.getJourneyDuration()));
                NamedValueHelper.setValueForName((String)"segmentRPH", (String)flightSegment.getRPH(), (Collection)seg.getCustomProperties());
                NamedValueHelper.setValueForName((String)"depAirportCode", (String)flightSegment.getDepartureAirport().getLocationCode(), (Collection)seg.getCustomProperties());
                NamedValueHelper.setValueForName((String)"arrAirportCode", (String)flightSegment.getArrivalAirport().getLocationCode(), (Collection)seg.getCustomProperties());
                segTariff.getSegments().add(seg);
            }
        }
        flight.getSegmentTariffs().add(segTariff);
        return flight;
    }

    private boolean isSameGeoLocations(DictionaryReference<GeoLocation> location1, DictionaryReference<GeoLocation> location2) {
        if (MiscUtil.equals(location1, location2)) {
            return true;
        }
        GeoLocation city1 = DictHelper.findCity(location1);
        GeoLocation city2 = DictHelper.findCity(location2);
        return MiscUtil.equals((Object)city1, (Object)city2, (boolean)false);
    }

    private String getCarrier(OTAAirAvailRS.OriginDestinationInformation info) {
        return (String)CollectionUtil.single((Collection)info.getOriginDestinationOptionList().stream().flatMap(option -> option.getFlightSegmentList().stream()).map(flightSegment -> flightSegment.getFlightNumber().substring(0, 2)).collect(Collectors.toSet()));
    }
}

