/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.airarabia.ibus.searchFlights;

import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.FareInfo;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightFare;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import com.gridnine.xtrip.common.gds.model.FlightTax;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.air.LuggageInfo;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.standard.helpers.NamedValueHelper;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.server.gds.airarabia.ibus.AirArabiaHelper;
import com.gridnine.xtrip.server.gds.airarabia.ibus.IBusGdsAirArabiaContextKeys;
import com.gridnine.xtrip.server.gds.airarabia.mapping.ConverterUtils;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;
import org.opentravel.ota.BookFlightSegmentType;
import org.opentravel.ota.OriginDestinationOptionType;
import org.opentravel.ota.PTCFareBreakdownType;
import org.opentravel.ota.PricedItineraryType;

public class FlightPriceBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) {
        PricedItineraryType pricedItin = (PricedItineraryType)ctx.getMandatoryObject((Enum)IBusGdsAirArabiaContextKeys.FLIGHT_PRICE);
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsAirArabiaContextKeys.FLIGHT);
        this.buildFlightPrice(pricedItin, flight);
        this.updateFlightRPHs(pricedItin, flight);
    }

    private void updateFlightRPHs(PricedItineraryType info, Flight flight) {
        for (OriginDestinationOptionType option : info.getAirItinerary().getOriginDestinationOptionsOriginDestinationOptionList()) {
            for (BookFlightSegmentType bookSegment : option.getFlightSegmentList()) {
                for (FlightSegmentTariff tariff : flight.getSegmentTariffs()) {
                    for (FlightSegment flightSegment : tariff.getSegments()) {
                        if (!flightSegment.getFlightNumber().equals(bookSegment.getFlightNumber())) continue;
                        NamedValueHelper.setValueForName((String)"segmentRPH", (String)bookSegment.getRPH(), (Collection)flightSegment.getCustomProperties());
                    }
                }
            }
        }
    }

    private void buildFlightPrice(PricedItineraryType info, Flight flight) {
        flight.setGdsCurrencyCode(info.getAirItineraryPricingInfo().getItinTotalFare().getTotalFare().getCurrencyCodeGroup().getCurrencyCode());
        flight.getFares().clear();
        flight.getTaxes().clear();
        for (FlightSegment fs : FlightHelper.getSegments((Flight)flight)) {
            fs.getFareInfos().clear();
        }
        HashSet<DictionaryReference<PassengerType>> passengerTypes = new HashSet<DictionaryReference<PassengerType>>();
        LuggageInfo luggageInfo = AirArabiaHelper.getLuggageInfo(flight);
        LuggageInfo emptyLuggageInfo = AirArabiaHelper.getLuggageInfoByCode(null);
        for (PTCFareBreakdownType fareInfo : info.getAirItineraryPricingInfo().getPTCFareBreakdowns1().getPTCFareBreakdownList()) {
            DictionaryReference<PassengerType> passengerType = ConverterUtils.parsePassengerType(fareInfo.getPassengerTypeQuantity().getCode());
            if (passengerTypes.contains(passengerType)) continue;
            passengerTypes.add(passengerType);
            LuggageInfo passengerLuggageInfo = AirArabiaHelper.withBaggage(passengerType) ? luggageInfo : emptyLuggageInfo;
            FlightFare flightFare = this.createFlightFare(fareInfo, passengerType, (FlightSegmentTariff)flight.getSegmentTariffs().get(0));
            flight.getFares().add(flightFare);
            FareInfo finfo = new FareInfo();
            finfo.setRemarksSearchContext("need-for-site");
            finfo.setPassengerType(passengerType);
            finfo.setLuggageInfo(passengerLuggageInfo);
            if (fareInfo.getFareBasisCodeList().size() == 1) {
                finfo.setFareBasis(this.getFareBasis(fareInfo, passengerLuggageInfo));
            }
            for (FlightSegmentTariff fst : flight.getSegmentTariffs()) {
                for (FlightSegment fs : fst.getSegments()) {
                    fs.getFareInfos().add(finfo);
                }
            }
            flight.getTaxes().add(FlightPriceBuilder.createFlightTax(fareInfo, passengerType, (FlightSegmentTariff)flight.getSegmentTariffs().get(0)));
        }
        NamedValueHelper.setValueForName((String)"totalFare", (String)String.valueOf(info.getAirItineraryPricingInfo().getItinTotalFare().getTotalFare().getAmount().doubleValue()), (Collection)flight.getCustomProperties());
        NamedValueHelper.setValueForName((String)"totalFareCurrency", (String)info.getAirItineraryPricingInfo().getItinTotalFare().getTotalFare().getCurrencyCodeGroup().getCurrencyCode(), (Collection)flight.getCustomProperties());
    }

    private String getFareBasis(PTCFareBreakdownType fareInfo, LuggageInfo luggageInfo) {
        String result = (String)fareInfo.getFareBasisCodeList().get(0);
        if (luggageInfo != null && luggageInfo.getQuantity() != null) {
            result = result + "/BAG" + String.valueOf(luggageInfo.getQuantity());
        }
        return result;
    }

    private static FlightTax createFlightTax(PTCFareBreakdownType fareInfo, DictionaryReference<PassengerType> passengerType, FlightSegmentTariff fst) {
        FlightTax tax = new FlightTax();
        tax.setPassengerType(passengerType);
        tax.setSegmentTariff(fst);
        tax.setCode("XT");
        Money amount = new Money();
        BigDecimal value = fareInfo.getPassengerFare().getTotalFare().getAmount().subtract(fareInfo.getPassengerFare().getBaseFareCurrencyAmountGroup().getAmount());
        amount.setValue(value);
        amount.setCurrency(fareInfo.getPassengerFare().getBaseFareCurrencyAmountGroup().getCurrencyCodeGroup().getCurrencyCode());
        tax.setBaseAmount(amount);
        tax.setEquivalentAmount(value);
        return tax;
    }

    private FlightFare createFlightFare(PTCFareBreakdownType fareInfo, DictionaryReference<PassengerType> passengerType, FlightSegmentTariff fst) {
        FlightFare fare = new FlightFare();
        fare.setPassengerType(passengerType);
        fare.setSegmentTariff(fst);
        Money amount = new Money();
        BigDecimal amountValue = fareInfo.getPassengerFare().getBaseFareCurrencyAmountGroup().getAmount();
        amount.setValue(amountValue);
        amount.setCurrency(fareInfo.getPassengerFare().getBaseFareCurrencyAmountGroup().getCurrencyCodeGroup().getCurrencyCode());
        fare.setBaseAmount(amount);
        fare.setEquivalentAmount(amountValue);
        return fare;
    }
}

