/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.airarabia.ibus.searchFlights;

import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.standard.helpers.NamedValueHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.airarabia.ibus.IBusGdsAirArabiaContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opentravel.ota.AAOTAAirAllPriceAvailRS;
import org.opentravel.ota.BookFlightSegmentType;
import org.opentravel.ota.OriginDestinationOptionType;
import org.opentravel.ota.PricedItinerariesType;
import org.opentravel.ota.PricedItineraryType;

public class GetFlightPriceProcessor
extends BaseProcessor {
    private static final String SEGMENT_SEPARATOR = "->";

    public void process(MessageContext ctx) throws Exception {
        AAOTAAirAllPriceAvailRS response = (AAOTAAirAllPriceAvailRS)ctx.getObject((Enum)IBusGdsAirArabiaContextKeys.AIRAVAIL_RS);
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsAirArabiaContextKeys.FLIGHT);
        ctx.putObject((Enum)IBusGdsAirArabiaContextKeys.FLIGHT_PRICE, (Object)this.getPricedItineraries(flight, response.getAAAirAvailRSExt1()));
    }

    private PricedItineraryType getPricedItineraries(Flight flight, AAOTAAirAllPriceAvailRS.AAAirAvailRSExt airAvailRSExt) {
        for (PricedItinerariesType pricedItineraries : airAvailRSExt.getPricedItineraryList()) {
            PricedItineraryType pricedItin = this.getFlightPriceItin(pricedItineraries, flight);
            if (!Objects.nonNull(pricedItin)) continue;
            return pricedItin;
        }
        throw Xeption.forDeveloper((String)"can't find need pricedItineraries in response of flight {0}", (Object[])new Object[]{FlightHelper.getFlightTitle((Flight)flight)});
    }

    private PricedItineraryType getFlightPriceItin(PricedItinerariesType pricedItineraries, Flight flight) {
        String flightToken = this.buildToken(flight);
        for (PricedItineraryType pricedItinerary : pricedItineraries.getPricedItineraryList()) {
            String pricedItinToken = this.buildToken(pricedItinerary);
            if (!MiscUtil.equals((Object)flightToken, (Object)pricedItinToken)) continue;
            return pricedItinerary;
        }
        return null;
    }

    private String buildToken(Flight flight) {
        return FlightHelper.getSegments((Flight)flight).stream().map(seg -> NamedValueHelper.getValueForName((String)"segmentRPH", (Collection)seg.getCustomProperties())).collect(Collectors.joining(SEGMENT_SEPARATOR));
    }

    private String buildToken(PricedItineraryType pricedItineraryType) {
        StringBuilder sb = new StringBuilder();
        for (OriginDestinationOptionType option : pricedItineraryType.getAirItinerary().getOriginDestinationOptionsOriginDestinationOptionList()) {
            for (BookFlightSegmentType bookSeg : option.getFlightSegmentList()) {
                if (sb.length() > 0) {
                    sb.append(SEGMENT_SEPARATOR);
                }
                sb.append(bookSeg.getRPH());
            }
        }
        return sb.toString();
    }
}

