/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.airarabia.ibus.ticketReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.helper.PccHelper;
import com.gridnine.xtrip.common.gds.model.GDSParameters;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.server.gds.airarabia.ibus.AirArabiaHelper;
import com.gridnine.xtrip.server.gds.airarabia.ibus.IBusGdsAirArabiaContextKeys;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.jibxws.WsParts;
import java.math.BigDecimal;
import org.opentravel.ota.CompanyIDAttributesGroup;
import org.opentravel.ota.CompanyNameType;
import org.opentravel.ota.CurrencyAmountGroup;
import org.opentravel.ota.DirectBillType;
import org.opentravel.ota.OTAAirBookRQ;
import org.opentravel.ota.PaymentDetailType;
import org.opentravel.ota.PricedItineraryType;

public class AddPaymentInformationProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        WsParts parts = (WsParts)ctx.getMandatoryObject((Enum)IBusGdsAirArabiaContextKeys.AIRARABIA_WS_REQUEST_PAYLOAD);
        GDSParameters params = (GDSParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.GDS_PARAMETERS);
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        PricedItineraryType pricedItin = (PricedItineraryType)ctx.getMandatoryObject((Enum)IBusGdsAirArabiaContextKeys.FLIGHT_PRICE);
        OTAAirBookRQ request = (OTAAirBookRQ)parts.gerFirst();
        OTAAirBookRQ.Fulfillment fulfilment = new OTAAirBookRQ.Fulfillment();
        fulfilment.setPaymentDetails(new OTAAirBookRQ.Fulfillment.PaymentDetails());
        PaymentDetailType payment = new PaymentDetailType();
        payment.setDirectBill(new DirectBillType());
        payment.getDirectBill().setCompanyName(new DirectBillType.CompanyName());
        payment.getDirectBill().getCompanyName().setCompanyNameType(new CompanyNameType());
        payment.getDirectBill().getCompanyName().getCompanyNameType().setCompanyIDAttributesGroup(new CompanyIDAttributesGroup());
        payment.getDirectBill().getCompanyName().getCompanyNameType().setString("");
        payment.getDirectBill().getCompanyName().getCompanyNameType().getCompanyIDAttributesGroup().setCode(PccHelper.getTicketingPccCode((GDSParameters)params));
        if (AirArabiaHelper.isBspBlankOwner(reservation, params)) {
            payment.getDirectBill().getCompanyName().getCompanyNameType().getCompanyIDAttributesGroup().setCodeContext("BSP");
        }
        payment.setPaymentAmount(new PaymentDetailType.PaymentAmount());
        payment.getPaymentAmount().setCurrencyAmountGroup(new CurrencyAmountGroup());
        BigDecimal calcSum = AirArabiaHelper.calcReservationBalance(reservation);
        payment.getPaymentAmount().getCurrencyAmountGroup().setAmount(calcSum);
        payment.getPaymentAmount().getCurrencyAmountGroup().setCurrencyCodeGroup(pricedItin.getAirItineraryPricingInfo().getItinTotalFare().getTotalFare().getCurrencyCodeGroup());
        fulfilment.getPaymentDetails().getPaymentDetailList().add(payment);
        request.setFulfillment(fulfilment);
    }
}

