/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.airarabia.ibus.ticketReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.server.gds.airarabia.ibus.IBusGdsAirArabiaContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseRoutingKeyProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;

public class IsSuitableFlightProvider
extends BaseRoutingKeyProvider {
    public String getRoutingKey(MessageContext ctx) throws Exception {
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsAirArabiaContextKeys.FLIGHT);
        Reservation res = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        Product p = (Product)res.getProducts().get(0);
        boolean suitableFlight = this.isSuitableFlight(flight, p);
        ctx.putObject((Enum)IBusGdsAirArabiaContextKeys.SUITABLE_FLIGHT_FOUND, (Object)suitableFlight);
        return Boolean.toString(suitableFlight);
    }

    private boolean isSuitableFlight(Flight flight, Product p) {
        if (flight.getSegmentTariffs().size() != p.getSegmentTariffs().size()) {
            return false;
        }
        for (int q = 0; q < flight.getSegmentTariffs().size(); ++q) {
            if (this.segmentsTariffEquals((FlightSegmentTariff)flight.getSegmentTariffs().get(q), (SegmentTariff)p.getSegmentTariffs().get(q))) continue;
            return false;
        }
        return true;
    }

    private boolean segmentsTariffEquals(FlightSegmentTariff fst, SegmentTariff st) {
        int size = fst.getSegments().size();
        if (size != st.getSegments().size()) {
            return false;
        }
        for (int q = 0; q < size; ++q) {
            FlightSegment seg1 = (FlightSegment)fst.getSegments().get(q);
            Segment seg2 = (Segment)st.getSegments().get(q);
            if (seg1.getDateBegin().equals(seg2.getStartDate()) && seg1.getDateEnd().equals(seg2.getEndDate()) && seg1.getLocationBegin().equals((Object)seg2.getDepartureLocation()) && seg1.getLocationEnd().equals((Object)seg2.getArriveLocation()) && seg1.getFlightNumber().equals(seg2.getFlightNo())) continue;
            return false;
        }
        return true;
    }
}

