/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.airarabia.ibus.ticketReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.airarabia.model.AirArabiaGdsAccount;
import com.gridnine.xtrip.common.gds.helper.PccHelper;
import com.gridnine.xtrip.common.gds.model.GDSParameters;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.server.gds.airarabia.ibus.AirArabiaHelper;
import com.gridnine.xtrip.server.gds.airarabia.ibus.AirArabiaWsMethod;
import com.gridnine.xtrip.server.gds.airarabia.ibus.IBusGdsAirArabiaContextKeys;
import com.gridnine.xtrip.server.gds.airarabia.mapping.ConverterUtils;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.jibxws.WsParts;
import com.isaaviation.thinair.webservices.ota.extensions.AAAirBookModifyRQExt;
import com.isaaviation.thinair.webservices.ota.extensions.AALoadDataOptionsType;
import java.math.BigDecimal;
import org.opentravel.ota.AirReservationType;
import org.opentravel.ota.CompanyIDAttributesGroup;
import org.opentravel.ota.CompanyNameType;
import org.opentravel.ota.CurrencyAmountGroup;
import org.opentravel.ota.DirectBillType;
import org.opentravel.ota.OTAAirBookModifyRQ;
import org.opentravel.ota.PaymentDetailType;
import org.opentravel.ota.UniqueIDGroup;
import org.opentravel.ota.UniqueIDType;

public class ProcessPaymentRQBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        WsParts parts = new WsParts();
        parts.getParts().add(this.buildRequest(ctx));
        parts.getParts().add(this.buildExt());
        ctx.putObject((Enum)IBusGdsAirArabiaContextKeys.AIRARABIA_WS_REQUEST_PAYLOAD, (Object)parts);
        ctx.putObject((Enum)IBusGdsAirArabiaContextKeys.AIRARABIA_WS_REQUEST_ACTION, (Object)AirArabiaWsMethod.ModifyReservation);
    }

    private OTAAirBookModifyRQ buildRequest(MessageContext ctx) {
        EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        GDSParameters params = (GDSParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.GDS_PARAMETERS);
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        AirReservationType res = (AirReservationType)ctx.getMandatoryObject((Enum)IBusGdsAirArabiaContextKeys.AIR_RESERVATION);
        OTAAirBookModifyRQ req = new OTAAirBookModifyRQ();
        req.setAirBookModifyRQAirReservationType(new AirReservationType());
        req.setAirBookModifyRQModificationType("9");
        req.setPOS(ConverterUtils.buildPos(((AirArabiaGdsAccount)accountCtr.getEntity()).getAccount()));
        req.setOTAPayloadStdAttributes(ConverterUtils.createPayloadAttrs((String)ctx.getMandatoryObject((Enum)IBusGdsAirArabiaContextKeys.TRANSACTION_ID)));
        UniqueIDType bookingId = new UniqueIDType();
        bookingId.setUniqueIDGroup(new UniqueIDGroup());
        bookingId.getUniqueIDGroup().setID(AirArabiaHelper.getRecordLocator(reservation));
        bookingId.getUniqueIDGroup().setType("14");
        req.getAirBookModifyRQAirReservationType().getBookingReferenceIDList().add(bookingId);
        AirReservationType.Fulfillment fulfilment = new AirReservationType.Fulfillment();
        fulfilment.setPaymentDetails(new AirReservationType.Fulfillment.PaymentDetails());
        PaymentDetailType payment = new PaymentDetailType();
        payment.setDirectBill(new DirectBillType());
        payment.getDirectBill().setCompanyName(new DirectBillType.CompanyName());
        payment.getDirectBill().getCompanyName().setCompanyNameType(new CompanyNameType());
        payment.getDirectBill().getCompanyName().getCompanyNameType().setCompanyIDAttributesGroup(new CompanyIDAttributesGroup());
        payment.getDirectBill().getCompanyName().getCompanyNameType().setString("");
        payment.getDirectBill().getCompanyName().getCompanyNameType().getCompanyIDAttributesGroup().setCode(PccHelper.getTicketingPccCode((GDSParameters)params));
        if (AirArabiaHelper.isBspBlankOwner(reservation, params)) {
            payment.getDirectBill().getCompanyName().getCompanyNameType().getCompanyIDAttributesGroup().setCodeContext("BSP");
        }
        payment.setPaymentAmount(new PaymentDetailType.PaymentAmount());
        payment.getPaymentAmount().setCurrencyAmountGroup(new CurrencyAmountGroup());
        BigDecimal calcSum = AirArabiaHelper.calcReservationBalance(reservation);
        BigDecimal sum = res.getPriceInfo().getItinTotalFare().getTotalFare().getAmount();
        if (!calcSum.equals(sum)) {
            throw Xeption.forDeveloper((String)"Incorrect total sum. Calc sum in reservation - {0}, sum in AirArabia reservation - {1}", (Object[])new Object[]{calcSum, sum});
        }
        payment.getPaymentAmount().getCurrencyAmountGroup().setAmount(sum);
        payment.getPaymentAmount().getCurrencyAmountGroup().setCurrencyCodeGroup(res.getPriceInfo().getItinTotalFare().getTotalFare().getCurrencyCodeGroup());
        fulfilment.getPaymentDetails().getPaymentDetailList().add(payment);
        req.getAirBookModifyRQAirReservationType().setFulfillment(fulfilment);
        return req;
    }

    private AAAirBookModifyRQExt buildExt() {
        AAAirBookModifyRQExt ext = new AAAirBookModifyRQExt();
        ext.setAALoadDataOptions(new AALoadDataOptionsType());
        ext.getAALoadDataOptions().setLoadTravelerInfo(Boolean.TRUE);
        ext.getAALoadDataOptions().setLoadAirItinery(Boolean.TRUE);
        ext.getAALoadDataOptions().setLoadPriceInfoTotals(Boolean.TRUE);
        ext.getAALoadDataOptions().setLoadFullFilment(Boolean.TRUE);
        return ext;
    }
}

