/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.airarabia.ibus.ticketReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.FlightSearchParameters;
import com.gridnine.xtrip.common.gds.model.RouteSegment;
import com.gridnine.xtrip.common.gds.model.SeatPreferences;
import com.gridnine.xtrip.common.midoffice.helper.CodeTranslator;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.Pair;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class SearchParametersFromReservationBuilder
extends BaseProcessor {
    private final CodeTranslator codeTranslator = new CodeTranslator(new String[]{CodeSystem.IATA.name()});

    public void process(MessageContext ctx) throws Exception {
        Reservation res = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        ctx.putObject((Enum)IBusMidofficeContextKeys.CUSTOMER, (Object)res.getBookingFile().getCustomer());
        FlightSearchParameters fsp = new FlightSearchParameters();
        Product p = (Product)res.getProducts().get(0);
        RouteSegment route = null;
        for (Segment seg : AirProductHelper.getSegments((Collection)p.getSegmentTariffs())) {
            if (route == null || seg.isStarting()) {
                route = new RouteSegment();
                route.setLocationBegin(seg.getDepartureLocation());
                route.setDate(MiscUtil.clearTime((Date)seg.getStartDate()));
                fsp.getRoute().add(route);
            }
            route.setLocationEnd(seg.getArriveLocation());
        }
        int[] cnt = new int[3];
        for (BaseProduct bp : res.getProducts()) {
            if (!(bp instanceof Product)) continue;
            DictionaryReference passType = ((Product)bp).getPassengerType();
            if (DictHelper.isAdultPassengerType((DictionaryReference)passType)) {
                cnt[0] = cnt[0] + 1;
                continue;
            }
            if (DictHelper.isChildPassengerType((DictionaryReference)passType)) {
                cnt[1] = cnt[1] + 1;
                continue;
            }
            if (!DictHelper.isInfantPassengerType((DictionaryReference)passType)) continue;
            cnt[2] = cnt[2] + 1;
        }
        if (cnt[0] > 0) {
            fsp.getSeats().add(this.createSeat((DictionaryReference<PassengerType>)DictHelper.getAdultPassengerType(), cnt[0]));
        }
        if (cnt[1] > 0) {
            fsp.getSeats().add(this.createSeat((DictionaryReference<PassengerType>)DictHelper.getChildPassengerType(), cnt[1]));
        }
        if (cnt[2] > 0) {
            fsp.getSeats().add(this.createSeat((DictionaryReference<PassengerType>)DictHelper.getInfantPassengerType(), cnt[2]));
        }
        ctx.putObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_PARAMETERS, (Object)fsp);
        ctx.putObject((Enum)IBusGdsContextKeys.SEARCH_FLIGHTS_AIRPORTS, this.getRouteParams(fsp));
    }

    private Map<RouteSegment, Pair<String>> getRouteParams(FlightSearchParameters fsp) {
        HashMap<RouteSegment, Pair<String>> result = new HashMap<RouteSegment, Pair<String>>();
        for (RouteSegment routeSegment : fsp.getRoute()) {
            result.put(routeSegment, (Pair<String>)new Pair((Object)this.codeTranslator.getNativeCode(routeSegment.getLocationBegin()), (Object)this.codeTranslator.getNativeCode(routeSegment.getLocationEnd())));
        }
        return result;
    }

    private SeatPreferences createSeat(DictionaryReference<PassengerType> type, int cnt) {
        SeatPreferences seat = new SeatPreferences();
        seat.setPassengerType(type);
        seat.setCount(cnt);
        return seat;
    }
}

