/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.airarabia.mapping;

import com.gridnine.xtrip.common.gds.model.BaseGDSEntity;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import com.gridnine.xtrip.common.gds.model.RouteType;
import com.gridnine.xtrip.common.gds.model.SeatPreferences;
import com.gridnine.xtrip.common.midoffice.helper.CodeTranslator;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.dict.ClassOfService;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.Gender;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.standard.helpers.NamedValueHelper;
import com.gridnine.xtrip.common.model.system.NamedValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.opentravel.ota.AirItineraryType;
import org.opentravel.ota.AirTripType;
import org.opentravel.ota.AirportLocationGroup;
import org.opentravel.ota.BookFlightSegmentType;
import org.opentravel.ota.BookingChannelGroup;
import org.opentravel.ota.CabinType;
import org.opentravel.ota.CompanyIDAttributesGroup;
import org.opentravel.ota.CompanyNameType;
import org.opentravel.ota.LocationGroup;
import org.opentravel.ota.LocationType;
import org.opentravel.ota.OTAPayloadStdAttributes;
import org.opentravel.ota.OperatingAirlineType;
import org.opentravel.ota.OriginDestinationOptionType;
import org.opentravel.ota.POSType;
import org.opentravel.ota.PassengerTypeQuantityType;
import org.opentravel.ota.SourceType;
import org.opentravel.ota.TimeInstantType;
import org.opentravel.ota.TravelerInfoSummaryType;
import org.opentravel.ota.TravelerInformationType;
import org.opentravel.ota.UniqueIDGroup;

public class ConverterUtils {
    private static final String DATETIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    public static final String CARRIER_CODE = "G9";
    private static final String SEARCH_WINDOW_FORMAT = "P{0}D";
    private static final DateTimeFormatter DTF = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss");
    private static final CodeTranslator AIR_ARABIA_CODE_TRANSLATOR = new CodeTranslator(new String[]{CodeSystem.AIR_ARABIA.name()});

    public static CabinType convertClassOfService(ClassOfService classOfService) {
        if (classOfService == null) {
            return null;
        }
        if (classOfService.equals((Object)ClassOfService.ECONOMY)) {
            return CabinType.Y;
        }
        if (classOfService.equals((Object)ClassOfService.BUSINESS)) {
            return CabinType.C;
        }
        if (classOfService.equals((Object)ClassOfService.FIRST)) {
            return CabinType.F;
        }
        if (classOfService.equals((Object)ClassOfService.PREMIUM)) {
            return CabinType.J;
        }
        return null;
    }

    public static String getTitle(Gender gender, DictionaryReference<PassengerType> passType) {
        if (gender == null) {
            return "";
        }
        if (DictHelper.isAdultPassengerType(passType)) {
            return gender.equals((Object)Gender.FEMALE) ? "MS" : "MR";
        }
        return gender.equals((Object)Gender.FEMALE) ? "MISS" : "MSTR";
    }

    public static Date parseDateTime(String s) {
        return DTF.parseLocalDateTime(s).toDate();
    }

    public static String dateTimeToStr(Date dt) {
        return DTF.print((ReadablePartial)LocalDateTime.fromDateFields((Date)dt));
    }

    public static AirItineraryType createAirItineraryType(Flight flight, RouteType routeType) {
        AirItineraryType airIt = new AirItineraryType();
        if (routeType != null) {
            if (RouteType.ONEWAY.equals((Object)routeType)) {
                airIt.setDirectionInd(AirTripType.ONE_WAY);
            } else if (RouteType.ROUNDTRIP.equals((Object)routeType)) {
                airIt.setDirectionInd(AirTripType.RETURN);
            } else {
                airIt.setDirectionInd(AirTripType.OTHER);
            }
        }
        String carrierCode = flight.getCarrier().getCode();
        for (FlightSegmentTariff tariff : flight.getSegmentTariffs()) {
            for (FlightSegment fs : tariff.getSegments()) {
                OriginDestinationOptionType opType = new OriginDestinationOptionType();
                BookFlightSegmentType bfs = new BookFlightSegmentType();
                bfs.setArrivalDateTime(ConverterUtils.dateTimeToStr(fs.getDateEnd()));
                bfs.setDepartureDateTime(ConverterUtils.dateTimeToStr(fs.getDateBegin()));
                bfs.setFlightNumber(carrierCode + fs.getFlightNumber());
                bfs.setRPH(ConverterUtils.getCustomProperty((BaseGDSEntity)fs, "segmentRPH"));
                bfs.setDepartureAirport(ConverterUtils.createAirport(ConverterUtils.getCustomProperty((BaseGDSEntity)fs, "depAirportCode")));
                bfs.setArrivalAirport(ConverterUtils.createAirport(ConverterUtils.getCustomProperty((BaseGDSEntity)fs, "arrAirportCode")));
                String cabinStr = NamedValueHelper.getValueForName((String)"cabin", (Collection)flight.getCustomProperties());
                if (cabinStr != null) {
                    CabinType cabin = ConverterUtils.convertClassOfService(ClassOfService.valueOf((String)cabinStr));
                    bfs.setResCabinClass(cabin.name());
                }
                opType.getFlightSegmentList().add(bfs);
                airIt.getOriginDestinationOptionsOriginDestinationOptionList().add(opType);
            }
        }
        return airIt;
    }

    public static String getCustomProperty(BaseGDSEntity gdsEnt, String key) {
        for (NamedValue prop : gdsEnt.getCustomProperties()) {
            if (!key.equals(prop.getName())) continue;
            return prop.getValue();
        }
        return null;
    }

    public static AirportLocationGroup createAirport(String code) {
        AirportLocationGroup res = new AirportLocationGroup();
        res.setLocationCode(code);
        return res;
    }

    public static OperatingAirlineType createOperatingAirline() {
        OperatingAirlineType res = new OperatingAirlineType();
        res.setCompanyNameType(ConverterUtils.buildCompanyNameType(CARRIER_CODE));
        return res;
    }

    public static CompanyNameType buildCompanyNameType(String airlineCode) {
        CompanyNameType result = new CompanyNameType();
        result.setCompanyIDAttributesGroup(new CompanyIDAttributesGroup());
        result.getCompanyIDAttributesGroup().setCode(airlineCode);
        result.setString("");
        return result;
    }

    public static int parseTravelDuration(String s) {
        int hours = s.contains("H") ? Integer.parseInt(s.substring(2, s.indexOf("H"))) : 0;
        int minutes = Integer.parseInt(s.substring(s.contains("H") ? s.indexOf("H") + 1 : 2, s.indexOf("M")));
        return hours * 60 + minutes;
    }

    public static TravelerInfoSummaryType createTravelersInfo(List<SeatPreferences> seats) {
        TravelerInfoSummaryType trInfos = new TravelerInfoSummaryType();
        TravelerInformationType trInfo = new TravelerInformationType();
        for (SeatPreferences seat : seats) {
            PassengerTypeQuantityType pq = new PassengerTypeQuantityType();
            pq.setCode(ConverterUtils.getPassengerTypeCode((DictionaryReference<PassengerType>)seat.getPassengerType()));
            pq.setQuantity(BigInteger.valueOf(seat.getCount()));
            trInfo.getPassengerTypeQuantityList().add(pq);
        }
        trInfos.getAirTravelerAvailList().add(trInfo);
        return trInfos;
    }

    public static TimeInstantType createTimeStamp(Date dt, int windowBefore, int windowAfter) {
        TimeInstantType res = new TimeInstantType();
        SimpleDateFormat df = new SimpleDateFormat(DATETIME_FORMAT);
        res.setString(df.format(dt));
        if (windowBefore > 0) {
            res.setWindowBefore(MessageFormat.format(SEARCH_WINDOW_FORMAT, windowBefore));
        }
        if (windowAfter > 0) {
            res.setWindowAfter(MessageFormat.format(SEARCH_WINDOW_FORMAT, windowAfter));
        }
        return res;
    }

    public static LocationType createLocation(String loc) {
        LocationType res = new LocationType();
        LocationGroup locGroup = new LocationGroup();
        locGroup.setLocationCode(loc);
        res.setLocationGroup(locGroup);
        res.setString("");
        return res;
    }

    public static String getPassengerTypeCode(DictionaryReference<PassengerType> passType) {
        return AIR_ARABIA_CODE_TRANSLATOR.getNativeCode(passType);
    }

    public static String getTravelerRPH(DictionaryReference<PassengerType> passType, int index) {
        if (DictHelper.isAdultPassengerType(passType)) {
            return "A" + index;
        }
        if (DictHelper.isChildPassengerType(passType)) {
            return "C" + index;
        }
        return null;
    }

    public static DictionaryReference<PassengerType> parsePassengerType(String code) {
        return AIR_ARABIA_CODE_TRANSLATOR.resolveNativeCode(PassengerType.class, code);
    }

    public static POSType buildPos(String username) {
        POSType pos = new POSType();
        SourceType source = new SourceType();
        source.setTerminalID("TestUser/Test Runner");
        SourceType.RequestorID reqId = new SourceType.RequestorID();
        reqId.setUniqueIDGroup(new UniqueIDGroup());
        reqId.getUniqueIDGroup().setID(username);
        reqId.getUniqueIDGroup().setType("4");
        source.setRequestorID(reqId);
        BookingChannelGroup bcg = new BookingChannelGroup();
        bcg.setType("12");
        source.setBookingChannel(new SourceType.BookingChannel());
        source.getBookingChannel().setBookingChannelGroup(bcg);
        pos.getSourceList().add(source);
        return pos;
    }

    public static OTAPayloadStdAttributes createPayloadAttrs(String transactionId) {
        OTAPayloadStdAttributes attrs = new OTAPayloadStdAttributes();
        attrs.setVersion(new BigDecimal(20061.0));
        attrs.setPrimaryLangID("en-us");
        attrs.setSequenceNmbr(BigInteger.valueOf(1L));
        if (transactionId != null) {
            attrs.setTransactionIdentifier(transactionId);
        }
        return attrs;
    }
}

