
package com.isaaviation.thinair.webservices.ota.extensions;

/** 
 * Reservation admin information.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.isaaviation.com/thinair/webservices/OTA/Extensions/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AAAdminInfoType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="OwnerChannelID" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="OwnerAgentCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="OriginChannelID" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="OriginAgentCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="OriginSalesTerminal" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="LastSalesTerminal" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AAAdminInfoType
{
    private String ownerChannelID;
    private String ownerAgentCode;
    private String originChannelID;
    private String originAgentCode;
    private String originSalesTerminal;
    private String lastSalesTerminal;

    /** 
     * Get the 'OwnerChannelID' element value. Sales Channel of which
    					the booking is owned by.
    				
     * 
     * @return value
     */
    public String getOwnerChannelID() {
        return ownerChannelID;
    }

    /** 
     * Set the 'OwnerChannelID' element value. Sales Channel of which
    					the booking is owned by.
    				
     * 
     * @param ownerChannelID
     */
    public void setOwnerChannelID(String ownerChannelID) {
        this.ownerChannelID = ownerChannelID;
    }

    /** 
     * Get the 'OwnerAgentCode' element value. Agent which the booking is owned by.
    				
     * 
     * @return value
     */
    public String getOwnerAgentCode() {
        return ownerAgentCode;
    }

    /** 
     * Set the 'OwnerAgentCode' element value. Agent which the booking is owned by.
    				
     * 
     * @param ownerAgentCode
     */
    public void setOwnerAgentCode(String ownerAgentCode) {
        this.ownerAgentCode = ownerAgentCode;
    }

    /** 
     * Get the 'OriginChannelID' element value. Sales Channel of which the booking is originated
    					from.
    				
     * 
     * @return value
     */
    public String getOriginChannelID() {
        return originChannelID;
    }

    /** 
     * Set the 'OriginChannelID' element value. Sales Channel of which the booking is originated
    					from.
    				
     * 
     * @param originChannelID
     */
    public void setOriginChannelID(String originChannelID) {
        this.originChannelID = originChannelID;
    }

    /** 
     * Get the 'OriginAgentCode' element value. Agent which the booking is originated from
    				
     * 
     * @return value
     */
    public String getOriginAgentCode() {
        return originAgentCode;
    }

    /** 
     * Set the 'OriginAgentCode' element value. Agent which the booking is originated from
    				
     * 
     * @param originAgentCode
     */
    public void setOriginAgentCode(String originAgentCode) {
        this.originAgentCode = originAgentCode;
    }

    /** 
     * Get the 'OriginSalesTerminal' element value. Sales Terminal which the booking is originated
    					from
    				
     * 
     * @return value
     */
    public String getOriginSalesTerminal() {
        return originSalesTerminal;
    }

    /** 
     * Set the 'OriginSalesTerminal' element value. Sales Terminal which the booking is originated
    					from
    				
     * 
     * @param originSalesTerminal
     */
    public void setOriginSalesTerminal(String originSalesTerminal) {
        this.originSalesTerminal = originSalesTerminal;
    }

    /** 
     * Get the 'LastSalesTerminal' element value. Sales Terminal which the last booking
    					modification is originated from
    				
     * 
     * @return value
     */
    public String getLastSalesTerminal() {
        return lastSalesTerminal;
    }

    /** 
     * Set the 'LastSalesTerminal' element value. Sales Terminal which the last booking
    					modification is originated from
    				
     * 
     * @param lastSalesTerminal
     */
    public void setLastSalesTerminal(String lastSalesTerminal) {
        this.lastSalesTerminal = lastSalesTerminal;
    }
}
