
package com.isaaviation.thinair.webservices.ota.extensions;

/** 
 * AccelAero Extensions for
 OTA AirReservationType, which is included as TPA_Extension

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.isaaviation.com/thinair/webservices/OTA/Extensions/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AAAirReservationExt">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element type="ns:AAResAccSummaryType" name="ResAccountSummary" minOccurs="0"/>
 *       &lt;xs:element type="ns:AAUserNotesType" name="UserNotes" minOccurs="0"/>
 *       &lt;xs:element type="ns:AAContactInfoType" name="ContactInfo" minOccurs="0"/>
 *       &lt;xs:element type="ns:AAAlterationBalancesType" name="AlterationBalances" minOccurs="0"/>
 *       &lt;xs:element type="ns:AAExternalPayTxType" name="CurrentExtPayTxInfo" minOccurs="0"/>
 *       &lt;xs:element type="ns:AAAdminInfoType" name="AdminInfo" minOccurs="0"/>
 *       &lt;xs:element type="ns:AAResSummaryType" name="ResSummary" minOccurs="0"/>
 *       &lt;xs:element type="ns:AATravelerInfoType" name="TravelerAdditionalInfo" minOccurs="0"/>
 *     &lt;/xs:sequence>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class AAAirReservationExt
{
    private AAResAccSummaryType resAccountSummary;
    private AAUserNotesType userNotes;
    private AAContactInfoType contactInfo;
    private AAAlterationBalancesType alterationBalances;
    private AAExternalPayTxType currentExtPayTxInfo;
    private AAAdminInfoType adminInfo;
    private AAResSummaryType resSummary;
    private AATravelerInfoType travelerAdditionalInfo;

    /** 
     * Get the 'ResAccountSummary' element value. Reservation Account
    						Summary (total payments, total balances and total credits)
    					
     * 
     * @return value
     */
    public AAResAccSummaryType getResAccountSummary() {
        return resAccountSummary;
    }

    /** 
     * Set the 'ResAccountSummary' element value. Reservation Account
    						Summary (total payments, total balances and total credits)
    					
     * 
     * @param resAccountSummary
     */
    public void setResAccountSummary(AAResAccSummaryType resAccountSummary) {
        this.resAccountSummary = resAccountSummary;
    }

    /** 
     * Get the 'UserNotes' element value. Free Text Notes
    					
     * 
     * @return value
     */
    public AAUserNotesType getUserNotes() {
        return userNotes;
    }

    /** 
     * Set the 'UserNotes' element value. Free Text Notes
    					
     * 
     * @param userNotes
     */
    public void setUserNotes(AAUserNotesType userNotes) {
        this.userNotes = userNotes;
    }

    /** 
     * Get the 'ContactInfo' element value. Reservation contact
    						information
    					
     * 
     * @return value
     */
    public AAContactInfoType getContactInfo() {
        return contactInfo;
    }

    /** 
     * Set the 'ContactInfo' element value. Reservation contact
    						information
    					
     * 
     * @param contactInfo
     */
    public void setContactInfo(AAContactInfoType contactInfo) {
        this.contactInfo = contactInfo;
    }

    /** 
     * Get the 'AlterationBalances' element value. Balance amounts in
    						doing reservation modifications
    					
     * 
     * @return value
     */
    public AAAlterationBalancesType getAlterationBalances() {
        return alterationBalances;
    }

    /** 
     * Set the 'AlterationBalances' element value. Balance amounts in
    						doing reservation modifications
    					
     * 
     * @param alterationBalances
     */
    public void setAlterationBalances(
            AAAlterationBalancesType alterationBalances) {
        this.alterationBalances = alterationBalances;
    }

    /** 
     * Get the 'CurrentExtPayTxInfo' element value. External Payment
    						Transaction Information.
    					
     * 
     * @return value
     */
    public AAExternalPayTxType getCurrentExtPayTxInfo() {
        return currentExtPayTxInfo;
    }

    /** 
     * Set the 'CurrentExtPayTxInfo' element value. External Payment
    						Transaction Information.
    					
     * 
     * @param currentExtPayTxInfo
     */
    public void setCurrentExtPayTxInfo(AAExternalPayTxType currentExtPayTxInfo) {
        this.currentExtPayTxInfo = currentExtPayTxInfo;
    }

    /** 
     * Get the 'AdminInfo' element value. reservation Admin
    						Information.
    					
     * 
     * @return value
     */
    public AAAdminInfoType getAdminInfo() {
        return adminInfo;
    }

    /** 
     * Set the 'AdminInfo' element value. reservation Admin
    						Information.
    					
     * 
     * @param adminInfo
     */
    public void setAdminInfo(AAAdminInfoType adminInfo) {
        this.adminInfo = adminInfo;
    }

    /** 
     * Get the 'ResSummary' element value. Reservation Summary.
    					
     * 
     * @return value
     */
    public AAResSummaryType getResSummary() {
        return resSummary;
    }

    /** 
     * Set the 'ResSummary' element value. Reservation Summary.
    					
     * 
     * @param resSummary
     */
    public void setResSummary(AAResSummaryType resSummary) {
        this.resSummary = resSummary;
    }

    /** 
     * Get the 'TravelerAdditionalInfo' element value. Travellers Additional
    						Information
    					
     * 
     * @return value
     */
    public AATravelerInfoType getTravelerAdditionalInfo() {
        return travelerAdditionalInfo;
    }

    /** 
     * Set the 'TravelerAdditionalInfo' element value. Travellers Additional
    						Information
    					
     * 
     * @param travelerAdditionalInfo
     */
    public void setTravelerAdditionalInfo(
            AATravelerInfoType travelerAdditionalInfo) {
        this.travelerAdditionalInfo = travelerAdditionalInfo;
    }
}
