
package com.isaaviation.thinair.webservices.ota.extensions;

/** 
 * Balance amounts when
 performing reservation modifications. Used in cancel segment, cancel
 reservation, add segment, modify segment, add infant and remove pax
 processes to show balance amounts. New balances (except OND
 balances) are formed with respect to the overall reservation.

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.isaaviation.com/thinair/webservices/OTA/Extensions/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AAAlterationBalancesType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="AAModONDBalances" minOccurs="0">
 *       &lt;!-- Reference to inner class AAModONDBalances -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:AACnxModAddONDBalancesType" name="AACnxONDBalances" minOccurs="0"/>
 *     &lt;xs:element type="ns:AACnxModAddONDBalancesType" name="AAAddONDBalances" minOccurs="0"/>
 *     &lt;xs:element type="ns:AATravelersCnxModAddResBalancesType" name="TravelersCnxModAddResBalances" minOccurs="0"/>
 *     &lt;xs:element type="ns:AACurrencyAmountType" name="TotalModChargeForCurrentOperation" minOccurs="0"/>
 *     &lt;xs:element type="ns:AACurrencyAmountType" name="TotalCnxChargeForCurrentOperation" minOccurs="0"/>
 *     &lt;xs:element type="ns:AACurrencyAmountType" name="TotalCreditAmount"/>
 *     &lt;xs:element type="ns:AACurrencyAmountType" name="TotalAmountDue"/>
 *     &lt;xs:element type="ns:AACurrencyAmountType" name="TotalAmountDueCC"/>
 *     &lt;xs:element type="ns:AACurrencyAmountType" name="TotalPrice"/>
 *     &lt;xs:element type="ns:AACurrencyAmountType" name="TotalPriceCC"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AAAlterationBalancesType
{
    private AAModONDBalances AAModONDBalances1;
    private AACnxModAddONDBalancesType AACnxONDBalances;
    private AACnxModAddONDBalancesType AAAddONDBalances;
    private AATravelersCnxModAddResBalancesType travelersCnxModAddResBalances;
    private AACurrencyAmountType totalModChargeForCurrentOperation;
    private AACurrencyAmountType totalCnxChargeForCurrentOperation;
    private AACurrencyAmountType totalCreditAmount;
    private AACurrencyAmountType totalAmountDue;
    private AACurrencyAmountType totalAmountDueCC;
    private AACurrencyAmountType totalPrice;
    private AACurrencyAmountType totalPriceCC;

    /** 
     * Get the 'AAModONDBalances' element value.
     * 
     * @return value
     */
    public AAModONDBalances getAAModONDBalances1() {
        return AAModONDBalances1;
    }

    /** 
     * Set the 'AAModONDBalances' element value.
     * 
     * @param AAModONDBalances1
     */
    public void setAAModONDBalances1(AAModONDBalances AAModONDBalances1) {
        this.AAModONDBalances1 = AAModONDBalances1;
    }

    /** 
     * Get the 'AACnxONDBalances' element value. Balances for OND being
    					cancelled.
    				
     * 
     * @return value
     */
    public AACnxModAddONDBalancesType getAACnxONDBalances() {
        return AACnxONDBalances;
    }

    /** 
     * Set the 'AACnxONDBalances' element value. Balances for OND being
    					cancelled.
    				
     * 
     * @param AACnxONDBalances
     */
    public void setAACnxONDBalances(AACnxModAddONDBalancesType AACnxONDBalances) {
        this.AACnxONDBalances = AACnxONDBalances;
    }

    /** 
     * Get the 'AAAddONDBalances' element value. Balances for OND being
    					added.
    				
     * 
     * @return value
     */
    public AACnxModAddONDBalancesType getAAAddONDBalances() {
        return AAAddONDBalances;
    }

    /** 
     * Set the 'AAAddONDBalances' element value. Balances for OND being
    					added.
    				
     * 
     * @param AAAddONDBalances
     */
    public void setAAAddONDBalances(AACnxModAddONDBalancesType AAAddONDBalances) {
        this.AAAddONDBalances = AAAddONDBalances;
    }

    /** 
     * Get the 'TravelersCnxModAddResBalances' element value. Traveler balances with
    					respect to the resevation, after modificatin/cancelation.
    				
     * 
     * @return value
     */
    public AATravelersCnxModAddResBalancesType getTravelersCnxModAddResBalances() {
        return travelersCnxModAddResBalances;
    }

    /** 
     * Set the 'TravelersCnxModAddResBalances' element value. Traveler balances with
    					respect to the resevation, after modificatin/cancelation.
    				
     * 
     * @param travelersCnxModAddResBalances
     */
    public void setTravelersCnxModAddResBalances(
            AATravelersCnxModAddResBalancesType travelersCnxModAddResBalances) {
        this.travelersCnxModAddResBalances = travelersCnxModAddResBalances;
    }

    /** 
     * Get the 'TotalModChargeForCurrentOperation' element value. Per traveler per OND
    					modification charge
    				
     * 
     * @return value
     */
    public AACurrencyAmountType getTotalModChargeForCurrentOperation() {
        return totalModChargeForCurrentOperation;
    }

    /** 
     * Set the 'TotalModChargeForCurrentOperation' element value. Per traveler per OND
    					modification charge
    				
     * 
     * @param totalModChargeForCurrentOperation
     */
    public void setTotalModChargeForCurrentOperation(
            AACurrencyAmountType totalModChargeForCurrentOperation) {
        this.totalModChargeForCurrentOperation = totalModChargeForCurrentOperation;
    }

    /** 
     * Get the 'TotalCnxChargeForCurrentOperation' element value. Per traveler per OND
    					cancellation charge
    				
     * 
     * @return value
     */
    public AACurrencyAmountType getTotalCnxChargeForCurrentOperation() {
        return totalCnxChargeForCurrentOperation;
    }

    /** 
     * Set the 'TotalCnxChargeForCurrentOperation' element value. Per traveler per OND
    					cancellation charge
    				
     * 
     * @param totalCnxChargeForCurrentOperation
     */
    public void setTotalCnxChargeForCurrentOperation(
            AACurrencyAmountType totalCnxChargeForCurrentOperation) {
        this.totalCnxChargeForCurrentOperation = totalCnxChargeForCurrentOperation;
    }

    /** 
     * Get the 'TotalCreditAmount' element value. Total credit amount for
    					the reservation after modification/cancellation.
    				
     * 
     * @return value
     */
    public AACurrencyAmountType getTotalCreditAmount() {
        return totalCreditAmount;
    }

    /** 
     * Set the 'TotalCreditAmount' element value. Total credit amount for
    					the reservation after modification/cancellation.
    				
     * 
     * @param totalCreditAmount
     */
    public void setTotalCreditAmount(AACurrencyAmountType totalCreditAmount) {
        this.totalCreditAmount = totalCreditAmount;
    }

    /** 
     * Get the 'TotalAmountDue' element value. Total amount due for
    					the resevation after modificaiton/cancellation.
    				
     * 
     * @return value
     */
    public AACurrencyAmountType getTotalAmountDue() {
        return totalAmountDue;
    }

    /** 
     * Set the 'TotalAmountDue' element value. Total amount due for
    					the resevation after modificaiton/cancellation.
    				
     * 
     * @param totalAmountDue
     */
    public void setTotalAmountDue(AACurrencyAmountType totalAmountDue) {
        this.totalAmountDue = totalAmountDue;
    }

    /** 
     * Get the 'TotalAmountDueCC' element value. Total amount due for
    					the resevation after modificaiton/cancellation.
    				
     * 
     * @return value
     */
    public AACurrencyAmountType getTotalAmountDueCC() {
        return totalAmountDueCC;
    }

    /** 
     * Set the 'TotalAmountDueCC' element value. Total amount due for
    					the resevation after modificaiton/cancellation.
    				
     * 
     * @param totalAmountDueCC
     */
    public void setTotalAmountDueCC(AACurrencyAmountType totalAmountDueCC) {
        this.totalAmountDueCC = totalAmountDueCC;
    }

    /** 
     * Get the 'TotalPrice' element value. Total amount due for
    					the resevation after modificaiton/cancellation.
    				
     * 
     * @return value
     */
    public AACurrencyAmountType getTotalPrice() {
        return totalPrice;
    }

    /** 
     * Set the 'TotalPrice' element value. Total amount due for
    					the resevation after modificaiton/cancellation.
    				
     * 
     * @param totalPrice
     */
    public void setTotalPrice(AACurrencyAmountType totalPrice) {
        this.totalPrice = totalPrice;
    }

    /** 
     * Get the 'TotalPriceCC' element value. Total amount due for
    					the resevation after modificaiton/cancellation.
    				
     * 
     * @return value
     */
    public AACurrencyAmountType getTotalPriceCC() {
        return totalPriceCC;
    }

    /** 
     * Set the 'TotalPriceCC' element value. Total amount due for
    					the resevation after modificaiton/cancellation.
    				
     * 
     * @param totalPriceCC
     */
    public void setTotalPriceCC(AACurrencyAmountType totalPriceCC) {
        this.totalPriceCC = totalPriceCC;
    }
    /** 
     * Balances for OND being
    					modified.
    				
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.isaaviation.com/thinair/webservices/OTA/Extensions/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AAModONDBalances" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:AACnxModAddONDBalancesType" name="UpdatingONDCharges"/>
     *       &lt;xs:element type="ns:AACnxModAddONDBalancesType" name="NewONDCharges"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class AAModONDBalances
    {
        private AACnxModAddONDBalancesType updatingONDCharges;
        private AACnxModAddONDBalancesType newONDCharges;

        /** 
         * Get the 'UpdatingONDCharges' element value.
         * 
         * @return value
         */
        public AACnxModAddONDBalancesType getUpdatingONDCharges() {
            return updatingONDCharges;
        }

        /** 
         * Set the 'UpdatingONDCharges' element value.
         * 
         * @param updatingONDCharges
         */
        public void setUpdatingONDCharges(
                AACnxModAddONDBalancesType updatingONDCharges) {
            this.updatingONDCharges = updatingONDCharges;
        }

        /** 
         * Get the 'NewONDCharges' element value.
         * 
         * @return value
         */
        public AACnxModAddONDBalancesType getNewONDCharges() {
            return newONDCharges;
        }

        /** 
         * Set the 'NewONDCharges' element value.
         * 
         * @param newONDCharges
         */
        public void setNewONDCharges(AACnxModAddONDBalancesType newONDCharges) {
            this.newONDCharges = newONDCharges;
        }
    }
}
