
package com.isaaviation.thinair.webservices.ota.extensions;

/** 
 * Reservation contact information.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.isaaviation.com/thinair/webservices/OTA/Extensions/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AAContactInfoType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="ProfileRef" minOccurs="0"/>
 *     &lt;xs:element type="ns:AAPersonNameType" name="PersonName"/>
 *     &lt;xs:element type="ns:AATelephoneType" name="Telephone" minOccurs="0"/>
 *     &lt;xs:element type="ns:AATelephoneType" name="Mobile" minOccurs="0"/>
 *     &lt;xs:element type="ns:AATelephoneType" name="Fax" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Email" minOccurs="0"/>
 *     &lt;xs:element type="ns:AAAddressType" name="Address" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="PreferredLanguage" minOccurs="0"/>
 *     &lt;xs:element type="ns:AAEmergencyContactType" name="EmergencyContact" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AAContactInfoType
{
    private String profileRef;
    private AAPersonNameType personName;
    private AATelephoneType telephone;
    private AATelephoneType mobile;
    private AATelephoneType fax;
    private String email;
    private AAAddressType address;
    private String preferredLanguage;
    private AAEmergencyContactType emergencyContact;

    /** 
     * Get the 'ProfileRef' element value.  An identifier used to
    					uniquely reference a customer profile.
    				
     * 
     * @return value
     */
    public String getProfileRef() {
        return profileRef;
    }

    /** 
     * Set the 'ProfileRef' element value.  An identifier used to
    					uniquely reference a customer profile.
    				
     * 
     * @param profileRef
     */
    public void setProfileRef(String profileRef) {
        this.profileRef = profileRef;
    }

    /** 
     * Get the 'PersonName' element value.  Person Name
    					information of the contact person.
    				
     * 
     * @return value
     */
    public AAPersonNameType getPersonName() {
        return personName;
    }

    /** 
     * Set the 'PersonName' element value.  Person Name
    					information of the contact person.
    				
     * 
     * @param personName
     */
    public void setPersonName(AAPersonNameType personName) {
        this.personName = personName;
    }

    /** 
     * Get the 'Telephone' element value. Mobile number for the
    					contact person.
    				
     * 
     * @return value
     */
    public AATelephoneType getTelephone() {
        return telephone;
    }

    /** 
     * Set the 'Telephone' element value. Mobile number for the
    					contact person.
    				
     * 
     * @param telephone
     */
    public void setTelephone(AATelephoneType telephone) {
        this.telephone = telephone;
    }

    /** 
     * Get the 'Mobile' element value. Mobile number for the
    					contact person.
    				
     * 
     * @return value
     */
    public AATelephoneType getMobile() {
        return mobile;
    }

    /** 
     * Set the 'Mobile' element value. Mobile number for the
    					contact person.
    				
     * 
     * @param mobile
     */
    public void setMobile(AATelephoneType mobile) {
        this.mobile = mobile;
    }

    /** 
     * Get the 'Fax' element value. Fax number for the
    					contact person.
    				
     * 
     * @return value
     */
    public AATelephoneType getFax() {
        return fax;
    }

    /** 
     * Set the 'Fax' element value. Fax number for the
    					contact person.
    				
     * 
     * @param fax
     */
    public void setFax(AATelephoneType fax) {
        this.fax = fax;
    }

    /** 
     * Get the 'Email' element value.  Email address of the
    					contact person.
    				
     * 
     * @return value
     */
    public String getEmail() {
        return email;
    }

    /** 
     * Set the 'Email' element value.  Email address of the
    					contact person.
    				
     * 
     * @param email
     */
    public void setEmail(String email) {
        this.email = email;
    }

    /** 
     * Get the 'Address' element value.  Address information of
    					the contact person.
    				
     * 
     * @return value
     */
    public AAAddressType getAddress() {
        return address;
    }

    /** 
     * Set the 'Address' element value.  Address information of
    					the contact person.
    				
     * 
     * @param address
     */
    public void setAddress(AAAddressType address) {
        this.address = address;
    }

    /** 
     * Get the 'PreferredLanguage' element value. Preferred language of
    					the contact person
    				
     * 
     * @return value
     */
    public String getPreferredLanguage() {
        return preferredLanguage;
    }

    /** 
     * Set the 'PreferredLanguage' element value. Preferred language of
    					the contact person
    				
     * 
     * @param preferredLanguage
     */
    public void setPreferredLanguage(String preferredLanguage) {
        this.preferredLanguage = preferredLanguage;
    }

    /** 
     * Get the 'EmergencyContact' element value. Emergency Contact
    					Information
    				
     * 
     * @return value
     */
    public AAEmergencyContactType getEmergencyContact() {
        return emergencyContact;
    }

    /** 
     * Set the 'EmergencyContact' element value. Emergency Contact
    					Information
    				
     * 
     * @param emergencyContact
     */
    public void setEmergencyContact(AAEmergencyContactType emergencyContact) {
        this.emergencyContact = emergencyContact;
    }
}
