
package com.isaaviation.thinair.webservices.ota.extensions;

/** 
 * Reservation Account
 Summary (payments, balances and credits)

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.isaaviation.com/thinair/webservices/OTA/Extensions/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AAResAccSummaryType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:AACurrencyAmountType" name="TotalPrice"/>
 *     &lt;xs:element type="ns:AACurrencyAmountType" name="TotalPaidAmount"/>
 *     &lt;xs:element type="ns:AACurrencyAmountType" name="TotalBalanceDue"/>
 *     &lt;xs:element type="ns:AACurrencyAmountType" name="TotalCreditAvailable"/>
 *     &lt;xs:element type="ns:AATravelersAccSummaryType" name="TravelersAccSummary" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AAResAccSummaryType
{
    private AACurrencyAmountType totalPrice;
    private AACurrencyAmountType totalPaidAmount;
    private AACurrencyAmountType totalBalanceDue;
    private AACurrencyAmountType totalCreditAvailable;
    private AATravelersAccSummaryType travelersAccSummary;

    /** 
     * Get the 'TotalPrice' element value. Total Price of the
    					Reservation.
    				
     * 
     * @return value
     */
    public AACurrencyAmountType getTotalPrice() {
        return totalPrice;
    }

    /** 
     * Set the 'TotalPrice' element value. Total Price of the
    					Reservation.
    				
     * 
     * @param totalPrice
     */
    public void setTotalPrice(AACurrencyAmountType totalPrice) {
        this.totalPrice = totalPrice;
    }

    /** 
     * Get the 'TotalPaidAmount' element value. Total Payment Done for
    					the Reservation.
    				
     * 
     * @return value
     */
    public AACurrencyAmountType getTotalPaidAmount() {
        return totalPaidAmount;
    }

    /** 
     * Set the 'TotalPaidAmount' element value. Total Payment Done for
    					the Reservation.
    				
     * 
     * @param totalPaidAmount
     */
    public void setTotalPaidAmount(AACurrencyAmountType totalPaidAmount) {
        this.totalPaidAmount = totalPaidAmount;
    }

    /** 
     * Get the 'TotalBalanceDue' element value. Total Amount Due for
    					the Reservation.
    				
     * 
     * @return value
     */
    public AACurrencyAmountType getTotalBalanceDue() {
        return totalBalanceDue;
    }

    /** 
     * Set the 'TotalBalanceDue' element value. Total Amount Due for
    					the Reservation.
    				
     * 
     * @param totalBalanceDue
     */
    public void setTotalBalanceDue(AACurrencyAmountType totalBalanceDue) {
        this.totalBalanceDue = totalBalanceDue;
    }

    /** 
     * Get the 'TotalCreditAvailable' element value. Total Credit Available
    					in the Reservation
    				
     * 
     * @return value
     */
    public AACurrencyAmountType getTotalCreditAvailable() {
        return totalCreditAvailable;
    }

    /** 
     * Set the 'TotalCreditAvailable' element value. Total Credit Available
    					in the Reservation
    				
     * 
     * @param totalCreditAvailable
     */
    public void setTotalCreditAvailable(
            AACurrencyAmountType totalCreditAvailable) {
        this.totalCreditAvailable = totalCreditAvailable;
    }

    /** 
     * Get the 'TravelersAccSummary' element value. Traveler(PAX) wise
    					Account Summary
    				
     * 
     * @return value
     */
    public AATravelersAccSummaryType getTravelersAccSummary() {
        return travelersAccSummary;
    }

    /** 
     * Set the 'TravelersAccSummary' element value. Traveler(PAX) wise
    					Account Summary
    				
     * 
     * @param travelersAccSummary
     */
    public void setTravelersAccSummary(
            AATravelersAccSummaryType travelersAccSummary) {
        this.travelersAccSummary = travelersAccSummary;
    }
}
