
package org.oasisopen.docs.wss.oasis200401wsswssecuritysecext1;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

/** 
 * This complexType defines header block to use for security-relevant data directed at a specific SOAP actor.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SecurityHeaderType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:UsernameTokenType" name="UsernameToken"/>
 *     &lt;xs:any minOccurs="0" maxOccurs="unbounded" processContents="lax"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:anyAttribute processContents="lax" namespace="##other"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SecurityHeaderType
{
    private UsernameTokenType usernameToken;
    private List<Element> anyList = new ArrayList<Element>();

    /** 
     * Get the 'UsernameToken' element value.
     * 
     * @return value
     */
    public UsernameTokenType getUsernameToken() {
        return usernameToken;
    }

    /** 
     * Set the 'UsernameToken' element value.
     * 
     * @param usernameToken
     */
    public void setUsernameToken(UsernameTokenType usernameToken) {
        this.usernameToken = usernameToken;
    }

    /** 
     * Get the list of any items. The use of "any" is to allow extensibility and different forms of security data.
     * 
     * @return list
     */
    public List<Element> getAnyList() {
        return anyList;
    }

    /** 
     * Set the list of any items. The use of "any" is to allow extensibility and different forms of security data.
     * 
     * @param list
     */
    public void setAnyList(List<Element> list) {
        anyList = list;
    }
}
