
package org.oasisopen.docs.wss.oasis200401wsswssecuritysecext1;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

/** 
 * This type represents a username token per Section 4.1
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="UsernameTokenType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:AttributedString" name="Username"/>
 *     &lt;xs:element type="ns:PasswordString" name="Password"/>
 *     &lt;xs:any minOccurs="0" maxOccurs="unbounded" processContents="lax"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:anyAttribute processContents="lax" namespace="##other"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class UsernameTokenType
{
    private AttributedString username;
    private PasswordString password;
    private List<Element> anyList = new ArrayList<Element>();

    /** 
     * Get the 'Username' element value.
     * 
     * @return value
     */
    public AttributedString getUsername() {
        return username;
    }

    /** 
     * Set the 'Username' element value.
     * 
     * @param username
     */
    public void setUsername(AttributedString username) {
        this.username = username;
    }

    /** 
     * Get the 'Password' element value.
     * 
     * @return value
     */
    public PasswordString getPassword() {
        return password;
    }

    /** 
     * Set the 'Password' element value.
     * 
     * @param password
     */
    public void setPassword(PasswordString password) {
        this.password = password;
    }

    /** 
     * Get the list of any items.
     * 
     * @return list
     */
    public List<Element> getAnyList() {
        return anyList;
    }

    /** 
     * Set the list of any items.
     * 
     * @param list
     */
    public void setAnyList(List<Element> list) {
        anyList = list;
    }
}
