
package org.opentravel.ota;

import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

/** 
 * The baggage details
 Request message requests baggage details for one or more flight
 segments for specific dates. The request can include the PNR number
 , frequent flier numbers etc. The baggage details response contains
 the actual baggage details based on the input conditions in the
 request message. Every flight segment will have a separate baggage
 detail
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AA_OTA_AirBaggageDetailsRQ">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element type="ns:POS_Type" name="POS"/>
 *       &lt;xs:element name="BaggageDetailsRequests">
 *         &lt;xs:complexType>
 *           &lt;xs:sequence>
 *             &lt;xs:element name="BaggageDetailsRequest" minOccurs="0" maxOccurs="99">
 *               &lt;!-- Reference to inner class BaggageDetailsRequest -->
 *             &lt;/xs:element>
 *           &lt;/xs:sequence>
 *         &lt;/xs:complexType>
 *       &lt;/xs:element>
 *       &lt;xs:element type="xs:string" name="PriceRequestCurrencyCode" minOccurs="0" maxOccurs="1"/>
 *       &lt;xs:element name="AirTravelers" minOccurs="0">
 *         &lt;!-- Reference to inner class AirTravelers -->
 *       &lt;/xs:element>
 *       &lt;xs:element type="ns:UniqueID_Type" name="BookingReferenceID" minOccurs="0" maxOccurs="5"/>
 *     &lt;/xs:sequence>
 *     &lt;xs:attributeGroup ref="ns:OTA_PayloadStdAttributes"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class AAOTAAirBaggageDetailsRQ
{
    private POSType POS;
    private List<BaggageDetailsRequest> baggageDetailsRequestList = new ArrayList<BaggageDetailsRequest>();
    private String priceRequestCurrencyCode;
    private AirTravelers airTravelers;
    private List<UniqueIDType> bookingReferenceIDList = new ArrayList<UniqueIDType>();
    private OTAPayloadStdAttributes OTAPayloadStdAttributes;

    /** 
     * Get the 'POS' element value. Point of sale object. 
     * 
     * @return value
     */
    public POSType getPOS() {
        return POS;
    }

    /** 
     * Set the 'POS' element value. Point of sale object. 
     * 
     * @param POS
     */
    public void setPOS(POSType POS) {
        this.POS = POS;
    }

    /** 
     * Get the list of 'BaggageDetailsRequest' element items. The baggage details
    						request element containing the details of the request.
     * 
     * @return list
     */
    public List<BaggageDetailsRequest> getBaggageDetailsRequestList() {
        return baggageDetailsRequestList;
    }

    /** 
     * Set the list of 'BaggageDetailsRequest' element items. The baggage details
    						request element containing the details of the request.
     * 
     * @param list
     */
    public void setBaggageDetailsRequestList(List<BaggageDetailsRequest> list) {
        baggageDetailsRequestList = list;
    }

    /** 
     * Get the 'PriceRequestCurrencyCode' element value.  Specifies the
    						preferred currency code for the baggage charge amounts 
     * 
     * @return value
     */
    public String getPriceRequestCurrencyCode() {
        return priceRequestCurrencyCode;
    }

    /** 
     * Set the 'PriceRequestCurrencyCode' element value.  Specifies the
    						preferred currency code for the baggage charge amounts 
     * 
     * @param priceRequestCurrencyCode
     */
    public void setPriceRequestCurrencyCode(String priceRequestCurrencyCode) {
        this.priceRequestCurrencyCode = priceRequestCurrencyCode;
    }

    /** 
     * Get the 'AirTravelers' element value.
     * 
     * @return value
     */
    public AirTravelers getAirTravelers() {
        return airTravelers;
    }

    /** 
     * Set the 'AirTravelers' element value.
     * 
     * @param airTravelers
     */
    public void setAirTravelers(AirTravelers airTravelers) {
        this.airTravelers = airTravelers;
    }

    /** 
     * Get the list of 'BookingReferenceID' element items. This is used for PNR
    						record locator. If there are more than one PNR numbers because of
    						muliple airlines in the itinerary then this element could be
    						repeated.
     * 
     * @return list
     */
    public List<UniqueIDType> getBookingReferenceIDList() {
        return bookingReferenceIDList;
    }

    /** 
     * Set the list of 'BookingReferenceID' element items. This is used for PNR
    						record locator. If there are more than one PNR numbers because of
    						muliple airlines in the itinerary then this element could be
    						repeated.
     * 
     * @param list
     */
    public void setBookingReferenceIDList(List<UniqueIDType> list) {
        bookingReferenceIDList = list;
    }

    /** 
     * Get the 'OTA_PayloadStdAttributes' attributeGroup value.
     * 
     * @return value
     */
    public OTAPayloadStdAttributes getOTAPayloadStdAttributes() {
        return OTAPayloadStdAttributes;
    }

    /** 
     * Set the 'OTA_PayloadStdAttributes' attributeGroup value.
     * 
     * @param OTAPayloadStdAttributes
     */
    public void setOTAPayloadStdAttributes(
            OTAPayloadStdAttributes OTAPayloadStdAttributes) {
        this.OTAPayloadStdAttributes = OTAPayloadStdAttributes;
    }
    /** 
     * The number of
    									flight segments for which the baggage details are requested
    									for. If an itinerary consists of multiple flight segments then
    									corresponding number of BaggageDetailsRequest elements will be
    									sent in the request. If there is a gauge change (equipment
    									change) within a flight segment an error response is expected.
    									In such a case two different baggageDetailsRequest elements
    									need to be sent requesting baggage details for two flight
    									segments for different gauges.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaggageDetailsRequest" minOccurs="0" maxOccurs="99">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:FlightSegmentType" name="FlightSegmentInfo"/>
     *       &lt;xs:element name="BaggageDetails" minOccurs="0">
     *         &lt;!-- Reference to inner class BaggageDetails -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="ns:ListOfRPH" use="optional" name="TravelerRefNumberRPHs"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * 
     * &lt;xs:simpleType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ListOfRPH">
     *   &lt;xs:list itemType="xs:string"/>
     * &lt;/xs:simpleType>
     * </pre>
     */
    public static class BaggageDetailsRequest
    {
        private FlightSegmentType flightSegmentInfo;
        private BaggageDetails baggageDetails;
        private List<String> travelerRefNumberRPHs = new ArrayList<String>();

        /** 
         * Get the 'FlightSegmentInfo' element value. Flight segment
        												information of the flight segment for which baggage
        												information is requested.
         * 
         * @return value
         */
        public FlightSegmentType getFlightSegmentInfo() {
            return flightSegmentInfo;
        }

        /** 
         * Set the 'FlightSegmentInfo' element value. Flight segment
        												information of the flight segment for which baggage
        												information is requested.
         * 
         * @param flightSegmentInfo
         */
        public void setFlightSegmentInfo(FlightSegmentType flightSegmentInfo) {
            this.flightSegmentInfo = flightSegmentInfo;
        }

        /** 
         * Get the 'BaggageDetails' element value.
         * 
         * @return value
         */
        public BaggageDetails getBaggageDetails() {
            return baggageDetails;
        }

        /** 
         * Set the 'BaggageDetails' element value.
         * 
         * @param baggageDetails
         */
        public void setBaggageDetails(BaggageDetails baggageDetails) {
            this.baggageDetails = baggageDetails;
        }

        /** 
         * Get the list of 'TravelerRefNumberRPHs' attribute items. Reference to one
        											or more travelers for whom baggage details requested for
        											this flight segment. RPH Value from TravelerRefNumber of
        											AirTravelerType element will be mapped here.
         * 
         * @return list
         */
        public List<String> getTravelerRefNumberRPHs() {
            return travelerRefNumberRPHs;
        }

        /** 
         * Set the list of 'TravelerRefNumberRPHs' attribute items. Reference to one
        											or more travelers for whom baggage details requested for
        											this flight segment. RPH Value from TravelerRefNumber of
        											AirTravelerType element will be mapped here.
         * 
         * @param list
         */
        public void setTravelerRefNumberRPHs(List<String> list) {
            travelerRefNumberRPHs = list;
        }

        /** 
         * Serializer for 'TravelerRefNumberRPHs' attribute list.
         * 
         * @param values
         * @return text
         */
        public static String serializeTravelerRefNumberRPHs(List<String> values) {
            if (values == null) {
                return null;
            } else {
                java.lang.StringBuffer buff = new java.lang.StringBuffer();
                for (java.util.Iterator<String> iter = values.iterator(); iter
                        .hasNext();) {
                    if (buff.length() > 0) {
                        buff.append(' ');
                    }
                    String value = iter.next();
                    buff.append(value);
                }
                return buff.toString();
            }
        }

        /** 
         * Deserializer for 'TravelerRefNumberRPHs' attribute list.
         * 
         * @param text
         * @return values
         * @throws org.jibx.runtime.JiBXException on conversion error
         */
        public static List<String> deserializeTravelerRefNumberRPHs(String text)
                throws org.jibx.runtime.JiBXException {
            org.jibx.runtime.IListItemDeserializer ldser = new org.jibx.runtime.IListItemDeserializer() {
                public java.lang.Object deserialize(String text)
                        throws org.jibx.runtime.JiBXException {
                    return text;
                }
            };
            return (List<String>) org.jibx.runtime.Utility.deserializeList(
                    text, ldser);
        }
        /** 
         * Object to hold
        												the baggage details that is to be requested.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaggageDetails" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="CabinClass" minOccurs="0" maxOccurs="5">
         *         &lt;xs:complexType>
         *           &lt;xs:attribute type="ns:CabinType" use="optional" name="CabinType"/>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *       &lt;xs:element name="ResBookDesignations" minOccurs="0">
         *         &lt;!-- Reference to inner class ResBookDesignations -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class BaggageDetails
        {
            private List<CabinType> cabinClassList = new ArrayList<CabinType>();
            private ResBookDesignations resBookDesignations;

            /** 
             * Get the list of 'CabinClass' element items. if the
            														baggage display is to be requested for a specific cabin
            														class , the cabin class can be specified in this
            														element.
             * 
             * @return list
             */
            public List<CabinType> getCabinClassList() {
                return cabinClassList;
            }

            /** 
             * Set the list of 'CabinClass' element items. if the
            														baggage display is to be requested for a specific cabin
            														class , the cabin class can be specified in this
            														element.
             * 
             * @param list
             */
            public void setCabinClassList(List<CabinType> list) {
                cabinClassList = list;
            }

            /** 
             * Get the 'ResBookDesignations' element value.
             * 
             * @return value
             */
            public ResBookDesignations getResBookDesignations() {
                return resBookDesignations;
            }

            /** 
             * Set the 'ResBookDesignations' element value.
             * 
             * @param resBookDesignations
             */
            public void setResBookDesignations(
                    ResBookDesignations resBookDesignations) {
                this.resBookDesignations = resBookDesignations;
            }
            /** 
             * A collection
            														of ResBookDesignations.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ResBookDesignations" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="ResBookDesignation" maxOccurs="10">
             *         &lt;!-- Reference to inner class ResBookDesignation -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class ResBookDesignations
            {
                private List<ResBookDesignation> resBookDesignationList = new ArrayList<ResBookDesignation>();

                /** 
                 * Get the list of 'ResBookDesignation' element items.
                 * 
                 * @return list
                 */
                public List<ResBookDesignation> getResBookDesignationList() {
                    return resBookDesignationList;
                }

                /** 
                 * Set the list of 'ResBookDesignation' element items.
                 * 
                 * @param list
                 */
                public void setResBookDesignationList(
                        List<ResBookDesignation> list) {
                    resBookDesignationList = list;
                }
                /** 
                 * If the
                																	baggage details display is requested for the cabin
                																	class in which a particular booking designator code
                																	(booking class) lies then that booking class can be
                																	specified in this element.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ResBookDesignation" maxOccurs="10">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="ResBookDesigCode"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class ResBookDesignation
                {
                    private String resBookDesigCode;

                    /** 
                     * Get the 'ResBookDesigCode' attribute value. If the
                    																		booking class is know for which the baggage details
                    																		are to be requested then the specific Booking class
                    																		code can be entered here. The response will have
                    																		the baggage details for the cabin class in which
                    																		the said booking classcode belongs.
                     * 
                     * @return value
                     */
                    public String getResBookDesigCode() {
                        return resBookDesigCode;
                    }

                    /** 
                     * Set the 'ResBookDesigCode' attribute value. If the
                    																		booking class is know for which the baggage details
                    																		are to be requested then the specific Booking class
                    																		code can be entered here. The response will have
                    																		the baggage details for the cabin class in which
                    																		the said booking classcode belongs.
                     * 
                     * @param resBookDesigCode
                     */
                    public void setResBookDesigCode(String resBookDesigCode) {
                        this.resBookDesigCode = resBookDesigCode;
                    }
                }
            }
        }
    }
    /** 
     * Collection of
    						AirTravelers.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirTravelers" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="AirTraveler" maxOccurs="99">
     *         &lt;!-- Reference to inner class AirTraveler -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class AirTravelers
    {
        private List<AirTraveler> airTravelerList = new ArrayList<AirTraveler>();

        /** 
         * Get the list of 'AirTraveler' element items.
         * 
         * @return list
         */
        public List<AirTraveler> getAirTravelerList() {
            return airTravelerList;
        }

        /** 
         * Set the list of 'AirTraveler' element items.
         * 
         * @param list
         */
        public void setAirTravelerList(List<AirTraveler> list) {
            airTravelerList = list;
        }
        /** 
         * This specifies the
        									quantity and types of passengers.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirTraveler" maxOccurs="99">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:PersonNameType" name="PersonName" minOccurs="0"/>
         *       &lt;xs:element name="CustLoyalty" minOccurs="0" maxOccurs="5">
         *         &lt;xs:complexType>
         *           &lt;xs:attributeGroup ref="ns:CustomerLoyaltyGroup"/>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *       &lt;xs:element type="ns:PassengerTypeQuantityType" name="PassengerTypeQuantity" minOccurs="0"/>
         *       &lt;xs:element name="TravelerRefNumber" minOccurs="0">
         *         &lt;xs:complexType>
         *           &lt;xs:attributeGroup ref="ns:TravelerRefNumberGroup"/>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attributeGroup ref="ns:GenderGroup"/>
         *     &lt;xs:attributeGroup ref="ns:PrivacyGroup"/>
         *     &lt;xs:attribute type="xs:date" name="BirthDate"/>
         *     &lt;xs:attribute type="xs:string" name="CurrencyCode"/>
         *     &lt;xs:attribute type="xs:string" use="required" name="PassengerTypeCode"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class AirTraveler
        {
            private PersonNameType personName;
            private List<CustomerLoyaltyGroup> custLoyaltyList = new ArrayList<CustomerLoyaltyGroup>();
            private PassengerTypeQuantityType passengerTypeQuantity;
            private TravelerRefNumberGroup travelerRefNumber;
            private GenderGroup genderGroup;
            private PrivacyGroup privacyGroup;
            private Date birthDate;
            private String currencyCode;
            private String passengerTypeCode;

            /** 
             * Get the 'PersonName' element value. Individuals
            											complete name information
             * 
             * @return value
             */
            public PersonNameType getPersonName() {
                return personName;
            }

            /** 
             * Set the 'PersonName' element value. Individuals
            											complete name information
             * 
             * @param personName
             */
            public void setPersonName(PersonNameType personName) {
                this.personName = personName;
            }

            /** 
             * Get the list of 'CustLoyalty' element items. Frequent Flier
            											information of the passenger
             * 
             * @return list
             */
            public List<CustomerLoyaltyGroup> getCustLoyaltyList() {
                return custLoyaltyList;
            }

            /** 
             * Set the list of 'CustLoyalty' element items. Frequent Flier
            											information of the passenger
             * 
             * @param list
             */
            public void setCustLoyaltyList(List<CustomerLoyaltyGroup> list) {
                custLoyaltyList = list;
            }

            /** 
             * Get the 'PassengerTypeQuantity' element value.
             * 
             * @return value
             */
            public PassengerTypeQuantityType getPassengerTypeQuantity() {
                return passengerTypeQuantity;
            }

            /** 
             * Set the 'PassengerTypeQuantity' element value.
             * 
             * @param passengerTypeQuantity
             */
            public void setPassengerTypeQuantity(
                    PassengerTypeQuantityType passengerTypeQuantity) {
                this.passengerTypeQuantity = passengerTypeQuantity;
            }

            /** 
             * Get the 'TravelerRefNumberGroup' attributeGroup value. Direct reference
            											of traveler assigned by requesting system. Used as a cross
            											reference between data segments.This value will be mapped
            											to the RPH value in TravelRefNumber of the
            											BaggageDetailsRequest element	
             * 
             * @return value
             */
            public TravelerRefNumberGroup getTravelerRefNumber() {
                return travelerRefNumber;
            }

            /** 
             * Set the 'TravelerRefNumberGroup' attributeGroup value. Direct reference
            											of traveler assigned by requesting system. Used as a cross
            											reference between data segments.This value will be mapped
            											to the RPH value in TravelRefNumber of the
            											BaggageDetailsRequest element	
             * 
             * @param travelerRefNumber
             */
            public void setTravelerRefNumber(
                    TravelerRefNumberGroup travelerRefNumber) {
                this.travelerRefNumber = travelerRefNumber;
            }

            /** 
             * Get the 'GenderGroup' attributeGroup value.
             * 
             * @return value
             */
            public GenderGroup getGenderGroup() {
                return genderGroup;
            }

            /** 
             * Set the 'GenderGroup' attributeGroup value.
             * 
             * @param genderGroup
             */
            public void setGenderGroup(GenderGroup genderGroup) {
                this.genderGroup = genderGroup;
            }

            /** 
             * Get the 'PrivacyGroup' attributeGroup value.
             * 
             * @return value
             */
            public PrivacyGroup getPrivacyGroup() {
                return privacyGroup;
            }

            /** 
             * Set the 'PrivacyGroup' attributeGroup value.
             * 
             * @param privacyGroup
             */
            public void setPrivacyGroup(PrivacyGroup privacyGroup) {
                this.privacyGroup = privacyGroup;
            }

            /** 
             * Get the 'BirthDate' attribute value.
             * 
             * @return value
             */
            public Date getBirthDate() {
                return birthDate;
            }

            /** 
             * Set the 'BirthDate' attribute value.
             * 
             * @param birthDate
             */
            public void setBirthDate(Date birthDate) {
                this.birthDate = birthDate;
            }

            /** 
             * Get the 'CurrencyCode' attribute value.
             * 
             * @return value
             */
            public String getCurrencyCode() {
                return currencyCode;
            }

            /** 
             * Set the 'CurrencyCode' attribute value.
             * 
             * @param currencyCode
             */
            public void setCurrencyCode(String currencyCode) {
                this.currencyCode = currencyCode;
            }

            /** 
             * Get the 'PassengerTypeCode' attribute value.
             * 
             * @return value
             */
            public String getPassengerTypeCode() {
                return passengerTypeCode;
            }

            /** 
             * Set the 'PassengerTypeCode' attribute value.
             * 
             * @param passengerTypeCode
             */
            public void setPassengerTypeCode(String passengerTypeCode) {
                this.passengerTypeCode = passengerTypeCode;
            }
        }
    }
}
