
package org.opentravel.ota;

import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

/** 
 * The Baggage Details
 Response message contains the baggage details for the request
 options given for the requested flight segments.

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AA_OTA_AirBaggageDetailsRS">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element type="ns:SuccessType" name="Success" minOccurs="0"/>
 *       &lt;xs:element type="ns:WarningsType" name="Warnings" minOccurs="0"/>
 *       &lt;xs:element type="xs:boolean" default="false" name="OnDBaggagesEnabled" minOccurs="0"/>
 *       &lt;xs:element name="BaggageDetailsResponses" minOccurs="0">
 *         &lt;!-- Reference to inner class BaggageDetailsResponses -->
 *       &lt;/xs:element>
 *       &lt;xs:element type="ns:ErrorsType" name="Errors" minOccurs="0"/>
 *     &lt;/xs:sequence>
 *     &lt;xs:attributeGroup ref="ns:OTA_PayloadStdAttributes"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class AAOTAAirBaggageDetailsRS
{
    private SuccessType success;
    private WarningsType warnings;
    private Boolean onDBaggagesEnabled;
    private BaggageDetailsResponses baggageDetailsResponses;
    private ErrorsType errors;
    private OTAPayloadStdAttributes OTAPayloadStdAttributes;

    /** 
     * Get the 'Success' element value.
     * 
     * @return value
     */
    public SuccessType getSuccess() {
        return success;
    }

    /** 
     * Set the 'Success' element value.
     * 
     * @param success
     */
    public void setSuccess(SuccessType success) {
        this.success = success;
    }

    /** 
     * Get the 'Warnings' element value.
     * 
     * @return value
     */
    public WarningsType getWarnings() {
        return warnings;
    }

    /** 
     * Set the 'Warnings' element value.
     * 
     * @param warnings
     */
    public void setWarnings(WarningsType warnings) {
        this.warnings = warnings;
    }

    /** 
     * Get the 'OnDBaggagesEnabled' element value.
     * 
     * @return value
     */
    public Boolean getOnDBaggagesEnabled() {
        return onDBaggagesEnabled;
    }

    /** 
     * Set the 'OnDBaggagesEnabled' element value.
     * 
     * @param onDBaggagesEnabled
     */
    public void setOnDBaggagesEnabled(Boolean onDBaggagesEnabled) {
        this.onDBaggagesEnabled = onDBaggagesEnabled;
    }

    /** 
     * Get the 'BaggageDetailsResponses' element value.
     * 
     * @return value
     */
    public BaggageDetailsResponses getBaggageDetailsResponses() {
        return baggageDetailsResponses;
    }

    /** 
     * Set the 'BaggageDetailsResponses' element value.
     * 
     * @param baggageDetailsResponses
     */
    public void setBaggageDetailsResponses(
            BaggageDetailsResponses baggageDetailsResponses) {
        this.baggageDetailsResponses = baggageDetailsResponses;
    }

    /** 
     * Get the 'Errors' element value.
     * 
     * @return value
     */
    public ErrorsType getErrors() {
        return errors;
    }

    /** 
     * Set the 'Errors' element value.
     * 
     * @param errors
     */
    public void setErrors(ErrorsType errors) {
        this.errors = errors;
    }

    /** 
     * Get the 'OTA_PayloadStdAttributes' attributeGroup value.
     * 
     * @return value
     */
    public OTAPayloadStdAttributes getOTAPayloadStdAttributes() {
        return OTAPayloadStdAttributes;
    }

    /** 
     * Set the 'OTA_PayloadStdAttributes' attributeGroup value.
     * 
     * @param OTAPayloadStdAttributes
     */
    public void setOTAPayloadStdAttributes(
            OTAPayloadStdAttributes OTAPayloadStdAttributes) {
        this.OTAPayloadStdAttributes = OTAPayloadStdAttributes;
    }
    /** 
     * Baggage details
    						response element containing the results of the request
    					
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaggageDetailsResponses" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="BaggageDetailsResponse" maxOccurs="99">
     *         &lt;!-- Reference to inner class BaggageDetailsResponse -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="OnDBaggageDetailsResponse" maxOccurs="99">
     *         &lt;!-- Reference to inner class OnDBaggageDetailsResponse -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="AirTravelers" minOccurs="0">
     *         &lt;!-- Reference to inner class AirTravelers -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class BaggageDetailsResponses
    {
        private List<BaggageDetailsResponse> baggageDetailsResponseList = new ArrayList<BaggageDetailsResponse>();
        private List<OnDBaggageDetailsResponse> onDBaggageDetailsResponseList = new ArrayList<OnDBaggageDetailsResponse>();
        private AirTravelers airTravelers;

        /** 
         * Get the list of 'BaggageDetailsResponse' element items.
         * 
         * @return list
         */
        public List<BaggageDetailsResponse> getBaggageDetailsResponseList() {
            return baggageDetailsResponseList;
        }

        /** 
         * Set the list of 'BaggageDetailsResponse' element items.
         * 
         * @param list
         */
        public void setBaggageDetailsResponseList(
                List<BaggageDetailsResponse> list) {
            baggageDetailsResponseList = list;
        }

        /** 
         * Get the list of 'OnDBaggageDetailsResponse' element items.
         * 
         * @return list
         */
        public List<OnDBaggageDetailsResponse> getOnDBaggageDetailsResponseList() {
            return onDBaggageDetailsResponseList;
        }

        /** 
         * Set the list of 'OnDBaggageDetailsResponse' element items.
         * 
         * @param list
         */
        public void setOnDBaggageDetailsResponseList(
                List<OnDBaggageDetailsResponse> list) {
            onDBaggageDetailsResponseList = list;
        }

        /** 
         * Get the 'AirTravelers' element value.
         * 
         * @return value
         */
        public AirTravelers getAirTravelers() {
            return airTravelers;
        }

        /** 
         * Set the 'AirTravelers' element value.
         * 
         * @param airTravelers
         */
        public void setAirTravelers(AirTravelers airTravelers) {
            this.airTravelers = airTravelers;
        }
        /** 
         * One
        									BaggageDetailsResponse element is returned for each of the
        									flight segment requested in the input request.
        								
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaggageDetailsResponse" maxOccurs="99">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="FlightSegmentInfo">
         *         &lt;xs:complexType>
         *           &lt;xs:complexContent>
         *             &lt;xs:extension base="ns:FlightSegmentType">
         *               &lt;xs:sequence>
         *                 &lt;xs:element type="ns:WarningsType" name="Warnings" minOccurs="0"/>
         *               &lt;/xs:sequence>
         *             &lt;/xs:extension>
         *           &lt;/xs:complexContent>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *       &lt;xs:element type="ns:Baggage" name="Baggage" maxOccurs="99"/>
         *       &lt;xs:element type="ns:UniqueID_Type" name="BookingReferenceID" minOccurs="0" maxOccurs="5"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class BaggageDetailsResponse
        {
            private FlightSegmentType flightSegmentInfoFlightSegmentType;
            private WarningsType flightSegmentInfoWarnings;
            private List<Baggage> baggageList = new ArrayList<Baggage>();
            private List<UniqueIDType> bookingReferenceIDList = new ArrayList<UniqueIDType>();

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public FlightSegmentType getFlightSegmentInfoFlightSegmentType() {
                return flightSegmentInfoFlightSegmentType;
            }

            /** 
             * Set the extension value.
             * 
             * @param flightSegmentInfoFlightSegmentType
             */
            public void setFlightSegmentInfoFlightSegmentType(
                    FlightSegmentType flightSegmentInfoFlightSegmentType) {
                this.flightSegmentInfoFlightSegmentType = flightSegmentInfoFlightSegmentType;
            }

            /** 
             * Get the 'Warnings' element value.
             * 
             * @return value
             */
            public WarningsType getFlightSegmentInfoWarnings() {
                return flightSegmentInfoWarnings;
            }

            /** 
             * Set the 'Warnings' element value.
             * 
             * @param flightSegmentInfoWarnings
             */
            public void setFlightSegmentInfoWarnings(
                    WarningsType flightSegmentInfoWarnings) {
                this.flightSegmentInfoWarnings = flightSegmentInfoWarnings;
            }

            /** 
             * Get the list of 'Baggage' element items. This identifies
            											the baggage details for the flight segment in the
            											corresponding 'FlightSegmentInfo' element.
            										
             * 
             * @return list
             */
            public List<Baggage> getBaggageList() {
                return baggageList;
            }

            /** 
             * Set the list of 'Baggage' element items. This identifies
            											the baggage details for the flight segment in the
            											corresponding 'FlightSegmentInfo' element.
            										
             * 
             * @param list
             */
            public void setBaggageList(List<Baggage> list) {
                baggageList = list;
            }

            /** 
             * Get the list of 'BookingReferenceID' element items. This is used
            											for PNR record locator. If there are more than one PNR
            											numbers because of muliple airlines in the itinerary then
            											this element could be repeated.
            										
             * 
             * @return list
             */
            public List<UniqueIDType> getBookingReferenceIDList() {
                return bookingReferenceIDList;
            }

            /** 
             * Set the list of 'BookingReferenceID' element items. This is used
            											for PNR record locator. If there are more than one PNR
            											numbers because of muliple airlines in the itinerary then
            											this element could be repeated.
            										
             * 
             * @param list
             */
            public void setBookingReferenceIDList(List<UniqueIDType> list) {
                bookingReferenceIDList = list;
            }
        }
        /** 
         * One
        									BaggageDetailsResponse element is returned for combine flight
        									segments requested in the input request.
        								
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OnDBaggageDetailsResponse" maxOccurs="99">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="OnDFlightSegmentInfo" maxOccurs="99">
         *         &lt;!-- Reference to inner class OnDFlightSegmentInfo -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="ns:Baggage" name="Baggage" maxOccurs="99"/>
         *       &lt;xs:element type="ns:UniqueID_Type" name="BookingReferenceID" minOccurs="0" maxOccurs="5"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class OnDBaggageDetailsResponse
        {
            private List<OnDFlightSegmentInfo> onDFlightSegmentInfoList = new ArrayList<OnDFlightSegmentInfo>();
            private List<Baggage> baggageList = new ArrayList<Baggage>();
            private List<UniqueIDType> bookingReferenceIDList = new ArrayList<UniqueIDType>();

            /** 
             * Get the list of 'OnDFlightSegmentInfo' element items.
             * 
             * @return list
             */
            public List<OnDFlightSegmentInfo> getOnDFlightSegmentInfoList() {
                return onDFlightSegmentInfoList;
            }

            /** 
             * Set the list of 'OnDFlightSegmentInfo' element items.
             * 
             * @param list
             */
            public void setOnDFlightSegmentInfoList(
                    List<OnDFlightSegmentInfo> list) {
                onDFlightSegmentInfoList = list;
            }

            /** 
             * Get the list of 'Baggage' element items. This identifies
            											the baggage details for the flight segment in the
            											corresponding 'FlightSegmentInfo' element.
            										
             * 
             * @return list
             */
            public List<Baggage> getBaggageList() {
                return baggageList;
            }

            /** 
             * Set the list of 'Baggage' element items. This identifies
            											the baggage details for the flight segment in the
            											corresponding 'FlightSegmentInfo' element.
            										
             * 
             * @param list
             */
            public void setBaggageList(List<Baggage> list) {
                baggageList = list;
            }

            /** 
             * Get the list of 'BookingReferenceID' element items. This is used
            											for PNR record locator. If there are more than one PNR
            											numbers because of muliple airlines in the itinerary then
            											this element could be repeated.
            										
             * 
             * @return list
             */
            public List<UniqueIDType> getBookingReferenceIDList() {
                return bookingReferenceIDList;
            }

            /** 
             * Set the list of 'BookingReferenceID' element items. This is used
            											for PNR record locator. If there are more than one PNR
            											numbers because of muliple airlines in the itinerary then
            											this element could be repeated.
            										
             * 
             * @param list
             */
            public void setBookingReferenceIDList(List<UniqueIDType> list) {
                bookingReferenceIDList = list;
            }
            /** 
             * The flight
            											segment for which the baggage details are sent.
            										
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OnDFlightSegmentInfo" maxOccurs="99">
             *   &lt;xs:complexType>
             *     &lt;xs:complexContent>
             *       &lt;xs:extension base="ns:FlightSegmentType">
             *         &lt;xs:sequence>
             *           &lt;xs:element type="ns:WarningsType" name="Warnings" minOccurs="0"/>
             *         &lt;/xs:sequence>
             *       &lt;/xs:extension>
             *     &lt;/xs:complexContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class OnDFlightSegmentInfo extends FlightSegmentType
            {
                private WarningsType warnings;

                /** 
                 * Get the 'Warnings' element value.
                 * 
                 * @return value
                 */
                public WarningsType getWarnings() {
                    return warnings;
                }

                /** 
                 * Set the 'Warnings' element value.
                 * 
                 * @param warnings
                 */
                public void setWarnings(WarningsType warnings) {
                    this.warnings = warnings;
                }
            }
        }
        /** 
         * Collection of
        									AirTravelers.
        								
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirTravelers" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="AirTraveler" maxOccurs="99">
         *         &lt;!-- Reference to inner class AirTraveler -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class AirTravelers
        {
            private List<AirTraveler> airTravelerList = new ArrayList<AirTraveler>();

            /** 
             * Get the list of 'AirTraveler' element items.
             * 
             * @return list
             */
            public List<AirTraveler> getAirTravelerList() {
                return airTravelerList;
            }

            /** 
             * Set the list of 'AirTraveler' element items.
             * 
             * @param list
             */
            public void setAirTravelerList(List<AirTraveler> list) {
                airTravelerList = list;
            }
            /** 
             * This specifies
            											the quantity and types of passengers.
            										
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirTraveler" maxOccurs="99">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="ns:PersonNameType" name="PersonName" minOccurs="0"/>
             *       &lt;xs:element name="CustLoyalty" minOccurs="0" maxOccurs="5">
             *         &lt;xs:complexType>
             *           &lt;xs:attributeGroup ref="ns:CustomerLoyaltyGroup"/>
             *         &lt;/xs:complexType>
             *       &lt;/xs:element>
             *       &lt;xs:element type="ns:PassengerTypeQuantityType" name="PassengerTypeQuantity" minOccurs="0"/>
             *       &lt;xs:element name="TravelerRefNumber" minOccurs="0">
             *         &lt;xs:complexType>
             *           &lt;xs:attributeGroup ref="ns:TravelerRefNumberGroup"/>
             *         &lt;/xs:complexType>
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attributeGroup ref="ns:GenderGroup"/>
             *     &lt;xs:attributeGroup ref="ns:PrivacyGroup"/>
             *     &lt;xs:attribute type="xs:date" name="BirthDate"/>
             *     &lt;xs:attribute type="xs:string" name="CurrencyCode"/>
             *     &lt;xs:attribute type="xs:string" use="required" name="PassengerTypeCode"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class AirTraveler
            {
                private PersonNameType personName;
                private List<CustomerLoyaltyGroup> custLoyaltyList = new ArrayList<CustomerLoyaltyGroup>();
                private PassengerTypeQuantityType passengerTypeQuantity;
                private TravelerRefNumberGroup travelerRefNumber;
                private GenderGroup genderGroup;
                private PrivacyGroup privacyGroup;
                private Date birthDate;
                private String currencyCode;
                private String passengerTypeCode;

                /** 
                 * Get the 'PersonName' element value. Individuals
                														complete name information
                													
                 * 
                 * @return value
                 */
                public PersonNameType getPersonName() {
                    return personName;
                }

                /** 
                 * Set the 'PersonName' element value. Individuals
                														complete name information
                													
                 * 
                 * @param personName
                 */
                public void setPersonName(PersonNameType personName) {
                    this.personName = personName;
                }

                /** 
                 * Get the list of 'CustLoyalty' element items. Frequent
                														Flier information of the passenger
                													
                 * 
                 * @return list
                 */
                public List<CustomerLoyaltyGroup> getCustLoyaltyList() {
                    return custLoyaltyList;
                }

                /** 
                 * Set the list of 'CustLoyalty' element items. Frequent
                														Flier information of the passenger
                													
                 * 
                 * @param list
                 */
                public void setCustLoyaltyList(List<CustomerLoyaltyGroup> list) {
                    custLoyaltyList = list;
                }

                /** 
                 * Get the 'PassengerTypeQuantity' element value.
                 * 
                 * @return value
                 */
                public PassengerTypeQuantityType getPassengerTypeQuantity() {
                    return passengerTypeQuantity;
                }

                /** 
                 * Set the 'PassengerTypeQuantity' element value.
                 * 
                 * @param passengerTypeQuantity
                 */
                public void setPassengerTypeQuantity(
                        PassengerTypeQuantityType passengerTypeQuantity) {
                    this.passengerTypeQuantity = passengerTypeQuantity;
                }

                /** 
                 * Get the 'TravelerRefNumberGroup' attributeGroup value. Direct
                														reference of traveler assigned by requesting system.
                														Used as a cross reference between data segments.This
                														value will be mapped to the RPH value in
                														TravelRefNumber of the BaggageDetailsRequest element
                													
                 * 
                 * @return value
                 */
                public TravelerRefNumberGroup getTravelerRefNumber() {
                    return travelerRefNumber;
                }

                /** 
                 * Set the 'TravelerRefNumberGroup' attributeGroup value. Direct
                														reference of traveler assigned by requesting system.
                														Used as a cross reference between data segments.This
                														value will be mapped to the RPH value in
                														TravelRefNumber of the BaggageDetailsRequest element
                													
                 * 
                 * @param travelerRefNumber
                 */
                public void setTravelerRefNumber(
                        TravelerRefNumberGroup travelerRefNumber) {
                    this.travelerRefNumber = travelerRefNumber;
                }

                /** 
                 * Get the 'GenderGroup' attributeGroup value.
                 * 
                 * @return value
                 */
                public GenderGroup getGenderGroup() {
                    return genderGroup;
                }

                /** 
                 * Set the 'GenderGroup' attributeGroup value.
                 * 
                 * @param genderGroup
                 */
                public void setGenderGroup(GenderGroup genderGroup) {
                    this.genderGroup = genderGroup;
                }

                /** 
                 * Get the 'PrivacyGroup' attributeGroup value.
                 * 
                 * @return value
                 */
                public PrivacyGroup getPrivacyGroup() {
                    return privacyGroup;
                }

                /** 
                 * Set the 'PrivacyGroup' attributeGroup value.
                 * 
                 * @param privacyGroup
                 */
                public void setPrivacyGroup(PrivacyGroup privacyGroup) {
                    this.privacyGroup = privacyGroup;
                }

                /** 
                 * Get the 'BirthDate' attribute value.
                 * 
                 * @return value
                 */
                public Date getBirthDate() {
                    return birthDate;
                }

                /** 
                 * Set the 'BirthDate' attribute value.
                 * 
                 * @param birthDate
                 */
                public void setBirthDate(Date birthDate) {
                    this.birthDate = birthDate;
                }

                /** 
                 * Get the 'CurrencyCode' attribute value.
                 * 
                 * @return value
                 */
                public String getCurrencyCode() {
                    return currencyCode;
                }

                /** 
                 * Set the 'CurrencyCode' attribute value.
                 * 
                 * @param currencyCode
                 */
                public void setCurrencyCode(String currencyCode) {
                    this.currencyCode = currencyCode;
                }

                /** 
                 * Get the 'PassengerTypeCode' attribute value.
                 * 
                 * @return value
                 */
                public String getPassengerTypeCode() {
                    return passengerTypeCode;
                }

                /** 
                 * Set the 'PassengerTypeCode' attribute value.
                 * 
                 * @param passengerTypeCode
                 */
                public void setPassengerTypeCode(String passengerTypeCode) {
                    this.passengerTypeCode = passengerTypeCode;
                }
            }
        }
    }
}
