
package org.opentravel.ota;

import java.util.ArrayList;
import java.util.List;

/** 
 * Container for priced itineraries.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AAPricedItinerariesType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:PricedItineraryType" name="PricedItinerary" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:boolean" use="required" name="SelectedPriceQuote"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AAPricedItinerariesType
{
    private List<PricedItineraryType> pricedItineraryList = new ArrayList<PricedItineraryType>();
    private boolean selectedPriceQuote;

    /** 
     * Get the list of 'PricedItinerary' element items. Itinerary with pricing information.
     * 
     * @return list
     */
    public List<PricedItineraryType> getPricedItineraryList() {
        return pricedItineraryList;
    }

    /** 
     * Set the list of 'PricedItinerary' element items. Itinerary with pricing information.
     * 
     * @param list
     */
    public void setPricedItineraryList(List<PricedItineraryType> list) {
        pricedItineraryList = list;
    }

    /** 
     * Get the 'SelectedPriceQuote' attribute value. Indicates if this is the selected price quote
     * 
     * @return value
     */
    public boolean isSelectedPriceQuote() {
        return selectedPriceQuote;
    }

    /** 
     * Set the 'SelectedPriceQuote' attribute value. Indicates if this is the selected price quote
     * 
     * @param selectedPriceQuote
     */
    public void setSelectedPriceQuote(boolean selectedPriceQuote) {
        this.selectedPriceQuote = selectedPriceQuote;
    }
}
