
package org.opentravel.ota;

import java.util.ArrayList;
import java.util.List;

/** 
 * 
 Specifies the origin and destination of the traveler. Attributes: DirectionInd - A directional indicator
 that identifies a type of air booking, either one-way, round-trip, or open-jaw with the enumeration of
 (OneWay | RT | OpenJaw) respectively. ActionCode - Indicates the status of the booking, such as OK or
 Wait-List. NumberInParty - Indicates the traveler count.

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirItineraryType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="OriginDestinationOptions">
 *       &lt;xs:complexType>
 *         &lt;xs:sequence>
 *           &lt;xs:element type="ns:OriginDestinationOptionType" name="OriginDestinationOption" maxOccurs="99"/>
 *           &lt;xs:element type="ns:AABundledServiceExt" name="AABundledServiceExt" minOccurs="0" maxOccurs="unbounded"/>
 *         &lt;/xs:sequence>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="ns:AirTripType" use="optional" name="DirectionInd"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AirItineraryType
{
    private List<OriginDestinationOptionType> originDestinationOptionsOriginDestinationOptionList = new ArrayList<OriginDestinationOptionType>();
    private List<AABundledServiceExt> originDestinationOptionsAABundledServiceExtList = new ArrayList<AABundledServiceExt>();
    private AirTripType directionInd;

    /** 
     * Get the list of 'OriginDestinationOption' element items. A container for OriginDestinationOptionType.
                                  
     * 
     * @return list
     */
    public List<OriginDestinationOptionType> getOriginDestinationOptionsOriginDestinationOptionList() {
        return originDestinationOptionsOriginDestinationOptionList;
    }

    /** 
     * Set the list of 'OriginDestinationOption' element items. A container for OriginDestinationOptionType.
                                  
     * 
     * @param list
     */
    public void setOriginDestinationOptionsOriginDestinationOptionList(
            List<OriginDestinationOptionType> list) {
        originDestinationOptionsOriginDestinationOptionList = list;
    }

    /** 
     * Get the list of 'AABundledServiceExt' element items. Available bundled services for OnD
     * 
     * @return list
     */
    public List<AABundledServiceExt> getOriginDestinationOptionsAABundledServiceExtList() {
        return originDestinationOptionsAABundledServiceExtList;
    }

    /** 
     * Set the list of 'AABundledServiceExt' element items. Available bundled services for OnD
     * 
     * @param list
     */
    public void setOriginDestinationOptionsAABundledServiceExtList(
            List<AABundledServiceExt> list) {
        originDestinationOptionsAABundledServiceExtList = list;
    }

    /** 
     * Get the 'DirectionInd' attribute value. 
                      Identifies whether travel is: one way, return trip, circle trip, open jaw, other.
                  
     * 
     * @return value
     */
    public AirTripType getDirectionInd() {
        return directionInd;
    }

    /** 
     * Set the 'DirectionInd' attribute value. 
                      Identifies whether travel is: one way, return trip, circle trip, open jaw, other.
                  
     * 
     * @param directionInd
     */
    public void setDirectionInd(AirTripType directionInd) {
        this.directionInd = directionInd;
    }
}
