
package org.opentravel.ota;

import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AutomaticCheckinDetailsResponseType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:BookFlightSegmentType" name="FlightSegmentInfo" minOccurs="0" maxOccurs="4"/>
 *     &lt;xs:element type="ns:AutomaticCheckinInfoType" name="AutomaticCheckin" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="airportCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="airportType"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AutomaticCheckinDetailsResponseType
{
    private List<BookFlightSegmentType> flightSegmentInfoList = new ArrayList<BookFlightSegmentType>();
    private AutomaticCheckinInfoType automaticCheckin;
    private String airportCode;
    private String airportType;

    /** 
     * Get the list of 'FlightSegmentInfo' element items.
     * 
     * @return list
     */
    public List<BookFlightSegmentType> getFlightSegmentInfoList() {
        return flightSegmentInfoList;
    }

    /** 
     * Set the list of 'FlightSegmentInfo' element items.
     * 
     * @param list
     */
    public void setFlightSegmentInfoList(List<BookFlightSegmentType> list) {
        flightSegmentInfoList = list;
    }

    /** 
     * Get the 'AutomaticCheckin' element value.
     * 
     * @return value
     */
    public AutomaticCheckinInfoType getAutomaticCheckin() {
        return automaticCheckin;
    }

    /** 
     * Set the 'AutomaticCheckin' element value.
     * 
     * @param automaticCheckin
     */
    public void setAutomaticCheckin(AutomaticCheckinInfoType automaticCheckin) {
        this.automaticCheckin = automaticCheckin;
    }

    /** 
     * Get the 'airportCode' attribute value. Used to provide the requested airport code.
     * 
     * @return value
     */
    public String getAirportCode() {
        return airportCode;
    }

    /** 
     * Set the 'airportCode' attribute value. Used to provide the requested airport code.
     * 
     * @param airportCode
     */
    public void setAirportCode(String airportCode) {
        this.airportCode = airportCode;
    }

    /** 
     * Get the 'airportType' attribute value. Used to provide the ariport type.
     * 
     * @return value
     */
    public String getAirportType() {
        return airportType;
    }

    /** 
     * Set the 'airportType' attribute value. Used to provide the ariport type.
     * 
     * @param airportType
     */
    public void setAirportType(String airportType) {
        this.airportType = airportType;
    }
}
