
package org.opentravel.ota;

/** 
 * 
 Attributes for baggage request. Note: you can choose a specific baggage or just a general preference

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:attributeGroup xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaggageRequestAttributes">
 *   &lt;xs:attribute type="xs:string" use="required" name="baggageCode"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="baggageOndGroupId"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class BaggageRequestAttributes
{
    private String baggageCode;
    private String baggageOndGroupId;

    /** 
     * Get the 'baggageCode' attribute value. Used to provide the baggage code.
     * 
     * @return value
     */
    public String getBaggageCode() {
        return baggageCode;
    }

    /** 
     * Set the 'baggageCode' attribute value. Used to provide the baggage code.
     * 
     * @param baggageCode
     */
    public void setBaggageCode(String baggageCode) {
        this.baggageCode = baggageCode;
    }

    /** 
     * Get the 'baggageOndGroupId' attribute value. 
                      Used to provide the baggage OnD group id in case ond baggages available.
                  
     * 
     * @return value
     */
    public String getBaggageOndGroupId() {
        return baggageOndGroupId;
    }

    /** 
     * Set the 'baggageOndGroupId' attribute value. 
                      Used to provide the baggage OnD group id in case ond baggages available.
                  
     * 
     * @param baggageOndGroupId
     */
    public void setBaggageOndGroupId(String baggageOndGroupId) {
        this.baggageOndGroupId = baggageOndGroupId;
    }
}
