
package org.opentravel.ota;

import java.util.Date;

/** 
 * Object to hold a passengers' baggage request
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaggageRequestType">
 *   &lt;xs:attributeGroup ref="ns:BaggageRequestAttributes"/>
 *   &lt;xs:attribute type="xs:dateTime" use="optional" name="DepartureDate"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="FlightNumber"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class BaggageRequestType
{
    private BaggageRequestAttributes baggageRequestAttributes;
    private Date departureDate;
    private String flightNumber;

    /** 
     * Get the 'BaggageRequestAttributes' attributeGroup value. Attributes for baggage request
     * 
     * @return value
     */
    public BaggageRequestAttributes getBaggageRequestAttributes() {
        return baggageRequestAttributes;
    }

    /** 
     * Set the 'BaggageRequestAttributes' attributeGroup value. Attributes for baggage request
     * 
     * @param baggageRequestAttributes
     */
    public void setBaggageRequestAttributes(
            BaggageRequestAttributes baggageRequestAttributes) {
        this.baggageRequestAttributes = baggageRequestAttributes;
    }

    /** 
     * Get the 'DepartureDate' attribute value. 
                      The departure date of the flight for the baggage requested.
                  
     * 
     * @return value
     */
    public Date getDepartureDate() {
        return departureDate;
    }

    /** 
     * Set the 'DepartureDate' attribute value. 
                      The departure date of the flight for the baggage requested.
                  
     * 
     * @param departureDate
     */
    public void setDepartureDate(Date departureDate) {
        this.departureDate = departureDate;
    }

    /** 
     * Get the 'FlightNumber' attribute value. 
                      The number of the flight for which this baggage is requested.
                  
     * 
     * @return value
     */
    public String getFlightNumber() {
        return flightNumber;
    }

    /** 
     * Set the 'FlightNumber' attribute value. 
                      The number of the flight for which this baggage is requested.
                  
     * 
     * @param flightNumber
     */
    public void setFlightNumber(String flightNumber) {
        this.flightNumber = flightNumber;
    }
}
