
package org.opentravel.ota;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BundledService">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:int" name="bunldedServiceId" minOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="bundledServiceName" minOccurs="1"/>
 *     &lt;xs:element type="xs:decimal" name="perPaxBundledFee" minOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="bookingClasses" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:StringStringMap" name="segmentBookingClass" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="description" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="includedServies" minOccurs="1" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class BundledService
{
    private int bunldedServiceId;
    private String bundledServiceName;
    private BigDecimal perPaxBundledFee;
    private List<String> bookingClassList = new ArrayList<String>();
    private List<StringStringMap> segmentBookingClassList = new ArrayList<StringStringMap>();
    private String description;
    private List<String> includedServyList = new ArrayList<String>();

    /** 
     * Get the 'bunldedServiceId' element value.
     * 
     * @return value
     */
    public int getBunldedServiceId() {
        return bunldedServiceId;
    }

    /** 
     * Set the 'bunldedServiceId' element value.
     * 
     * @param bunldedServiceId
     */
    public void setBunldedServiceId(int bunldedServiceId) {
        this.bunldedServiceId = bunldedServiceId;
    }

    /** 
     * Get the 'bundledServiceName' element value.
     * 
     * @return value
     */
    public String getBundledServiceName() {
        return bundledServiceName;
    }

    /** 
     * Set the 'bundledServiceName' element value.
     * 
     * @param bundledServiceName
     */
    public void setBundledServiceName(String bundledServiceName) {
        this.bundledServiceName = bundledServiceName;
    }

    /** 
     * Get the 'perPaxBundledFee' element value.
     * 
     * @return value
     */
    public BigDecimal getPerPaxBundledFee() {
        return perPaxBundledFee;
    }

    /** 
     * Set the 'perPaxBundledFee' element value.
     * 
     * @param perPaxBundledFee
     */
    public void setPerPaxBundledFee(BigDecimal perPaxBundledFee) {
        this.perPaxBundledFee = perPaxBundledFee;
    }

    /** 
     * Get the list of 'bookingClasses' element items.
     * 
     * @return list
     */
    public List<String> getBookingClassList() {
        return bookingClassList;
    }

    /** 
     * Set the list of 'bookingClasses' element items.
     * 
     * @param list
     */
    public void setBookingClassList(List<String> list) {
        bookingClassList = list;
    }

    /** 
     * Get the list of 'segmentBookingClass' element items.
     * 
     * @return list
     */
    public List<StringStringMap> getSegmentBookingClassList() {
        return segmentBookingClassList;
    }

    /** 
     * Set the list of 'segmentBookingClass' element items.
     * 
     * @param list
     */
    public void setSegmentBookingClassList(List<StringStringMap> list) {
        segmentBookingClassList = list;
    }

    /** 
     * Get the 'description' element value.
     * 
     * @return value
     */
    public String getDescription() {
        return description;
    }

    /** 
     * Set the 'description' element value.
     * 
     * @param description
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /** 
     * Get the list of 'includedServies' element items.
     * 
     * @return list
     */
    public List<String> getIncludedServyList() {
        return includedServyList;
    }

    /** 
     * Set the list of 'includedServies' element items.
     * 
     * @param list
     */
    public void setIncludedServyList(List<String> list) {
        includedServyList = list;
    }
}
