
package org.opentravel.ota;

/** 
 * A cabin is either First,
 Business or Economy 
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CabinType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="F"/>
 *     &lt;xs:enumeration value="C"/>
 *     &lt;xs:enumeration value="J"/>
 *     &lt;xs:enumeration value="Y"/>
 *     &lt;xs:enumeration value="W"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum CabinType {
    /** 
     * First class
    compartment. 
     */
    F, /** 
        * Business class
       					compartment. 
        */
    C, /** 
        * Business Premium class
       					compartment. 
        */
    J, /** 
        * Economy (or sometimes
       					referred to as Coach) class compartment.
        */
    Y, /** 
        * Economy Premium class
       					compartment.
        */
    W
}
