
package org.opentravel.ota;

/** 
 * Attributes for Eticket Info
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:attributeGroup xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EticketAttributes">
 *   &lt;xs:attribute type="xs:string" use="required" name="flightSegmentRPH"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="flightSegmentCode"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="eTicketNo"/>
 *   &lt;xs:attribute type="xs:int" use="required" name="couponNo"/>
 *   &lt;xs:attribute type="ns:ETicketStatusType" use="required" name="status"/>
 *   &lt;xs:attribute type="ns:ETicketUsedStatusType" use="required" name="usedStatus"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class EticketAttributes
{
    private String flightSegmentRPH;
    private String flightSegmentCode;
    private String ETicketNo;
    private int couponNo;
    private ETicketStatusType status;
    private ETicketUsedStatusType usedStatus;

    /** 
     * Get the 'flightSegmentRPH' attribute value. Used to provide the flight Segment RPH.
     * 
     * @return value
     */
    public String getFlightSegmentRPH() {
        return flightSegmentRPH;
    }

    /** 
     * Set the 'flightSegmentRPH' attribute value. Used to provide the flight Segment RPH.
     * 
     * @param flightSegmentRPH
     */
    public void setFlightSegmentRPH(String flightSegmentRPH) {
        this.flightSegmentRPH = flightSegmentRPH;
    }

    /** 
     * Get the 'flightSegmentCode' attribute value. Used to provide the flight segment code.
     * 
     * @return value
     */
    public String getFlightSegmentCode() {
        return flightSegmentCode;
    }

    /** 
     * Set the 'flightSegmentCode' attribute value. Used to provide the flight segment code.
     * 
     * @param flightSegmentCode
     */
    public void setFlightSegmentCode(String flightSegmentCode) {
        this.flightSegmentCode = flightSegmentCode;
    }

    /** 
     * Get the 'eTicketNo' attribute value. Used to provide the eTicket Number.
     * 
     * @return value
     */
    public String getETicketNo() {
        return ETicketNo;
    }

    /** 
     * Set the 'eTicketNo' attribute value. Used to provide the eTicket Number.
     * 
     * @param eTicketNo
     */
    public void setETicketNo(String eTicketNo) {
        ETicketNo = eTicketNo;
    }

    /** 
     * Get the 'couponNo' attribute value. Used to provide the coupon number.
     * 
     * @return value
     */
    public int getCouponNo() {
        return couponNo;
    }

    /** 
     * Set the 'couponNo' attribute value. Used to provide the coupon number.
     * 
     * @param couponNo
     */
    public void setCouponNo(int couponNo) {
        this.couponNo = couponNo;
    }

    /** 
     * Get the 'status' attribute value. Used to provide the ETicket Status.
     * 
     * @return value
     */
    public ETicketStatusType getStatus() {
        return status;
    }

    /** 
     * Set the 'status' attribute value. Used to provide the ETicket Status.
     * 
     * @param status
     */
    public void setStatus(ETicketStatusType status) {
        this.status = status;
    }

    /** 
     * Get the 'usedStatus' attribute value. Used to provide the ETicket Used Status.
     * 
     * @return value
     */
    public ETicketUsedStatusType getUsedStatus() {
        return usedStatus;
    }

    /** 
     * Set the 'usedStatus' attribute value. Used to provide the ETicket Used Status.
     * 
     * @param usedStatus
     */
    public void setUsedStatus(ETicketUsedStatusType usedStatus) {
        this.usedStatus = usedStatus;
    }
}
