
package org.opentravel.ota;

import java.util.ArrayList;
import java.util.List;

/** 
 * Information regarding the flexible fare.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlexiFareType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="FlexiFareAmount" minOccurs="0">
 *       &lt;xs:complexType>
 *         &lt;xs:attributeGroup ref="ns:CurrencyAmountGroup"/>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:string" name="FlexibilityDescription" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element name="AllowedFlexiOperations">
 *       &lt;xs:complexType>
 *         &lt;xs:sequence>
 *           &lt;xs:element type="ns:FlexiOperationsType" name="FlexiOperations" maxOccurs="10"/>
 *         &lt;/xs:sequence>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *     &lt;xs:element name="PerPaxFlexifareBDS">
 *       &lt;xs:complexType>
 *         &lt;xs:sequence>
 *           &lt;xs:element type="ns:PerPaxFlexifareBDType" name="PerPaxFlexifareBD" maxOccurs="10"/>
 *         &lt;/xs:sequence>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:string" name="FlexiRuleComment" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="FlexiRuleCode" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="ns:AirTripType" use="optional" name="ApplicableJourneyType"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FlexiFareType
{
    private CurrencyAmountGroup flexiFareAmount;
    private String flexibilityDescription;
    private List<FlexiOperationsType> allowedFlexiOperationList = new ArrayList<FlexiOperationsType>();
    private List<PerPaxFlexifareBDType> perPaxFlexifareBDSList = new ArrayList<PerPaxFlexifareBDType>();
    private String flexiRuleComment;
    private String flexiRuleCode;
    private AirTripType applicableJourneyType;

    /** 
     * Get the 'CurrencyAmountGroup' attributeGroup value. 
                          The amount the passenger would have to pay for this flexibile fare.
                      
     * 
     * @return value
     */
    public CurrencyAmountGroup getFlexiFareAmount() {
        return flexiFareAmount;
    }

    /** 
     * Set the 'CurrencyAmountGroup' attributeGroup value. 
                          The amount the passenger would have to pay for this flexibile fare.
                      
     * 
     * @param flexiFareAmount
     */
    public void setFlexiFareAmount(CurrencyAmountGroup flexiFareAmount) {
        this.flexiFareAmount = flexiFareAmount;
    }

    /** 
     * Get the 'FlexibilityDescription' element value. The description of the available flexi fare.
     * 
     * @return value
     */
    public String getFlexibilityDescription() {
        return flexibilityDescription;
    }

    /** 
     * Set the 'FlexibilityDescription' element value. The description of the available flexi fare.
     * 
     * @param flexibilityDescription
     */
    public void setFlexibilityDescription(String flexibilityDescription) {
        this.flexibilityDescription = flexibilityDescription;
    }

    /** 
     * Get the list of 'FlexiOperations' element items. The breakdown of flexifare
     * 
     * @return list
     */
    public List<FlexiOperationsType> getAllowedFlexiOperationList() {
        return allowedFlexiOperationList;
    }

    /** 
     * Set the list of 'FlexiOperations' element items. The breakdown of flexifare
     * 
     * @param list
     */
    public void setAllowedFlexiOperationList(List<FlexiOperationsType> list) {
        allowedFlexiOperationList = list;
    }

    /** 
     * Get the list of 'PerPaxFlexifareBD' element items. The breakdown of flexifare presented per pax wise
     * 
     * @return list
     */
    public List<PerPaxFlexifareBDType> getPerPaxFlexifareBDSList() {
        return perPaxFlexifareBDSList;
    }

    /** 
     * Set the list of 'PerPaxFlexifareBD' element items. The breakdown of flexifare presented per pax wise
     * 
     * @param list
     */
    public void setPerPaxFlexifareBDSList(List<PerPaxFlexifareBDType> list) {
        perPaxFlexifareBDSList = list;
    }

    /** 
     * Get the 'FlexiRuleComment' element value. 
                          The flexi rule comment of the available flexi fare.
                      
     * 
     * @return value
     */
    public String getFlexiRuleComment() {
        return flexiRuleComment;
    }

    /** 
     * Set the 'FlexiRuleComment' element value. 
                          The flexi rule comment of the available flexi fare.
                      
     * 
     * @param flexiRuleComment
     */
    public void setFlexiRuleComment(String flexiRuleComment) {
        this.flexiRuleComment = flexiRuleComment;
    }

    /** 
     * Get the 'FlexiRuleCode' element value. The flexi rule code of the available flexi fare.
     * 
     * @return value
     */
    public String getFlexiRuleCode() {
        return flexiRuleCode;
    }

    /** 
     * Set the 'FlexiRuleCode' element value. The flexi rule code of the available flexi fare.
     * 
     * @param flexiRuleCode
     */
    public void setFlexiRuleCode(String flexiRuleCode) {
        this.flexiRuleCode = flexiRuleCode;
    }

    /** 
     * Get the 'ApplicableJourneyType' attribute value. 
                      Indicates the applicable journey type of the flexi fare.
                  
     * 
     * @return value
     */
    public AirTripType getApplicableJourneyType() {
        return applicableJourneyType;
    }

    /** 
     * Set the 'ApplicableJourneyType' attribute value. 
                      Indicates the applicable journey type of the flexi fare.
                  
     * 
     * @param applicableJourneyType
     */
    public void setApplicableJourneyType(AirTripType applicableJourneyType) {
        this.applicableJourneyType = applicableJourneyType;
    }
}
