
package org.opentravel.ota;

import java.math.BigInteger;

/** 
 * The allowing flexibility types.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlexiOperationsType">
 *   &lt;xs:attribute type="xs:string" use="optional" name="AllowedOperationName"/>
 *   &lt;xs:attribute type="xs:integer" use="optional" name="NumberOfAllowedOperations"/>
 *   &lt;xs:attribute type="xs:integer" use="optional" name="FlexiOperationCutoverTimeInMinutes"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FlexiOperationsType
{
    private String allowedOperationName;
    private BigInteger numberOfAllowedOperations;
    private BigInteger flexiOperationCutoverTimeInMinutes;

    /** 
     * Get the 'AllowedOperationName' attribute value. 
                      The allowed operation name available with the flexibility.
                  
     * 
     * @return value
     */
    public String getAllowedOperationName() {
        return allowedOperationName;
    }

    /** 
     * Set the 'AllowedOperationName' attribute value. 
                      The allowed operation name available with the flexibility.
                  
     * 
     * @param allowedOperationName
     */
    public void setAllowedOperationName(String allowedOperationName) {
        this.allowedOperationName = allowedOperationName;
    }

    /** 
     * Get the 'NumberOfAllowedOperations' attribute value. The number of times the operation is allowed.
     * 
     * @return value
     */
    public BigInteger getNumberOfAllowedOperations() {
        return numberOfAllowedOperations;
    }

    /** 
     * Set the 'NumberOfAllowedOperations' attribute value. The number of times the operation is allowed.
     * 
     * @param numberOfAllowedOperations
     */
    public void setNumberOfAllowedOperations(
            BigInteger numberOfAllowedOperations) {
        this.numberOfAllowedOperations = numberOfAllowedOperations;
    }

    /** 
     * Get the 'FlexiOperationCutoverTimeInMinutes' attribute value. The cutover time of the flexibility operation.
     * 
     * @return value
     */
    public BigInteger getFlexiOperationCutoverTimeInMinutes() {
        return flexiOperationCutoverTimeInMinutes;
    }

    /** 
     * Set the 'FlexiOperationCutoverTimeInMinutes' attribute value. The cutover time of the flexibility operation.
     * 
     * @param flexiOperationCutoverTimeInMinutes
     */
    public void setFlexiOperationCutoverTimeInMinutes(
            BigInteger flexiOperationCutoverTimeInMinutes) {
        this.flexiOperationCutoverTimeInMinutes = flexiOperationCutoverTimeInMinutes;
    }
}
